<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Parametros';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="configuracion-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
    </div>
    <div class="kt-portlet__body">
        <p>
            <?= Html::a('Crear Configuracion', ['create'], ['class' => 'btn btn-success']) ?>
        </p>

        
            <?= GridView::widget([
            'dataProvider' => $dataProvider,
            'summary' => 'Mostrando {begin} - {end} de {totalCount} ítems',
            'columns' => [
                ['class' => 'yii\grid\SerialColumn'],

                'id',
            'llave',
            'valor',
            'descripcion',
            'orden',    

                [
                    'class' => 'app\customs\ActionColumn',
                    'template' => '{view} {update}',
                ],
            ],
        ]); ?>
    
    
    </div>
</div>
