<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use app\models\PermisoUsuario;
use app\models\UsuarioSuscripcion;
/* @var $this yii\web\View */
/* @var $model app\models\Usuario */
/* @var $usuarioSuscripcion app\models\UsuarioSuscripcion */

$this->title = $model->nombre_usuario;
$this->params['breadcrumbs'][] = ['label' => 'Colegas', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
$userId = $model->usuarioSuscripcion->usuario->id;
?>
<div class="usuario-view " style="text-shadow: none;">
    <div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
        <div class="row" style="text-shadow: none;">
            <div class="col-xl-12" style="text-shadow: none;">
                <!--begin:: Widgets/Applications/User/Profile3-->
                <div class="kt-portlet kt-portlet--height-fluid" style="text-shadow: none;">
                    <div class="kt-portlet__body" style="text-shadow: none;">
                        <div class="kt-widget kt-widget--user-profile-3" style="text-shadow: none;">

                            <div class="kt-widget__top" style="text-shadow: none;">

                                <div class="kt-widget__content">
                                    <div class="kt-widget__head">
                                        <p>
                                            <a href="#" class="kt-portlet__head-title" style="margin-left: -20px;font-size: 1.8rem; 
                                               font-weight:500; color: #464457; ">
                                               <?= $model->perfil->nombreCompleto?>

                                            </a>

                                        </p>
                                        <div class="kt-widget__action " style="margin-left:-55px;">
                                            <p class="d-none d-md-block">
                                                <?=
                                                Html::a('Restablecer Contraseña', ['update-password', 'id' => $usuarioSuscripcion->id], [
                                                    'class' => 'btn btn-success',
                                                    'data' => [
                                                        'confirm' => '¿Está seguro de Cambiar la contraseña de este usuario?',
                                                        'method' => 'post',
                                                    ],
                                                ])
                                                ?>
                                                <?= Html::a('Actualizar', ['update', 'id' => $usuarioSuscripcion->id], ['class' => 'btn btn-primary']) ?>
                                                <?=
                                                Html::a('Eliminar', ['delete', 'id' => $usuarioSuscripcion->id], [
                                                    'class' => 'btn btn-danger',
                                                    'data' => [
                                                        'confirm' => '¿Está seguro de eliminar este elemento?',
                                                        'method' => 'post',
                                                    ],
                                                ])
                                                ?>
                                            </p>
                                        </div>

                                    </div>
                                    <div class="d-md-none">
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-secondary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="margin-left: 0 !important;">
                                                Opciones
                                            </button>
                                            <div class="dropdown-menu">
                                                <?= Html::a('<i class="la la-edit kt-font-primary mt-2"></i>Actualizar', ['update', 'id' => $usuarioSuscripcion->id], ['class' => 'dropdown-item']) ?>
                                                <div class="dropdown-divider"></div>
                                                <?= Html::a('<i class="la la-undo kt-font-success mt-2"></i>Restablecer Contraseña', ['updatepassword', 'id' => $usuarioSuscripcion->id], [
                                                    'class' => 'dropdown-item',
                                                    'data' => [
                                                        'confirm' => '¿Está seguro de Cambiar la contraseña de este usuario?',
                                                        'method' => 'post',
                                                    ],
                                                ]) ?>
                                                <div class="dropdown-divider"></div>
                                                <?= Html::a('<i class="la la-trash kt-font-danger mt-2"></i>Eliminar', ['delete', 'id' => $usuarioSuscripcion->id], [
                                                'class' => 'dropdown-item',
                                                'data' => [
                                                    'confirm' => '¿Está seguro de eliminar este elemento?',
                                                    'method' => 'post',
                                                ],
                                            ]) ?>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <hr>
                            <div class="row" style="margin-top: -30px;">

                                <div class="col-lg-6" >
                                    <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>

                                    <div class="kt-widget1 kt-widget1--fit">
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">Nombre</h3>
                                                <span class="kt-widget1__desc" ><?= $model->perfil->nombre ?></span>
                                                <br>

                                            </div>

                                        </div>
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">Teléfono</h3>
                                                <span class="kt-widget1__desc"><?= $model->perfil->telefonos ?></span>
                                                <br>

                                            </div>

                                        </div>
                                        <!--<div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">Activo</h3>
                                                <span class="kt-widget1__desc"><?php
                                                if ($model->activo == 1)
                                                    echo 'Sí';
                                                ?></span>
                                                <br>
                                            </div>
                                        </div>-->
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">Grupo</h3>
                                                <?php foreach( $model->gruposTrabajoUsuario  as $gr ): ?>
                                                    <span class="kt-widget1__desc"><?=$gr->grupo->nombre?></span><br>
                                                <?php endforeach;?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6" >
                                    <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                                    <div class="kt-widget1 kt-widget1--fit">
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">Apellido</h3>
                                                <span class="kt-widget1__desc"><?= $model->perfil->apellidos?></span>
                                            </div>
                                        </div>
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">Correo</h3>
                                                <span class="kt-widget1__desc"><?= $model->nombre_usuario?></span>
                                            </div>
                                        </div>
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">Tipo</h3>
                                                <span class="kt-widget1__desc"><?= UsuarioSuscripcion::$tipos[$usuarioSuscripcion->tipo] ?></span>
                                            </div>
                                        </div>
                                    <!--<div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">Clinica</h3>
                                                <span class="kt-widget1__desc"><?#= $usuarioSuscripcion->clinica->nombre ?></span>
                                            </div>
                                        </div>-->
                                    </div>
                                </div>
                            </div>
                            <hr>
                        <!--<h2>Permisos</h2>
                            <hr>
                            <div class="row">
                                <div class="col-md-12" style="margin-top: -30px;">
                                    <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                                    <div class="kt-widget1 kt-widget1--fit">
                                        <div class="kt-widget1__item">
                                            <?php foreach($controladores as $controlador){ ?>
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title"><?= ucwords($controlador->nombre_amigable)?></h3>
                                                <ul>
                                                    <?php $acciones = PermisoUsuario::find()
                                                            ->select(['permiso_usuario.id', 'permiso_usuario.id_suscripcion', 'permiso_usuario.id_usuario', 'permiso_usuario.id_accion', 'permiso_usuario.permitido'])
                                                            ->innerJoin(['a' => 'accion'],'`a`.`id` = `permiso_usuario`.`id_accion`')
                                                            ->innerJoin(['c' => 'controlador'],'`c`.`id` = `a`.`id_controlador`')
                                                            ->where(['a.tipo' => 1, 'permiso_usuario.permitido'=>1, 'c.id'=>$controlador->id])
                                                            ->andWhere(['permiso_usuario.id_suscripcion'=>$idSuscripcion, 'permiso_usuario.id_usuario'=>$userId])
                                                            ->all();
                                                    foreach ($acciones as $accion){?>
                                                        <li><h3 class="kt-widget1__desc"><?=$accion->accion->nombre_amigable?> - <?=$accion->accion->descripcion?></h3></li>
                                                    <?php }?>
                                                </ul>
                                            <?php }?>
                                            </div>    
                                        </div>
                                    </div>   
                                </div>
                            </div>-->
                    </div>
                </div>
                <!--end:: Widgets/Applications/User/Profile3-->
            </div>
        </div>        
        </div>    
    </div>
</div>
