<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model app\models\Usuario */
/* @var $form yii\widgets\ActiveForm */
/* @var $clinicas app\models\Clinica[] */

$perfil = $model->perfil;

$this->title = 'Asociar asistente';
$this->params['breadcrumbs'][] = ['label' => 'Asistentes', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="usuario-create kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title">¿Está seguro de asociar al asistente?</h1>
            <small>Este tendrá acceso al manejo de su agenda.</small>
        </div>
    </div>
    <?php $form = ActiveForm::begin(['options' => ['class' => 'kt-form']]); ?>
        <?= Html::hiddenInput("id_usuario",$model->id)?>
        <div class="usuario-form kt-portlet__body">
            <div class="row">
                <div class="col-12">
                    <div class="form-group">
                        <label class="form-label">Clínica</label>
                        <?= Html::dropDownList('id_clinica',null,$clinicas,['class'=>"form-control"]) ?>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-6"><?= $form->field($model, 'nombre_usuario')->label("Correo de usuario")->textInput(['readonly' => true]) ?></div>
                <div class="col-6"><?= $form->field($perfil, 'nombreCompleto')->textInput(['readonly' => true]) ?></div>
            </div>
        </div>
        <div class="kt-portlet__foot">
            <div class="form-group kt-form__actions">
                <?= Html::submitButton('Asociar', ['class' => 'btn btn-success']) ?>
                <?= Html::a('Cancelar',['index'], ['class' => 'btn btn-danger']) ?>
            </div>
        </div>
    <?php ActiveForm::end(); ?>

</div>
