<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Clinicas';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="clinica-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
        <p class="mt-2">
            <?= Html::a('Crear Clinica', ['create'], ['class' => 'btn btn-success']) ?>
        </p>
    </div>
    <div class="kt-portlet__body">
          <div class="table-responsive">
                  <?= GridView::widget([
            'dataProvider' => $dataProvider,
            'summary' => 'Mostrando {begin} - {end} de {totalCount} ítems',
            'tableOptions' => ['class' => 'table table-hover','style'=>'font-size: 11pt'],
            'rowOptions' => function ($model) {
                return ['data-id' => $model->id];
            },
            'columns' => [
                ['class' => 'yii\grid\SerialColumn'],

                'nombre',
                'telefono',
                'celular',
                'direccion',
                [
                    'class' => 'app\customs\ActionColumn',
                    'template' => '{view} {update} {delete}',
                    'buttons' => [
                        'delete' => function($url,$model,$key){
                            $totalCitas = $model->getCitas()->count();
                            return ($totalCitas > 0)
                                ? ""
                                : Html::a("<span class='kt-font-danger flaticon2-trash'></span>",
                                        ['clinica/delete','id' => $model->id],
                                        [
                                            'data' => [
                                                'method' => 'post',
                                                'confirm' => 'Esta seguro de eliminar este elemento?',
                                                'params' => ['id' => $model->id], // <- extra level
                                            ],
                                        ]);
                        }
                    ]
                ],
            ],
        ]); ?>
        </div>
    
    </div>
</div>
<?php
    $this->registerJs("
        $('tbody td:not(.disable-click)').css('cursor', 'pointer');
        $(document).on('click','table tr td:not(.disable-click)',function(e) {      
            var id = $(this).closest('tr').data('id');
            if (e.target == this && id)
                location.href = '" . Url::to(['/clinica/view']) . "?id=' + id;
        });
    ");
?>
