<?php

use yii\helpers\Html;
use yii\web\YiiAsset;
use app\assets\ViewCitaAsset;
use app\models\Usuario;
use yii\helpers\Url;
use app\models\Cita;
use app\models\repositories\SecurityFunctions;
use app\models\Pagadito;

/* @var $this yii\web\View */
/* @var $model app\models\Cita */
/* @var $usuario app\models\Usuario */
/* @var $pagadito app\models\Pagadito */
/* @var $cobroCita app\models\CobroPagadito */

$securityFunctions = new SecurityFunctions;
$usuario = Yii::$app->user->identity;
$simboloMoneda = $usuario->suscripcion->pais->simbolo;

$paciente = $model->paciente;

$cobroCita = $model->cobroPagadito;

$boolCobroPasarela = $pagadito != null ? \boolval( $pagadito->cobrar_pasarela ) : false;

$boolMarcarAsistencia = ($usuario->tipo == Usuario::DOCTOR || ($usuario->tipo == Usuario::ASISTENTE && 
        $securityFunctions->accionPermitida("confirmar-cita", "cita"))) && 
        ($model->estado < 3 && (time() >= strtotime($model->fechaDB)));

$boolConfPagadito = $usuario->tipo == Usuario::DOCTOR && $medioPagoCita === Pagadito::MEDIO_PAGO_PAGADITO && $cobroCita == NULL && $pagadito == NULL;

$boolDetalleCobro = ($medioPagoCita === Pagadito::MEDIO_PAGO_PAGADITO || $medioPagoCita === Pagadito::MEDIO_PAGO_LINK) && 
        $cobroCita != NULL && $pagadito != NULL;

$boolCobrarCita = ($model->estado != Cita::CANCELADA || $model->estado != Cita::INASISTENCIA) && 
        ($medioPagoCita == Pagadito::MEDIO_PAGO_PAGADITO || ($medioPagoCita == Pagadito::MEDIO_PAGO_LINK && !empty($pagadito->link_externo))) && 
        $cobroCita == NULL && $pagadito != NULL;

        
$this->title = $model->paciente->nombreCompleto;
$this->params['breadcrumbs'][] = ['label' => 'Citas', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
YiiAsset::register($this);
ViewCitaAsset::register($this);
?>
<script>
    var existCitaProx = '<?=$existCitaProx ? 'true' : 'false'?>';
    var isCreateCita = '<?=$createCita ? 'true' : 'false'?>';
    var reprogramar = '<?=boolval($reprogramar) ? 'true' : 'false'?>';
    var fecha_anterior = '<?=$fecha_anterior?>';
    var init_fns_cobro = '<?= $cobroCita == NULL ? 1 : 0 ?>'-0;
    const id_cita = '<?=$model->id?>';
    const id_paciente = '<?=$model->id_paciente?>';
    const TIPO_COBRO = '<?= $pagadito != null ? $pagadito->tipo : 0 ?>'-0;
    const boolCobroPasarela = '<?=$boolCobroPasarela ? 1 : 0 ?>'-0 === 0 ? false : true;
    const porcentajePasarela = '<?=$pagadito != null ? $pagadito->monto_porcentual : 0?>'-0 / 100;
    const montoPasarela = '<?=$pagadito != null ? $pagadito->monto_fijo : 0?>'-0 / 100;
    const URL_SERVER = '<?=Yii::$app->params['urlAplicacion']?>'; 
    const cita_periodica_token = '<?=!empty($model->cita_periodica_token) ? $model->cita_periodica_token : ''?>'; 
    const cita_periodica_fecha = '<?=$model->fechaDB?>'; 
</script>
<style>
.check{
  -ms-transform: scale(1.2);
  -moz-transform: scale(1.2); 
  -webkit-transform: scale(1.2); 
  -o-transform: scale(1.2);
  padding: 10px;
  margin: 5px 5px;
}
</style>
<div class="cita-view" style="text-shadow: none;">
    <div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
        <div class="row" style="text-shadow: none;">
            <div class="col-xl-12" style="text-shadow: none;">
                <!--begin:: Widgets/Applications/User/Profile3-->
                <div class="kt-portlet kt-portlet--height-fluid" style="text-shadow: none;">
                    <div class="kt-portlet__body" style="text-shadow: none;">
                        <div class="kt-widget kt-widget--user-profile-3" style="text-shadow: none;">
                            <div class="kt-widget__top" style="text-shadow: none;">
                                <div class="kt-widget__content">
                                    <div class="kt-widget__head">
                                        <p>
                                            <a href="<?= Url::to(['paciente/view', 'id' => $model->id_paciente]) ?>" class="kt-portlet__head-title" style="margin-left: -20px;font-size: 1.8rem; 
                                               font-weight:500; color: #464457; ">
                                               <?= $model->paciente->nombre . " " . $model->paciente->apellido ?>
                                            </a>
                                        </p>
                                        <div class="kt-widget__action " style="margin-left:-25px;">
                                            <p class="d-none d-md-block">
                                                <?php if( $model->estado < Cita::CANCELADA ):?>
                                                    <a class='btn btn-success mt-1' href='#' data-toggle='modal' data-target='#cambiar-estado-cita-modal'>Cambiar Estado</a>
                                                <?php endif;?>
                                                <button class="btn btn-success" style="display:none;" id="btn-modal-seg" data-toggle="modal" data-target="#seguimientos-paciente">Seguimientos</button>
                                                <?= Html::a('Actualizar', ['update', 'id' => $model->id], ['class' => 'btn btn-primary mt-1']) ?>
                                                <?= Html::a('Imprimir', ['reportes/imprimir-cita', 'id_cita' => $model->id], ['class' => 'btn btn-info mt-1', 'target'=>'_blank']) ?>
                                                <?php if( $boolCobrarCita ):?>
                                                    <button  data-toggle="modal" data-target="#cobrar-cita-modal" class="btn btn-success mt-1" data-id="<?=$model->id?>">Cobrar</button>
                                                <?php endif;?>
                                                <?php if( $boolConfPagadito ):?>
                                                    <?= Html::a('Configurar Pagadito', ['settings/index'], ['class'=>'btn btn-primary'])?>
                                                <?php endif;?>
                                                <?php if($usuario->tipo == Usuario::ASISTENTE  && $medioPagoCita === Pagadito::MEDIO_PAGO_PAGADITO && $cobroCita == NULL && $pagadito == NULL):?>
                                                    <span style="font-size: 12px;" class="kt-badge kt-badge--brand kt-badge--inline kt-badge--pill kt-badge--rounded">Configure cuenta de Pagadito</span>
                                                <?php endif;?>        
                                                <?php if( $boolDetalleCobro ):?>
                                                    <button data-toggle="modal" data-target="#detalle-cobro-modal" class="btn btn-success mt-1">Detalle Cobro</button>
                                                <?php endif;?>  
                                            </p>
                                        </div>
                                    </div>
                                    <div class="d-md-none">
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-secondary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="margin-left: 0 !important;">
                                                Opciones
                                            </button>
                                            <div class="dropdown-menu">
                                                <?= Html::a('<i class="la la-plus kt-font-success mt-2"></i>Agregar Cita', ['cita/create', 'pid' => $model->id_paciente], ['class' => 'dropdown-item']) ?>
                                                <div class="dropdown-divider"></div>
                                                <?= Html::a('<i class="la la-edit kt-font-primary mt-2"></i>Actualizar', ['update', 'id' => $model->id], ['class' => 'dropdown-item']) ?>
                                                <?php if( $model->estado < Cita::COMPLETADA ):?>
                                                <div class="dropdown-divider"></div>
                                                <a class='dropdown-item' href='#' data-toggle='modal' data-target='#cambiar-estado-cita-modal'>Cambiar Estado</a>
                                                <?php endif;?>
                                                <div class="dropdown-divider"></div>
                                                <?= Html::a('<i class="la la-print kt-font-primary mt-2"></i>Imprimir', ['reportes/imprimir-cita', 'id_cita' => $model->id], ['class' => 'dropdown-item', 'target'=>'_blank']) ?>
                                                <div class="dropdown-divider"></div>
                                                <?= $model->esCitaPeriodica 
                                                    ? '<a id="cancelar-cita-periodica" class="dropdown-item" href="javascript:void(0);"><i class="la la-trash kt-font-danger mt-2"></i>Cancelar cita</a>' 
                                                    : Html::a('<i class="la la-trash kt-font-danger mt-2"></i>Cancelar cita', ['delete', 'id' => $model->id], [
                                                        'class' => 'dropdown-item',
                                                        'data' => [
                                                            'confirm' => '¿Está seguro de cancelar esta cita?',
                                                            'method' => 'post',
                                                        ]]) ?>
                                                <?php if( $boolCobrarCita ):?>
                                                    <div class="dropdown-divider"></div>
                                                    <a href="#" data-toggle="modal" data-target="#cobrar-cita-modal" class="dropdown-item" data-id="<?=$model->id?>"><i class="la la-money kt-font-success mt-2"></i>Cobrar</a>
                                                <?php endif;?>
                                                <?php if(($model->estado < Cita::CANCELADA ) && ($medioPagoCita === Pagadito::MEDIO_PAGO_PAGADITO ||$medioPagoCita === Pagadito::MEDIO_PAGO_LINK) && $cobroCita == NULL && $pagadito != NULL):?>
                                                    <div class="dropdown-divider"></div>
                                                    <?= Html::a('Configurar Pagadito', ['settings/index'], ['class'=>'dropdown-item'])?>
                                                <?php endif;?>
                                                <?php if($usuario->tipo == Usuario::ASISTENTE && $model->estado == Cita::COMPLETADA && $medioPagoCita === Pagadito::MEDIO_PAGO_PAGADITO && $cobroCita == NULL && $pagadito == NULL):?>
                                                    <div class="dropdown-divider"></div>
                                                    <span style="font-size: 12px;" class="kt-badge kt-badge--brand kt-badge--inline kt-badge--pill kt-badge--rounded">Configure cuenta de Pagadito</span>
                                                <?php endif;?>        
                                                <?php if( $boolDetalleCobro ):?>
                                                    <div class="dropdown-divider"></div>
                                                    <a href="#" data-toggle="modal" data-target="#detalle-cobro-modal" class="dropdown-item"><i class="la la-tags kt-font-success mt-2"></i>Detalle Cobro</a>
                                                <?php endif;?> 
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="kt-widget__top" style="text-shadow: none;">
                                <div class="kt-widget__content">
                                    <div class="kt-widget__head">
                                        <p style="margin-top: 5px;margin-left: -20px;margin-bottom: 20px; font-size: 1.5rem; font-weight:300; color: #464457;">Cita del: 
                                            <?= \date('d/m/Y', strtotime($model->fechaDB)) ?>&nbsp;a las&nbsp;<?= \date('H:i', strtotime($model->fechaDB)) ?>
                                        </p>   
                                    </div>
                                </div>
                                <div class="kt-widget__action " style="margin-left:-250px;">
                                    <p class="d-none d-md-block">
                                        <?php if ( $boolMarcarAsistencia ) { ?>
                                        ¿Asistió el paciente a su cita? <input class="check"  type="checkbox" id="nf-<?= $model->id ?>" onclick="confirmar(<?= $model->id ?>)"/>
                                        <?php }?>
                                    </p>
                                </div>
                            </div>
                            <p class="d-md-none">
                                <?php if ( $boolMarcarAsistencia ) { ?>
                                ¿Asistió el paciente a su cita? <input class="check"  type="checkbox" id="nf-<?= $model->id ?>" onclick="confirmar(<?= $model->id ?>)"/>
                                <?php }?>
                            </p>
                            <div class="row" style="margin-top: -30px;">
                                <div class="col-lg-6" >
                                    <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                                    <div class="kt-widget1 kt-widget1--fit">
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">Asunto</h3>
                                                <span class="kt-widget1__desc">
                                                    <?= ($model->asunto == '') ? "(No definido)" : $model->asunto; ?>
                                                </span>
                                                <br>
                                            </div>
                                        </div>
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title" style="padding-bottom: 20px;">Procedimientos</h3>
                                                <?php
                                                foreach ($procedimiento_cita_array as $model_cli_pro) {
                                                    echo " <li style='margin-top:-15px;' class='kt-widget1__desc'>" . $model_cli_pro->procedimiento->nombre . "</li><br>";
                                                }
                                                ?>
                                            </div>
                                        </div>
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">Diagnóstico</h3>
                                                <span class="kt-widget1__desc"><?= ($model->diagnostico == NULL) ? "(No definido)" : $model->diagnostico; ?></span>
                                                <br>
                                            </div>
                                        </div>
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">Tipo de Cita</h3>
                                                <span class="kt-widget1__desc"><?= $model->tipo_cita == Cita::CITA_PRESENCIAL ? "Cita Presencial" : 'Cita en Línea'; ?></span>
                                                <br>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6" >
                                    <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                                    <div class="kt-widget1 kt-widget1--fit">
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title"><?= $model->totalRecordatorios == 0 ? "Ningún" : $model->totalRecordatorios . "°" ?> recordatorio enviado:</h3>
                                                <span class="kt-widget1__desc"><?= $model->textoEstado ?></span>
                                            </div>
                                        </div>
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">Tiempo de duración</h3>
                                                <span class="kt-widget1__desc"><?= $model->tiempo_estimado ?></span>
                                            </div>
                                        </div>
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">Costo</h3>
                                                <?php
                                                $sum_costos = 0;
                                                foreach ($procedimiento_cita_array as $model_cli_pro) {
                                                    $sum_costos += $model_cli_pro->costo_editado;
                                                }
                                                echo " <span class='kt-widget1__desc'>" .$simboloMoneda.$sum_costos . "</span><br>";
                                                ?>
                                            </div>
                                        </div>
                                        <?php if($model->bitacoraCita->esCitaPeriodica): ?>
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">Cita périodica actual</h3>
                                                <span class="kt-widget1__desc" style="<?=$model->bitacoraCita->esUltimaCitaPeriodica?'color:red;':''?>">
                                                    <?=$model->bitacoraCita->textoCitaPeriodica?>
                                                </span>
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--end:: Widgets/Applications/User/Profile3-->
                </div>
            </div>
        </div>
    </div>
</div>    
<div id="confirmarCitaModal" class="modal fade">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Confirmar</h4>
                <button class="close"></button>
            </div>
            <div class="modal-body">
                <p>¿El paciente asistió a su cita?</p>
            </div>
            <div class="modal-footer">
                <button id="btn-confirmarCitaModalNo" class="btn btn-sm btn-default">No</button>
                <button id="btn-confirmarCitaModalYes" class="btn btn-sm btn-primary">Si</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div class="modal fade" role="dialog" aria-hidden="true" id="cambiar-estado-cita-modal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Cambiar el estado de la cita de <?= $model->paciente->nombreCorto ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
            </div>
            <div class="modal-body">
                <?= Html::beginForm(Url::toRoute([""]), "POST") ?>
                <input type="hidden" name="id" id="id_cita" value="<?= $model->id ?>">   
                <label>Selecciona uno de los siguientes Estados</label>
                <select name="estado"  id="estado" class="form-control" required>
                    <option value="">-Seleccionar estado-</option>                                                                
                    <option value="<?= Cita::CONFIRMADA?>">Confirmada</option>
                    <option value="<?= Cita::CANCELADA?>">Cancelada</option>
                </select>
            </div>
            <div class="modal-footer">

                <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                <?= Html::button('Continuar', ['id'=>'btn-estado', 'class' => 'btn btn-success']) ?>
                <?= Html::endForm() ?>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div class="modal fade" role="dialog" aria-hidden="true" id="view-imagen">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title title mt-2" id="title"></h5><span class="kt-badge kt-badge--brand kt-badge--lg title ml-2" id="edit-title"><i class="far fa-edit" style="font-size: 20px;"></i></span>
                    <textarea cols="2" rows="1" class="col-sm-3 col-md-6 form-control edit-title" type="text" id="descripcion" name="descripcion"></textarea>
                    <span class="kt-badge kt-badge--danger kt-badge--lg edit-title ml-2 mr-2" id="close-edit"><i class="far fa-times-circle" style="font-size: 20px;"></i></span>
                    <span class="kt-badge kt-badge--success kt-badge--lg edit-title mr-2" id="guardar"><i class="far fa-save" style="font-size: 20px;"></i></span>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div id="view-modal-body" class="modal-body">
                <div class="post-slide">
                    <div class="circle-prev">
                        <i class="flaticon2-fast-back navigation-btn prev" id="prev"></i>
                    </div>
                    <div class="circle-next">
                        <i class="flaticon2-fast-next navigation-btn next" id="next"></i>
                    </div>
                    <div class="circle-delete">
                        <i class="fa fa-trash-alt delete" id="eliminar-adjunto"></i>
                    </div>
                    <div class="circle-download" id="descargar-adjunto">
                        <a href="" id="url-adjunto"><i class="fa fa-download download"></i></a>
                    </div>
                    <img id="img-view" src="" width="100%" alt="...">
                </div>    
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div><!-- /.modal -->
<div id="seguimientosModal" class="modal-seg">
    <div class="modal-contenido">
        <div class="modal-head">
          <h4 class="title-mod" id="segTitulo"></h4> 
          <span id="closeModalSeg" class="close">&times;</span>
        </div>
      <div id="segCuerpo"></div>
    </div>
</div>  

<div id="seguimientos-paciente" class="modal fade">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="pseg-title"></h4>
                <button data-dismiss="modal" class="close"></button>
            </div>
            <div class="modal-body" id="cuerpo">
                <div id="desc" class="description"></div>
                <div class="kt-list-timeline">
                    <div class="kt-list-timeline__items" id="kt-list-items">
                    </div>
                </div>
            </div>
            <div class="modal-footer" id="foot">
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div id="enviar-reprogramacion" class="modal fade">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="pseg-title">Notificar al paciente</h4>
                <button data-dismiss="modal" class="close" data-toggle="kt-tooltip" title="" data-placement="right" data-original-title="Al cerrar esta ventana se enviara la notificación"></button>
            </div>
            <div class="modal-body" id="">
                ¿Quisiera enviar una notificación al paciente <strong><?=$model->paciente->nombreCorto?></strong> que se ha reprogramado su cita?
            </div>
            <div class="modal-footer" id="foot">
                <button id="no-enviar" class="btn btn-secondary">NO</button>
                <button id="si-enviar" class="btn btn-success">SI</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<?= $this->render('../modals/cobro-cita', [
    'model' => $model,
    'pagadito' => $pagadito,
    'cobroCita' => $cobroCita,
    'paciente' => $paciente,
    'medioPagoCita' => $medioPagoCita,
    'boolCobroPasarela' => $boolCobroPasarela,
    'procedimiento_cita_array' => $procedimiento_cita_array
])?>
<?= $this->render('../modals/cita/cancelar-cita-periodica') ?>