<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\assets\CitaAsset;
//use kartik\datetime\DateTimePicker;
/* @var $this yii\web\View */
/* @var $model app\models\Cita */
/* @var $form yii\widgets\ActiveForm */
CitaAsset::register($this);
$nombrePaciente = $model->paciente->nombreCompleto;
$procedimientosModel = $model->procedimientoCitas;
$model->fecha = date("d/m/Y H:i",strtotime($model->fecha));
$this->title = 'Reprogramar cita';
$this->params['breadcrumbs'][] = ['label' => 'Citas', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<script type="text/javascript">
    var vistaCita = '<?= ($model->isNewRecord ? "create" : "update") ?>'
</script>
<div class="cita-create kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
    </div>
<?php 
    $form = ActiveForm::begin(['options' => ['class' => 'kt-form']]); 
    if(!$model->isNewRecord){
?>
        <input type="hidden" id="id_cita" value="<?= $model->id?>"/>
    <?php } ?>
    <div class="cita-form kt-portlet__body">
        <div class="row">
            <div class="col-lg-10">
                <div class="form-group">
                    <label class="control-label" for="pacienteAutocomplete">Procedimientos a aplicar</label>
                    <p>
                        <?php
                        foreach($procedimientosModel as $procC){
                            $procedimiento = $procC->procedimiento;
                            echo "<span>$procedimiento->nombre ($procedimiento->tiempo),</span> ";
                        }
                        ?>
                    </p>
                </div>
            </div>
            <div class="col-lg-2">
                <div class="form-group">
                    <label class="control-label">Tiempo estimado</label>
                    <p><?=$model->tiempo_estimado?> minutos</p>
                    <input type="hidden" id="cita-tiempo_estimado" value="<?= $model->tiempo_estimado?>">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-4">
                <?= $form->field($model, 'fecha')->textInput() ?>
            </div>
            <div class="col-lg-8">
                <div class="form-group">
                    <label class="control-label" >Paciente</label>
                    <p><?= $model->paciente->nombreCompleto?></p>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="form-group">
                    <label class="control-label" >Asunto</label>
                    <p><?= $model->asunto?></p>
                </div>
            </div>
        </div>
    </div>
    <div class="kt-portlet__foot">
        <div class="form-group kt-form__actions">
            <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
        </div>
    </div>
<?php ActiveForm::end(); ?>
</div>