<?php 
use app\models\Cita;
use yii\helpers\Html;
use app\models\Usuario;
use app\models\Pagadito;

?>
<div class="btn-group">
    <button type="button" class="btn btn-secondary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="margin-left: 0 !important;">
        Opciones
    </button>
    <div class="dropdown-menu">
        <?= Html::a('<i class="la la-plus kt-font-success mt-2"></i>Agregar Cita', ['cita/create', 'pid' => $model->id_paciente], ['class' => 'dropdown-item']) ?>
        <div class="dropdown-divider"></div>
        <?= Html::a('<i class="la la-edit kt-font-primary mt-2"></i>Actualizar', ['update', 'id' => $model->id], ['class' => 'dropdown-item']) ?>
        <?php if ($model->estado < Cita::COMPLETADA) : ?>
            <div class="dropdown-divider"></div>
            <a class='dropdown-item' href='#' data-toggle='modal' data-target='#cambiar-estado-cita-modal'>Cambiar Estado</a>
        <?php endif; ?>
        <div class="dropdown-divider"></div>
        <?= Html::a('<i class="la la-print kt-font-primary mt-2"></i>Imprimir', ['reportes/imprimir-cita', 'id_cita' => $model->id], ['class' => 'dropdown-item', 'target' => '_blank']) ?>
        <div class="dropdown-divider"></div>
        <?= $model->esCitaPeriodica
            ? '<a id="cancelar-cita-periodica" class="dropdown-item" href="javascript:void(0);"><i class="la la-trash kt-font-danger mt-2"></i>Cancelar cita</a>'
            : Html::a('<i class="la la-trash kt-font-danger mt-2"></i>Cancelar cita', ['delete', 'id' => $model->id], [
                'class' => 'dropdown-item',
                'data' => [
                    'confirm' => '¿Está seguro de cancelar esta cita?',
                    'method' => 'post',
                ]
            ]) ?>
        <?php if ($boolCobrarCita) : ?>
            <div class="dropdown-divider"></div>
            <a href="#" data-toggle="modal" data-target="#cobrar-cita-modal" class="dropdown-item" data-id="<?= $model->id ?>"><i class="la la-money kt-font-success mt-2"></i>Cobrar</a>
        <?php endif; ?>
        <?php if (($model->estado < Cita::CANCELADA) && ($medioPagoCita === Pagadito::MEDIO_PAGO_PAGADITO || $medioPagoCita === Pagadito::MEDIO_PAGO_LINK) && $cobroCita == NULL && $pagadito != NULL) : ?>
            <div class="dropdown-divider"></div>
            <?= Html::a('Configurar Pagadito', ['settings/index'], ['class' => 'dropdown-item']) ?>
        <?php endif; ?>
        <?php if ($usuario->tipo == Usuario::ASISTENTE && $model->estado == Cita::COMPLETADA && $medioPagoCita === Pagadito::MEDIO_PAGO_PAGADITO && $cobroCita == NULL && $pagadito == NULL) : ?>
            <div class="dropdown-divider"></div>
            <span style="font-size: 12px;" class="kt-badge kt-badge--brand kt-badge--inline kt-badge--pill kt-badge--rounded">Configure cuenta de Pagadito</span>
        <?php endif; ?>
        <?php if ($boolDetalleCobro) : ?>
            <div class="dropdown-divider"></div>
            <a href="#" data-toggle="modal" data-target="#detalle-cobro-modal" class="dropdown-item"><i class="la la-tags kt-font-success mt-2"></i>Detalle Cobro</a>
        <?php endif; ?>
    </div>
</div>