<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\assets\PermisosAsset;
use app\assets\CrearAsistenteAsset;
/* @var $this yii\web\View */ 
/* @var $model app\models\Usuario */
/* @var $perfil app\models\Perfil */
/* @var $form yii\widgets\ActiveForm */
PermisosAsset::register($this);
CrearAsistenteAsset::register($this);
?>

<?php $form = ActiveForm::begin(['options' => ['class' => 'kt-form']]); ?>
    <div class="usuario-form kt-portlet__body">
        <div class="row">
            <div class="col-12">
                <div class="form-group">
                    <label class="form-label" for="id_clinica">Clínica</label>
                    <?= Html::dropDownList('id_clinica',$idClinica,$clinicas,['class' => 'form-control', 'id'=>'id_clinica']) ?>
                </div>
                
            </div>
        </div>
        <div class="row">
            <div class="col-6"><?= $form->field($perfil, 'nombre')->textInput(['maxlength' => true]) ?></div>
            <div class="col-6"><?= $form->field($perfil, 'apellidos')->textInput(['maxlength' => true]) ?></div>
            
        </div>
        <div class="row">
             <?php if($model->isNewRecord){ ?>
            <div class="col-6"><?= $form->field($model, 'nombre_usuario',['enableAjaxValidation' => true])->label("Correo de usuario")->textInput(['maxlength' => true]) ?></div>
            <?php }else{ ?>
            <div class="col-6"><?= $form->field($model, 'nombre_usuario')->label("Correo de usuario")->textInput(['maxlength' => true, 'readonly' => 'readonly']) ?></div>
            <?php } ?>
            <div class="col-6"><?= $form->field($perfil, 'telefonos')->textInput(['maxlength' => true])->widget(\yii\widgets\MaskedInput::className(), [
    'mask' => '9999-9999',]) ?></div>
        </div>
        <h2>Permisos para asistente</h2>
        <div class="table-responsive">
        <table  class="table table-hover">
            <tr>
                <th></th>
                <th>Nombre</th>
                <th>Grupo</th>
                <th>Descripción</th>
            </tr>
                <?php
                foreach($controladores as $controlador){
                   $total=$controlador->getPermisionCountUsuario($controlador->id, $idUsuario, $idSuscripcion);
                   echo '<tr class="controller '.$controlador->nombre.'">';
                   echo '<td><div class="custom-control custom-switch">'
                       . '<input class="custom-control-input main-checkbox" type="checkbox" id="'.$controlador->nombre.'"  value="'
                       . $controlador->nombre.'" '.($total > 0 ?"checked" : '').'/>'
                       . '<label class="custom-control-label" for="'.$controlador->nombre.'"></label>'    
                       . '&nbsp;<span class="totales" id="total|'.$controlador->nombre.'"><span>'
                       . '</div></td>';
                   echo '<td class="ck abierto" colspan="2">';
                   echo ucwords($controlador->nombre_amigable).'</td><td class="ck abierto" >'.$controlador->descripcion.'</td></tr>';
                   $acciones=$controlador->getAcciones()->andFilterWhere(['tipo' => \app\models\Accion::TIPO_SUSCRIPCION])->all();

                   foreach($acciones as $accion){
                       echo '<tr class="action '.$controlador->nombre.'"><td></td>';
                       echo '<td><input class="sec-checkbox" name="permisos[]" type="checkbox" ';
                       echo (in_array($accion->id,$concedidos)?'checked="checked" ':'').' value="'.$accion->id.'" /></td>';
                       echo '<td>'.$accion->nombre_amigable.'</td><td>'.$accion->descripcion.'</td></tr>';
                   }
                }

            ?>
        </table>
        </div>    
    </div>
    <div class="kt-portlet__foot">
        <div class="form-group kt-form__actions">
            <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
        </div>
    </div>
<?php ActiveForm::end(); ?>

<div id="asociar-modal" class="modal fade">
    <div class="modal-dialog modal-dialog-centered modal-md">
        <div class="modal-content" id="_ViewSegCont">
            <div class="modal-header">
                <h4 class="modal-title">Usuario Existente</h4>
                <button class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>¿Ya existe un usuario con el correo ingresado desea asociarlo a su suscripción?</p>
            </div>
            <div class="modal-footer" >
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" id="asociar">Asociar</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->