<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require __DIR__ . '/vendor/yiisoft/yii2/Yii.php'; 

require __DIR__ . '/vendor/autoload.php'; 

$yiiAppConfig = require __DIR__ . '/config/web.php'; 
(new yii\web\Application($yiiAppConfig))->init(); 

use app\models\Suscripcion;
use Stripe\Stripe;
use Stripe\Subscription;
use Stripe\SubscriptionItem;
use yii\console\ExitCode;

function testRegistrarUso() {
 $secretStripeKey = \Yii::$app->params['strSKey'];
    Stripe::setApiKey($secretStripeKey);

    $suscripciones = Suscripcion::find()->where(['activa' => 1])->all();
    echo "Total de suscripciones activas: " . count($suscripciones) . "\n";

    if (!$suscripciones) {
        echo "No hay suscripciones activas para probar.\n";
        return;
    }

    $time = time();
    echo "Tiempo actual: " . date('Y-m-d H:i:s', $time) . "\n";

    $today = strtotime(date("Y-m-d 00:00", $time));
    $start_date = '2025-02-20 00:00';//date("Y-m-d H:i", strtotime('-59 minute', $today));
    $end_date = '2025-02-20 23:55';//date("Y-m-d", $today) . ' 23:00';

    echo "Rango de fechas - Inicio: $start_date, Fin: $end_date\n";
    ?><br><?php
    ?><br><?php

    foreach ($suscripciones as $suscripcion) {
        echo "Procesando suscripción para el usuario: " . $suscripcion->usuario->nombre_usuario . "\n" . "ID USUARIO: " . $suscripcion->id ."\n";
        ?><br><?php
        echo "Tipo de plan: " . $suscripcion->plan->getTextoTipo() . "\n";

        ?><br><?php

        if ($suscripcion->plan->tipo == \app\models\Plan::TIPO_X_CITAS) {

            $total = $suscripcion->getTotalCitasNotificadas($start_date, $end_date); 
            echo "Total de citas notificadas: $total\n";

        } else if($suscripcion->plan->tipo == \app\models\Plan::TIPO_X_SMS) {

            $total = $suscripcion->getTotalMensajesEnviados($start_date, $end_date); 

        echo "Total de mensajes enviados: $total\n";
        
        }

        ?><br><?php

        if ($total > 0) {
            $formaPago = $suscripcion->usuario->formaPago;
            if ($formaPago != null) {
                echo "Forma de pago encontrada para el usuario con total $total\n";
                ?><br><?php
                $subscription_item_id = Subscription::retrieve($formaPago->subcription_id)->items->data[0]->id;
                echo "ID de elemento de suscripción: $subscription_item_id\n";
                ?><br><?php
               // $res = SubscriptionItem::createUsageRecord(
               //     $subscription_item_id,
               //     [
               //         'quantity' => $total,
               //         'timestamp' => $time,
               //         'action' => "increment",
               //     ]
               // );
               // echo "Registro de uso creado: " . json_encode($res) . "\n";
            } else {
                echo "No se encontró forma de pago para el usuario: " . $suscripcion->usuario->nombre_usuario . "\n";
            }
        } else {
            echo "No se registraron citas ni mensajes para el usuario: " . $suscripcion->usuario->nombre_usuario . "\n";
        }
        ?><br><?php
        ?><br><?php
        ?><br><?php
    }

    echo "Proceso finalizado.\n";
    return ExitCode::OK;
}

testRegistrarUso();


?>