<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require __DIR__ . '/vendor/yiisoft/yii2/Yii.php'; 
require __DIR__ . '/vendor/autoload.php'; 
$yiiAppConfig = require __DIR__ . '/config/web.php'; 
(new yii\web\Application($yiiAppConfig))->init(); 

use app\models\Suscripcion;
use yii\console\ExitCode;

function getTotalCitasNotificadas($id_suscripcion, $fecha_inicio, $fecha_fin) {
    echo "ID Suscripción: " . $id_suscripcion . "\n";
    echo "Fecha Inicio: " . $fecha_inicio . "\n";
    echo "Fecha Fin: " . $fecha_fin . "\n";

    $sqlStr = 'CALL spTotalNotiPrueba(:id_suscripcion, :fecha_inicio, :fecha_fin)';
    
    $command = \Yii::$app->db->createCommand($sqlStr);
    $command->bindValue(':id_suscripcion', $id_suscripcion);
    $command->bindValue(':fecha_inicio', $fecha_inicio);
    $command->bindValue(':fecha_fin', $fecha_fin);
    
    $result = $command->queryScalar();
    
    echo "Resultado de la consulta: " . $result . "\n";

    return intval($result);
}

function testRegistrarUso() {
    $suscripcion = Suscripcion::find()->where(['id' => 12, 'activa' => 1])->one();


    $time = time();
    $start_date = '2025-02-04 00:00'; 
    $end_date = '2025-02-04 23:55';  

    echo "Rango de fechas - Inicio: $start_date, Fin: $end_date\n";

        echo "Procesando suscripción para el usuario: " . $suscripcion->usuario->nombre_usuario . "\n" . "ID USUARIO: " . $suscripcion->id ."\n";
        echo "Tipo de plan: " . $suscripcion->plan->getTextoTipo() . "\n";

        if ($suscripcion->plan->tipo == \app\models\Plan::TIPO_X_CITAS) {
            // Llamar a la función adaptada
            $totalCitas = getTotalCitasNotificadas($suscripcion->id, $start_date, $end_date);
            echo "Total de citas notificadas: $totalCitas\n";
        } else if($suscripcion->plan->tipo == \app\models\Plan::TIPO_X_SMS) {
            // Lógica para mensajes SMS
            echo "Total de mensajes enviados: [Lógica no implementada en este ejemplo]\n";
        }

        echo "<br>";
    
    echo "Proceso finalizado.\n";
}

testRegistrarUso();
?>
