<?php

namespace app\models\web;
use Yii;

use app\customs\Utils;
use borales\extensions\phoneInput\PhoneInputValidator;

/**
 * This is the model class for table "paciente".
 *
 * @property int $id
 * @property int $id_suscripcion
 * @property string $nombre
 * @property string $apellido
 * @property string $email
 * @property string $celular
 * @property bolean $nuevo
 * @property string $nombreCorto
 * @property string $nombreCompleto
 * @property string $primerApellido
 * @property string $primerNombre
 */
class PacienteWeb extends \yii\db\ActiveRecord
{
    
    const NUEVO = 0;
    const EXISTENTE = 1;
    
    public $hasFormat = false;
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'paciente';
    }
    
    /**
     * @return \yii\db\Connection the database connection used by this AR class.
     */
    public static function getDB() {
        return Yii::$app->get('citaWebDB');
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {

        return [
            [['id_suscripcion', 'nombre', 'apellido', 'celular', 'email', 'nuevo'], 'required','message'=>'El campo \'{attribute}\' no puede quedar vacío.'],
            [['id_suscripcion', 'nuevo'], 'integer'],
            [['celular'], 'string', 'max' => 50],
            [['nombre', 'apellido'], 'string', 'max' => 100],
            [['email'], 'string', 'max' => 150],
            [['email'],'email'],            
            [['celular'], PhoneInputValidator::className()],      
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_suscripcion' => 'Suscripción',
            'nombre' => 'Nombre',
            'apellido' => 'Apellido',
            'email' => 'Email',
            'celular' => 'Télefono Celular',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSuscripcion()
    {
        return $this->hasOne(\app\models\Suscripcion::className(), ['id' => 'id_suscripcion']);
    }

    
    /**
     * @return string
     */
    public function getNombreCompleto()
    {
        return $this->nombre . ' ' . $this->apellido;
    }
    
    
    /**
     * @return string
     */
    public function getNombreCorto()
    {
        return Utils::shortName($this->nombre,$this->apellido);
    }

    /**
     * @return string
     */
    public function getPrimerApellido()
    {
        return Utils::firstPartName($this->apellido);
    }
    
    /**
     * @return string
     */
    public function getPrimerNombre()
    {
        return Utils::firstPartName($this->nombre);
    }
    
     public function getCitas()
    {
        return $this->hasMany(CitaWeb::className(), ['id_paciente' => 'id'])->orderBy(['fecha'=>SORT_DESC]);
    }
    
    public function toOliva(){
        $paciente_oliva = new Paciente();
        $paciente_oliva->nombre = $this->nombre;
        $paciente_oliva->apellido = $this->apellido; 
        $paciente_oliva->email = $this->email; 
        $paciente_oliva->celular = $this->celular;
        $paciente_oliva->save();
        return $paciente_oliva;
    }
           
    
}
