<?php
namespace app\models\repositories;
use app\models\Controlador;
use app\models\Accion;
use app\models\Permiso;
use app\models\Bitacora;
use yii\helpers\Url;
use app\models\PermisoUsuario;
use app\models\Usuario;
use app\customs\SesionUtils;
/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class SecurityFunctions
{
    
    public function AccesoPermitido($action){
        $c = Controlador::findOne(['nombre' => $action->controller->id]);
        if(empty($c)){
            $c=$this->GuardarControlador($action);
        }
        $a = Accion::findOne(['id_controlador' => $c->id, 'nombre' => $action->id]);

        if(empty($a)){
            $a=$this->GuardarAccion($action,$c->id);
        }
        $p = $this->PoseePermisos($a->id,\Yii::$app->user->identity->id_rol);
        if($p){
            $this->GuardarBitacora($a->id);
        }
        return $p;
    }
    
    function GuardarControlador($action){
        $c = new Controlador();
        $c->nombre = $action->controller->id;
        $c->nombre_amigable = $action->controller->id;
        $c->descripcion = "Controlador creado automaticamente";
        $c->save();
        return $c;
    }
    
    function GuardarAccion($action,$idControlador){
        $a = new Accion();
        $a->nombre = $action->id;
        $a->nombre_amigable = $action->id;
        $a->id_controlador = $idControlador;
        $a->descripcion = "Accion " . $a->nombre . " creada automaticamente";
        $a->save();
        return $a;
    }
    
    function GuardarBitacora($idAccion){
        $idUsuario=\Yii::$app->user->identity->id;
        $params=  $_SERVER['QUERY_STRING'];
        $bitacora=new Bitacora();
        $bitacora->id_accion = $idAccion;
        $bitacora->id_usuario = $idUsuario;
        $bitacora->fecha_accion = date('Y-m-d H:i',  time());
        $bitacora->parametros = $params;
        $bitacora->save();
    }
    
    public function ObtenerMenuMetronic(){
        $menu=\Yii::$app->Menu->getMenu();
        $menuString=$this->ObtenerSubMenuMetronic($menu, 0);
        return $menuString;
    }
    
    public function ObtenerSubMenuMetronic($menu, $altura){
        $tipo = \Yii::$app->user->identity->tipo;
        $menuString='';
        foreach($menu as $item){
            $arrayKey = key($item);
            $arrayValue = $item[$arrayKey];
            $newItem='';
            if((array_key_exists('section',$arrayValue) && $arrayValue['section'] == 1) && (array_key_exists('user',$arrayValue)
                && (
                    (!is_array($arrayValue['user']) && $arrayValue['user'] != $tipo)
                        || (is_array($arrayValue['user']) && !in_array($tipo)))
                )){
                
            }
            else{
                if(array_key_exists('section',$arrayValue) && $arrayValue['section'] == 1){
                    $newItem=$this->ObtenerSection($arrayKey);
                }
                else{
                    if(array_key_exists('subItems',$arrayValue)){
                        $menuHijo=$this->ObtenerSubMenuMetronic($arrayValue['subItems'],$altura+1);
                        $icono=(array_key_exists('icon',$arrayValue) ? $arrayValue['icon'] : 'flaticon-plus');
                        $newItem=$this->ObtenerNodoArbol($menuHijo, $altura, $icono, $arrayKey);
                    }
                    else{
                        $icono=(array_key_exists('icon',$arrayValue) ? $arrayValue['icon'] : 'flaticon-add-label-button');
                        $newItem=$this->ObtenerNodoSimple($arrayValue['a'], $arrayValue['c'], $arrayKey, $icono, $altura);
                    }
                }
            }
            $menuString.= $newItem;
        }
        return $menuString;
    }
    
    private function ObtenerNodoArbol($menuHijo,$altura,$icono,$texto){
        $newItem='';
        if(!empty($menuHijo)){
            if($altura == 0){
                $newItem = '<li class="kt-menu__item  kt-menu__item--submenu" aria-haspopup="true" data-ktmenu-submenu-toggle="hover">
                                <a href="javascript:;" class="kt-menu__link kt-menu__toggle">
                                    <i class="kt-menu__link-icon '.$icono.'"></i>
                                    <span class="kt-menu__link-text">'.$texto.'</span>
                                    <i class="kt-menu__ver-arrow la la-angle-right"></i>
                                </a>';
                
                $newItem .= '<div class="kt-menu__submenu ">
                                <span class="kt-menu__arrow"></span>
                                <ul class="kt-menu__subnav">
                                    <li class="kt-menu__item  kt-menu__item--parent" aria-haspopup="true">
                                        <span class="kt-menu__link"><span class="kt-menu__link-text">'.$texto.'</span></span>
                                    </li>';
                $newItem .= $menuHijo;
                $newItem .= '</ul></div></li>';
            }
            else{
                $newItem = '<li class="kt-menu__item  kt-menu__item--submenu" aria-haspopup="true" data-ktmenu-submenu-toggle="hover">
                                <a href="javascript:;" class="kt-menu__link kt-menu__toggle">
                                    <i class="kt-menu__link-bullet kt-menu__link-bullet--line"><span></span></i>
                                    <span class="kt-menu__link-text">'.$texto.'</span>
                                    <i class="kt-menu__ver-arrow la la-angle-right"></i>
                                </a>
                                <div class="kt-menu__submenu ">
                                    <span class="kt-menu__arrow"></span>
                                    <ul class="kt-menu__subnav">';
                $newItem .= $menuHijo;
                $newItem .= '</ul></div></li>';
            }
        }
        return $newItem;
    }
    
    private function ObtenerNodoSimple($accion,$controlador,$texto,$icono,$altura){
        $newItem='';
        $currentUrl = \explode('/',Url::current());
        $active = $currentUrl[\count($currentUrl)-2] == "$controlador" ? 'kt-menu__item--active' : ''; 
        if($this->MenuPermitido($accion, $controlador)){
            $newItem ='<li class="kt-menu__item '.$active.'" aria-haspopup="true">
                        <a href="' . Url::to(['/'.$controlador.'/'.$accion]) . '" class="kt-menu__link ">
                            <i class="kt-menu__link-icon ' . $icono . '"></i>
                            <span class="kt-menu__link-text">' . $texto . '</span>
                        </a>
                    </li>';
        }
        
        return $newItem;
    }
    
    private function ObtenerSection($texto){
        $newItem ='<li class="kt-menu__section ">
                <h4 class="kt-menu__section-text">' . $texto . '</h4>
                <i class="kt-menu__section-icon flaticon-more-v2"></i>
            </li>';
        
        return $newItem;
    }

   
    public function PoseePermisos($idAccion,$idRol){
        
        $p = Permiso::findOne(['id_accion' => $idAccion, 'id_rol' => $idRol, 'permitido' => 1]);
        return ($p != NULL) || $this->UsuarioPoseePermiso($idAccion);
    }
    
    public function UsuarioPoseePermiso($idAccion){
        $usuario=\Yii::$app->user->identity;
        if($usuario->tipo != Usuario::ASISTENTE){
            return false;
        }
        $clinica = \app\customs\SesionUtils::ClinicaSeleccionada();
        $p = PermisoUsuario::findOne(['id_accion' => $idAccion,
            'id_usuario' => $usuario->id,
            'permitido' => 1,
            'id_suscripcion' => $clinica->id_suscripcion
        ]);
        return $p != NULL;
    }
    
    private function TestDebug($p,$idAccion,$idRol){
        if(defined('YII_DEBUG') && defined('YII_ENV') && ($p == null || $p->permitido == 0)){
           $p= $p == null ? new Permiso() : $p;
           $p->id_accion = $idAccion;
           $p->id_rol = $idRol;
           $p->permitido = 1;
           $p->save();
        }
        return $p;
    }
    
    private function MenuPermitido($nombreAccion,$nombreControlador){
        $usuario = \Yii::$app->user->identity;
        $c=  Controlador::findOne(['nombre' => $nombreControlador]);
        if(empty($c)){
            return FALSE;
        }
        $a=Accion::findOne(['nombre' => $nombreAccion, 'id_controlador' => $c->id]);
        if(!empty($a)){
            $p = Permiso::findOne(['id_accion' => $a->id, 'id_rol' => $usuario->id_rol, 'permitido' => 1]);
            if($p == NULL && $usuario->tipo == Usuario::ASISTENTE){
                $p = PermisoUsuario::findOne(['id_accion' => $a->id, 'id_usuario' => $usuario->id, 'id_suscripcion' => SesionUtils::ClinicaSeleccionada()->id, 'permitido' => 1]);
            }
            return $p != NULL && $p->permitido == 1;
        }
        return FALSE;
    }
    
    public function accionPermitida($nombreAccion,$nombreControlador){
        $c=  Controlador::findOne(['nombre' => $nombreControlador]);
        if(empty($c)){
            return FALSE;
        }
        $a=Accion::findOne(['nombre' => $nombreAccion, 'id_controlador' => $c->id]);
        if(!empty($a)){
            $p = Permiso::findOne(['id_accion' => $a->id, 'id_rol' => \Yii::$app->user->identity->id_rol, 'permitido' => 1]);
            $usuario=\Yii::$app->user->identity;
            if($usuario->tipo == Usuario::ASISTENTE){
                $clinica = \app\customs\SesionUtils::ClinicaSeleccionada();
                $p2 = PermisoUsuario::findOne(['id_accion' => $a->id,
                    'id_usuario' => $usuario->id,
                    'permitido' => 1,
                    'id_suscripcion' => $clinica->id_suscripcion
                ]);
                return $p != NULL || $p2 != NULL;
            }
            return $p != NULL;
        }
        return FALSE;
    }
}