<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "bitacora_cita".
 *
 * @property int $id
 * @property int $id_cita
 * @property int $estado
 * @property string $fecha
 * @property int $id_usuario
 * @property string $cita_periodica_token
 * @property bool $esCitaPeriodica
 * @property string $numero_cita_periodica
 * @property bool $esUltimaCitaPeriodica
 * @property string $texto_cita_periodica
 * @property Cita $cita
 * @property Usuario $usuario
 */
class BitacoraCita extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'bitacora_cita';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_cita', 'estado', 'fecha'], 'required'],
            [['id_cita', 'estado', 'id_usuario'], 'integer'],
            [['fecha'], 'safe'],
            [['id_cita'], 'exist', 'skipOnError' => true, 'targetClass' => Cita::className(), 'targetAttribute' => ['id_cita' => 'id']],
            [['id_usuario'], 'exist', 'skipOnError' => true, 'targetClass' => Usuario::className(), 'targetAttribute' => ['id_usuario' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_cita' => 'Id Cita',
            'estado' => 'Estado',
            'fecha' => 'Fecha',
            'id_usuario' => 'Id Usuario',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCita()
    {
        return $this->hasOne(Cita::className(), ['id' => 'id_cita']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUsuario()
    {
        return $this->hasOne(Usuario::className(), ['id' => 'id_usuario']);
    }
    /**
     * @return bool 
     */
    public function getEsCitaPeriodica(){
        return !empty($this->cita_periodica_token) && !empty($this->numero_cita_periodica);
    }    
    /**
     * @return array [ numero_de_cita, total_de_citas ]
     */
    public function getNumeroCitaPeriodica(){
        return explode('-', $this->numero_cita_periodica);
    }
    /**
     * @return bool
     */
    public function getEsUltimacitaPeriodica(){
        if(!$this->esCitaPeriodica) return false;
        list($numero, $totalCitas) = $this->numeroCitaPeriodica;
        return $numero == $totalCitas;
    }
    /**
     * @return string
     */
    public function getTextoCitaPeriodica(){
        if(!$this->esCitaPeriodica) return ''; 
        list($numero, $totalCitas) = $this->numeroCitaPeriodica;
        if($numero == $totalCitas){
            return 'ESTA ES LA ÚLTIMA CITA CREADA PÉRIODICAMENTE. SI EL PACIENTE CONTINUARÁ CON SU TRATAMIENTO DEBE AGENDAR MÁS CITAS.';
        }
        return $numero.' de '.$totalCitas. ' citas périodicas';
    }
}
