<?php

namespace app\models;
use Yii;

/**
 * This is the model class for table "cita".
 *
 * @property int $id
 * @property int $id_suscripcion
 * @property string $usuario
 * @property Suscripcion $suscripcion
 */
class UrlSuscripcion extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName(){
        return 'url_suscripcion';
    }
    
    
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_suscripcion', 'usuario'], 'required','message'=>'El campo \'{attribute}\' no puede quedar vacío.'],
            [['id_suscripcion'], 'integer'],
            [['usuario',], 'string', 'max' => 40],
            [['id_suscripcion'], 'exist', 'skipOnError' => true, 'targetClass' => Suscripcion::className(), 'targetAttribute' => ['id_suscripcion' => 'id']],
        ];
    }
    
    
    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_suscripcion' => 'Suscripción',
            'usuario' => 'Usuario',
        ];
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSuscripcion()
    {
        return $this->hasOne(Suscripcion::className(), ['id' => 'id_suscripcion']);
    }
    
    
}
