<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "url_cita".
 *
 * @property int $id
 * @property int $id_cita
 * @property int $tipo
 * @property string $llave
 * @property string $fecha
 * @property string $token
 *
 * @property Cita $cita
 */
class UrlCita extends \yii\db\ActiveRecord
{
    const PARA_CITA = 0;
    const PARA_FEEDBACK = 1;


    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'url_cita';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_cita', 'llave','tipo'], 'required'],
            [['id_cita','tipo'], 'integer'],
            [['fecha'], 'safe'],
            [['llave'], 'string', 'max' => 6],
            [['token'], 'string', 'max' => 12],
            [['id_cita'], 'exist', 'skipOnError' => true, 'targetClass' => Cita::className(), 'targetAttribute' => ['id_cita' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_cita' => 'Id Cita',
            'llave' => 'Llave',
            'fecha' => 'Fecha',
            'token' => 'Token',
            'tipo' => 'Tipo'
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCita()
    {
        return $this->hasOne(Cita::className(), ['id' => 'id_cita']);
    }
}
