<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "recordatorio".
 *
 * @property int $id
 * @property int $id_suscripcion
 * @property string $nombre
 * @property string $tiempo_previo
 * @property bool $es_movil
 * @property bool $activo
 * @property bool $es_correo
 * @property bool $es_personalizado
 * @property string $tiempo
 * @property string $unidad_tiempo
 *
 * @property Suscripcion $suscripcion
 */
class Recordatorio extends \yii\db\ActiveRecord
{
    
    const UNIDADES = ['MINUTE' => 'minutos' , 'HOUR' => 'horas', 'DAY' => 'días'];
    const HORAS = 'HOUR';
    const MINUTOS = 'MINUTE';
    const DIAS = 'DAY';
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'recordatorio';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_suscripcion', 'nombre','unidad_tiempo'], 'required'],
            [['id_suscripcion','tiempo_previo'], 'integer'],
            [['tiempo_previo','dias'], 'safe'],
            [['es_movil','activo','es_correo','es_personalizado'], 'boolean'],
            [['nombre'], 'string', 'max' => 200],
            [['unidad_tiempo'], 'string', 'max' => 20],
            [['id_suscripcion'], 'exist', 'skipOnError' => true, 'targetClass' => Suscripcion::className(), 'targetAttribute' => ['id_suscripcion' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_suscripcion' => 'Id Suscripcion',
            'nombre' => 'Nombre',
            'tiempo_previo' => 'Tiempo (horas)',
            'dias' => 'Tiempo de recordatorio',
            'es_movil' => 'Por móvil',
            'activo' => 'Activo',
            'tiempo' => 'Tiempo de recordatorio',
            'es_correo' => 'Por correo',
            'es_personalizado' => 'Personalizado',
            'unidad_tiempo' => 'Unidad de tiempo',
        ];
    }

    
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSuscripcion()
    {
        return $this->hasOne(Suscripcion::className(), ['id' => 'id_suscripcion']);
    }
    
    /**
     * @return string
     */
    public function getTiempo()
    {
        return $this->tiempo_previo . ' ' . (self::UNIDADES[$this->unidad_tiempo]);
    }
}
