<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "producto".
 *
 * @property int $id
 * @property string $codigo
 * @property string $nombre
 * @property string $descripcion
 * @property string $costo
 * @property int $id_unidad_medida
 * @property string $nombreUnidadMedida
 * @property bool $activo
 * @property int $id_proveedor
 * @property string $nombreProveedor
 * @property int $id_categoria
 * @property string $nombreCategoria
 * @property int $id_suscripcion
 *
 * @property UnidadMedida $unidadMedida
 * @property Proveedor $proveedor
 * @property CategoriaProducto $categoria
 * @property Suscripcion $suscripcion
 */
class Producto extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'producto';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['codigo', 'nombre','id_proveedor','id_categoria','id_suscripcion'], 'required'],
            [['costo'], 'number'],
            [['id_unidad_medida', 'id_proveedor', 'id_categoria','id_suscripcion'], 'integer'],
            [['activo'], 'boolean'],
            [['codigo'], 'string', 'max' => 50],
            [['nombre'], 'string', 'max' => 250],
            [['descripcion'], 'string', 'max' => 500],
            [['id_unidad_medida'], 'exist', 'skipOnError' => true, 'targetClass' => UnidadMedida::className(), 'targetAttribute' => ['id_unidad_medida' => 'id']],
            [['id_proveedor'], 'exist', 'skipOnError' => true, 'targetClass' => Proveedor::className(), 'targetAttribute' => ['id_proveedor' => 'id']],
            [['id_categoria'], 'exist', 'skipOnError' => true, 'targetClass' => CategoriaProducto::className(), 'targetAttribute' => ['id_categoria' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'codigo' => 'Código',
            'nombre' => 'Nombre',
            'descripcion' => 'Descripción',
            'costo' => 'Costo',
            'id_unidad_medida' => 'Unidad Medida',
            'activo' => 'Activo',
            'id_proveedor' => 'Proveedor',
            'id_categoria' => 'Categoría',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUnidadMedida()
    {
        return $this->hasOne(UnidadMedida::className(), ['id' => 'id_unidad_medida']);
    }
    
    /**
     * @return string
     */
    public function getNombreUnidadMedida()
    {
        return $this->unidadMedida->nombre;
    }
    

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getProveedor()
    {
        return $this->hasOne(Proveedor::className(), ['id' => 'id_proveedor']);
    }
    
    /**
     * @return string
     */
    public function getNombreProveedor()
    {
        return $this->proveedor->nombre;
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCategoria()
    {
        return $this->hasOne(CategoriaProducto::className(), ['id' => 'id_categoria']);
    }
    
    /**
     * @return string
     */
    public function getNombreCategoria()
    {
        return $this->categoria->nombre;

    }
    
     /**
     * @return \yii\db\ActiveQuery
     */
    public function getSuscripcion()
    {
        return $this->hasOne(Suscripcion::className(), ['id' => 'id_suscripcion']);
    }
}
