<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "plan".
 *
 * @property int $id
 * @property string $nombre
 * @property string $descripcion
 * @property bool $activo
 * @property string $precio
 * @property string $precio_cita
 * @property string $stripe_id
 * @property int $maximo_usuarios
 * @property int $maximo_mensajes
 * @property string $descripcionPlan
 * @property int $tipo
 * @property string $textoTipo
 * @property Suscripcion[] $suscripciones
 */
class Plan extends \yii\db\ActiveRecord
{
    const TIPO_X_CITAS = 0;
    const TIPO_X_SMS = 1;
    
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'plan';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['nombre','precio','precio_cita', 'tipo'], 'required','message'=>'El campo \'{attribute}\' no puede quedar vacío.'],
            [['activo'], 'boolean'],
            [['maximo_usuarios','maximo_mensajes', 'tipo'], 'integer'],
            [['precio','precio_cita', 'tipo'], 'number'],
            [['nombre'], 'string', 'max' => 150],
            [['stripe_id'], 'string', 'max' => 75],
            [['descripcion'], 'string', 'max' => 500],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'Id',
            'nombre' => 'Nombre',
            'descripcion' => 'Descripción',
            'activo' => 'Activo',
            'precio' => 'Precio base',
            'precio_cita' => 'Precio por cita',
            'maximo_usuarios' => 'Usuarios máximos',
            'maximo_mensajes' => 'Mensajes máximos',
            'tipo' => 'Tipo',
            'stripe_id' => 'Stripe ID',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSuscripciones()
    {
        return $this->hasMany(Suscripcion::className(), ['id_plan' => 'id']);
    }
    
    public function getDescripcionPlan()
    {
        return nl2br($this->descripcion);
    }
    
    public function getTextoTipo()
    {
        return $this->tipo == self::TIPO_X_CITAS ? 'Cobro Por Citas' : 'Cobro Por SMS';
    }        
}
