<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "pais".
 *
 * @property int $id
 * @property string $iso
 * @property string $nombre
 * @property string $moneda
 * @property string $simbolo
 * @property float $iva
 *
 * @property Paciente[] $pacientes
 * @property Suscripcion[] $suscripciones
 */
class Pais extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'pais';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['nombre'], 'required'],
            [['iva'], 'number'],
            [['moneda'], 'string', 'max' => 25],
            [['iso'], 'string', 'max' => 2],
            [['nombre'], 'string', 'max' => 250],
            [['simbolo'], 'string', 'max' => 10],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'iso' => 'Iso',
            'nombre' => 'Nombre',
            'moneda' => 'Moneda',
            'simbolo' => 'Símbolo',
            'iva' => 'IVA',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPacientes()
    {
        return $this->hasMany(Paciente::className(), ['id_pais' => 'id']);
    }
    
    
    /**
     * Gets query for [[Suscripcions]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getSuscripciones()
    {
        return $this->hasMany(Suscripcion::className(), ['id_pais' => 'id']);
    }
    
    /**
     * Get simbolol for Pais.
     *
     * @return string
     */
    public function getSimbolo()
    {
        return !empty($this->simbolo) ? $this->simbolo : '$';
    }
}
