<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "pagadito".
 *
 * @property int $id
 * @property string $uid
 * @property string $wsk
 * @property int $id_suscripcion
 * @property int $metodo_cobro
 * @property int $cargar_iva
 * @property string $webhook_url
 * @property string $link_externo
 * @property int $cobrar_pasarela
 * @property float $monto_fijo
 * @property int $monto_porcentual
 * @property int $tipo
 * @property Suscripcion $suscripcion
 */
class Pagadito extends \yii\db\ActiveRecord
{
    const PAGADITO = 0;
    const LINK_EXTERNO = 1;
    
    const MEDIO_PAGO_PAGADITO = 'Utilizar Pagadito';
    const MEDIO_PAGO_LINK = 'Utilizar un link propio';  
    
    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'pagadito';
    }
    
    /**
     * {@inheritdoc}
     */
    public function rules(){
        return [
            [['id_suscripcion'], 'required', 'message'=> 'El campo \'{attribute}\' no puede quedar vacío.'],
            [['id_suscripcion','metodo_cobro', 'cargar_iva', 'cobrar_pasarela','tipo'], 'integer'],
            [['monto_fijo','monto_porcentual',], 'number'],
            [['uid', 'wsk'], 'string', 'max'=> 32],
            [['link_externo'], 'string', 'max'=> 150],
            [['webhook_url'], 'safe'],
            [['id_suscripcion'], 'exist', 'skipOnError' => true, 'targetClass' => Suscripcion::className(), 'targetAttribute' => ['id_suscripcion' => 'id']]
        ];
    }
    
    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'id' => 'ID',
            'uid' => 'Pagadito UID',
            'wsk' => 'Pagadito WSK',
            'metodo_cobro' => 'Metodo Cobro', 
            'cargar_iva' => 'Cargar IVA', 
            'id_suscripcion' => 'ID Suscripción',
            'webhook_url' => 'Pagadito URL WebHook',
            'tipo' => 'Tipo',
            'link_externo' => 'Link de cobro externo',
            'cobrar_pasarela' => 'Cobrar Pasarela'
        ];
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSuscripcion()
    {
        return $this->hasOne(Suscripcion::className(), ['id' => 'id_suscripcion']);
    }
}
