<?php
namespace app\models;

use Yii;

/**
 * This is the model class for table "notificacion_suscripcion".
 *
 * @property int $id
 * @property int $id_notificacion
 * @property int $id_suscripcion
 * @property string $fecha_creacion
 * @property bool $visto
 * @property bool $leido
 * @property string $fecha_visto
 * @property string $fecha_leido
 * @property Suscripcion $suscripcion
 * @property Notificacion $notificacion	 
 */
class NotificacionSuscripcion extends yii\db\ActiveRecord
{
    public $hasFormat = false;
  
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
            return 'notificacion_suscripcion';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
            return [
                [['id_notificacion','id_suscripcion','fecha_creacion'],'required'],
                [['id_notificacion','id_suscripcion'],'integer'],
                [['visto','leido'],'boolean'],
                [['fecha_creacion','fecha_visto','fecha_leido'],'safe'],
                [['id_notificacion'], 'exist', 'skipOnError' => true, 'targetClass' => Notificacion::className(), 'targetAttribute' => ['id_notificacion' => 'id']],
                [['id_suscripcion'], 'exist', 'skipOnError' => true, 'targetClass' => Suscripcion::className(), 'targetAttribute' => ['id_suscripcion' => 'id']],
            ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_cita' => 'Id Cita',
            'id_adjunto' => 'Id Adjunto'
        ];
    }
    

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSuscripcion()
    {
        return $this->hasOne(Suscripcion::className(), ['id' => 'id_suscripcion']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getNotificacion()
    {
        return $this->hasOne(Notificacion::className(), ['id' => 'id_notificacion']);
    }  
}
