<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "horario_medico".
 *
 * @property int $id
 * @property int $id_suscripcion
 * @property int $id_clinica
 * @property int $dia
 * @property string $hora_inicio
 * @property string $hora_fin
 *
 * @property Suscripcion $suscripcion
 * @property Clinica $clinica
 
 */
class HorarioMedico extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'horario_medico';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_suscripcion', 'dia', 'hora_inicio', 'hora_fin','id_clinica'], 'required','message'=>'El campo \'{attribute}\' no puede quedar vacío.'],
            [['id_suscripcion', 'dia','id_clinica'], 'integer'],
            [['hora_inicio', 'hora_fin'], 'safe'],
            [['id_suscripcion'], 'exist', 'skipOnError' => true, 'targetClass' => Suscripcion::className(), 'targetAttribute' => ['id_suscripcion' => 'id']],
            [['id_clinica'], 'exist', 'skipOnError' => true, 'targetClass' => Clinica::className(), 'targetAttribute' => ['id_clinica' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_suscripcion' => 'Suscripción',
            'dia' => 'Día',
            'hora_inicio' => 'Hora Inicio',
            'hora_fin' => 'Hora Fin',
            'id_clinica' => 'Clínica',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSuscripcion()
    {
        return $this->hasOne(Suscripcion::className(), ['id' => 'id_suscripcion']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getClinica()
    {
        return $this->hasOne(Clinica::className(), ['id' => 'id_suscripcion']);
    }
}
