<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "historial_medico_paciente".
 *
 * @property int $id
 * @property int $id_paciente
 * @property string $cuerpo
 * @property string $fecha
 * @property string $formatoCuerpo
 * @property Paciente $paciente
 * @property string $fechaDB
 */
class HistorialMedicoPaciente extends \yii\db\ActiveRecord
{
    public $hasFormat = false;
    
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'historial_medico_paciente';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_paciente','cuerpo', 'fecha'], 'required'],
            [['id_paciente'], 'integer'],
            [['id_paciente'], 'exist', 'skipOnError' => true, 'targetClass' => Paciente::className(), 'targetAttribute' => ['id_paciente' => 'id']]
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_paciente' => 'Id Paciente',
            'cuerpo' => 'Cuerpo',
            'Fecha' => 'Fecha'
        ];
    }
    
//    public function afterFind(){
//        $fecha = $this->fecha;
//        if(!is_null($fecha) || !empty($fecha)){
//            $fecha_f = \DateTime::createFromFormat('Y-m-d', $fecha)->format('d/m/Y');
//            $this->fecha = $fecha_f;
//            $this->hasFormat = false;
//        }
//    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPaciente()
    {
        return $this->hasOne(Paciente::className(), ['id' => 'id_paciente']);
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getFormatoCuerpo()
    {
        return nl2br($this->cuerpo);
    }
    
    
    public function beforeSave($insert) {
        if(parent::beforeSave($insert)){
            if(!$this->hasFormat){
                $fecha = $this->fechaDB;
                $this->fecha = $fecha;
                $this->hasFormat = true;
            }
            return true;
        }
        return false;
    }

    public function getFechaDB(){
        if(!$this->hasFormat){
            return \DateTime::createFromFormat('d/m/Y', $this->fecha)->format('Y-m-d');
        }
        return $this->fecha;
    }
    
    

}
