<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "grupo_trabajo".
 *
 * @property int $id
 * @property string $nombre
 * @property int $id_suscripcion
 *
 * @property GrupoTrabajoUsuario[] $grupoTrabajoUsuarios
 * @property GrupoProcedimiento[] $gruposProcedimiento
 */
class GrupoTrabajo extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'grupo_trabajo';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_suscripcion'],'required'],
            [['id_suscripcion'], 'integer'],
            [['nombre'], 'string', 'max' => 200],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'nombre' => 'Grupo',
            'id_suscripcion' => 'Id Suscripcion',
        ];
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGruposProcedimiento()
    {
        return $this->hasMany(GrupoProcedimiento::className(), ['id_grupo' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGrupoTrabajoUsuarios()
    {
        return $this->hasMany(GrupoTrabajoUsuario::className(), ['id_grupo' => 'id']);
    }
    
    public function getGrupoClinicas(){
        $usuarios = $this->getGrupoTrabajoUsuarios()->select('id_usuario')->column();
        $idClinicas = UsuarioSuscripcion::find()->where(['id_usuario' => $usuarios])->select('id_clinica')->column();
        $clinicas = Clinica::find()->where(['id' => $idClinicas])->all();
        return $clinicas;
        
    }
}
