<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "grupo_procedimiento".
 *
 * @property int $id
 * @property int $id_procedimiento
 * @property int $id_grupo
 *
 * @property GrupoTrabajo $grupo
 * @property Procedimiento $procedimiento
 */
class GrupoProcedimiento extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'grupo_procedimiento';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_procedimiento', 'id_grupo'], 'required'],
            [['id_procedimiento', 'id_grupo'], 'integer'],
            [['id_grupo'], 'exist', 'skipOnError' => true, 'targetClass' => GrupoTrabajo::className(), 'targetAttribute' => ['id_grupo' => 'id']],
            [['id_procedimiento'], 'exist', 'skipOnError' => true, 'targetClass' => Procedimiento::className(), 'targetAttribute' => ['id_procedimiento' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_procedimiento' => 'Id Procedimiento',
            'id_grupo' => 'Id Grupo',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGrupo()
    {
        return $this->hasOne(GrupoTrabajo::className(), ['id' => 'id_grupo']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getProcedimiento()
    {
        return $this->hasOne(Procedimiento::className(), ['id' => 'id_procedimiento']);
    }
}
