<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\FormaPago;

/**
 * FormaPagoSearch represents the model behind the search form of `app\models\FormaPago`.
 */
class FormaPagoSearch extends FormaPago
{
    
    
    public $nombreUsuario;
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'created'], 'integer'],
            [['customer_id', 'currency', 'invoice_prefix', 'description', 'pay_method', 'subcription_id','nombreUsuario'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = FormaPago::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
        
        $query->join('INNER JOIN','usuario', 'usuario.id = forma_pago.id');
                
        $dataProvider->sort->attributes['nombreUsuario'] = [
            'asc' => ['usuario.nombre_usuario' => SORT_ASC],
            'desc' => ['usuario.nombre_usuario' => SORT_DESC],
        ];

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'created' => $this->created,
        ]);
        
        if($this->nombreUsuario != null && $this->nombreUsuario != ''){
            
            $query->andFilterWhere(['like','usuario.nombre_usuario',$this->nombreUsuario]);
        }

        $query->andFilterWhere(['like', 'customer_id', $this->customer_id])
            ->andFilterWhere(['like', 'currency', $this->currency])
            ->andFilterWhere(['like', 'invoice_prefix', $this->invoice_prefix])
            ->andFilterWhere(['like', 'description', $this->description])
            ->andFilterWhere(['like', 'pay_method', $this->pay_method])
            ->andFilterWhere(['like', 'subcription_id', $this->subcription_id]);

        return $dataProvider;
    }
}
