<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "firma_medico".
 *
 * @property int $id
 * @property int $id_suscripcion
 * @property string $firma_src_nombre 
 * @property string $firma_web_ruta
 * @property string $srcFirma
 */
class FirmaMedico extends \yii\db\ActiveRecord
{
    const RUTA_CARGA = '/web/uploads/firma_medico/';
    const RUTA_LECTURA = 'uploads/firma_medico/';
    
    public $firma;
    
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'firma_medico';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_suscripcion'], 'required'],
            [['id_suscripcion'], 'integer'],
            [['firma'],'image', 
                    'extensions'=> ['jpg', 'png', 'jpeg'],
                    'maxSize' => 1000*1000, 
                    'maxFiles' => 1, 
                    'minWidth' => 100, 
                    'maxWidth' => 250,
                    'minHeight' => 100, 
                    'maxHeight' => 250, 
                    'mimeTypes'=>['image/*'],
                    'maxSize' => 1024*1024*3, 
                    'tooBig' => 'El tamaño máximo permitido es 5MB',
                ],
            [['firma_src_nombre', 'firma_web_ruta'], 'string', 'max' => 255],
            [['id_suscripcion'], 'exist', 'skipOnError' => true, 'targetClass' => Suscripcion::className(), 'targetAttribute' => ['id_suscripcion' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_suscripcion' => 'ID suscripcion',
            'firma_src_nombre' => 'Nombre',
            'firma_web_ruta' => 'Ruta'
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSuscripcion()
    {
        return $this->hasOne(Suscripcion::className(), ['id' => 'id_suscripcion']);
    }

    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSrcFirma(){
        return Yii::$app->homeUrl.FirmaMedico::RUTA_LECTURA.$this->firma_src_nombre;
    }
  
}
