<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "feedback".
 *
 * @property int $id
 * @property int $id_cita
 * @property int $puntuacion
 * @property string $comentario
 * @property string $fecha
 * @property bool $anonimo
 * @property Cita $cita
 */
class Feedback extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'feedback';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_cita', 'puntuacion'], 'required'],
            [['id_cita', 'puntuacion'], 'integer'],
            [['fecha'], 'safe'],
            [['anonimo'], 'boolean'],
            [['comentario'], 'string', 'max' => 600],
            [['id_cita'], 'exist', 'skipOnError' => true, 'targetClass' => Cita::className(), 'targetAttribute' => ['id_cita' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_cita' => 'Id Cita',
            'puntuacion' => 'Puntuacion',
            'comentario' => 'Comentario',
            'fecha' => 'Fecha',
            'anonimo' => 'Retroalimentación anónima'
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCita()
    {
        return $this->hasOne(Cita::className(), ['id' => 'id_cita']);
    }
}
