<?php

namespace app\models;

use Yii;
use app\customs\SesionUtils;


/**
 * This is the model class for table "configuracion".
 *
 * @property int $id
 * @property string $nombre
 * @property string $llave
 * @property string $valor
 * @property string $posibles_valores
 * @property string $descripcion
 * @property bool $es_suscripcion
 * @property int $tipo
 * @property int $orden
 */
class Configuracion extends \yii\db\ActiveRecord
{
    
    const TIPO_BOLEANO = 0;
    const TIPO_CHECKBOX_GROUP = 1;    
    const TIPO_LISTA = 2;
    const TIPO_TEXTO = 3;
    const TIPO_ENTERO = 4;
    const TIPO_RADIO_BTN_GROUP = 5;

    const TIPOS = ['Boleano','Checkbox Group', 'Lista', 'Texto', 'Númerico', 'Grupo de Boleanos'];
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'configuracion';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['llave', 'valor','nombre','tipo', 'orden'], 'required'],
            [['es_suscripcion','es_clinica'], 'boolean'],
            [['tipo'], 'integer'],
            [['nombre'], 'string', 'max' => 150],
            [['llave'], 'string', 'max' => 50],
            [['valor'], 'string', 'max' => 300],
            [['posibles_valores', 'descripcion'], 'string', 'max' => 500],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'nombre' => 'Nombre',
            'llave' => 'Llave',
            'valor' => 'Valor',
            'posibles_valores' => 'Posibles Valores',
            'descripcion' => 'Descripción',
            'es_suscripcion' => 'Es Suscripcion',
            'tipo' => 'Tipo',
            'orden' => 'Orden',
            'es_clinica' => 'Es Clínica'
        ];
    }
    
    /**
     * Devuelve una copia para suscripcion
     * @param bool $esSuscripcionJerarquizada 
     * @param bool $esAdminJerarquia 
     * @return \app\models\ConfiguracionSuscripcion
     */
    public function toSuscripcion($esSuscripcionJerarquizada = false, $esAdminJerarquia = false){
        $conf = new ConfiguracionSuscripcion();
        $conf->llave = $this->llave;
        $conf->descripcion = $this->descripcion;
        $conf->nombre = $this->nombre;
        $conf->posibles_valores = $this->posibles_valores;
        $conf->tipo = $this->tipo;
        $conf->valor = $this->valor;
        $conf->visible = true;
        $conf->orden = $this->orden;
        $conf->id_clinica = ($esSuscripcionJerarquizada && $esAdminJerarquia == false) ? SesionUtils::ClinicaSeleccionada()->id : NULL;
        return $conf;
    }
}
