<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "clinica_procedimiento".
 *
 * @property int $id
 * @property int $id_procedimiento
 * @property int $id_clinica
 *
 * @property Clinica $clinica
 * @property Procedimiento $procedimiento
 */
class ClinicaProcedimiento extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'clinica_procedimiento';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_procedimiento', 'id_clinica'], 'required'],
            [['id_procedimiento', 'id_clinica'], 'integer'],
            [['id_clinica'], 'exist', 'skipOnError' => true, 'targetClass' => Clinica::className(), 'targetAttribute' => ['id_clinica' => 'id']],
            [['id_procedimiento'], 'exist', 'skipOnError' => true, 'targetClass' => Procedimiento::className(), 'targetAttribute' => ['id_procedimiento' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_procedimiento' => 'Id Procedimiento',
            'id_clinica' => 'Id Clinica',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getClinica()
    {
        return $this->hasOne(Clinica::className(), ['id' => 'id_clinica']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getProcedimiento()
    {
        return $this->hasOne(Procedimiento::className(), ['id' => 'id_procedimiento']);
    }
}
