<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "clinica".
 *
 * @property int $id
 * @property string $nombre
 * @property string $direccion
 * @property string $telefono
 * @property string $celular
 * @property int $id_suscripcion
 * @property string $logo_src_nombre
 * @property string $logo_web_ruta
 * @property Suscripcion $suscripcion
 * @property string  srcLogo
 * @property Cita[] $citas
 * @property UsuarioSuscripcion[] $usuarioSuscripciones
 * @property HorarioMedico[] $horarios
 * @property ClinicaProcedimiento[] $clinicaProcedimientos
 */
class Clinica extends \yii\db\ActiveRecord
{
    
    public $logo;
    
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'clinica';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['nombre', 'id_suscripcion'], 'required'],
            [['id_suscripcion'], 'integer'],
            [['nombre'], 'string', 'max' => 40],
            [['telefono', 'celular'], 'string', 'max' => 25],
            [['celular'], 'safe'],
            [['direccion'], 'string', 'max' => 500],
            [['logo'],'image', 
                    'extensions'=> ['jpg', 'gif', 'png', 'jpeg'],
                    'maxSize' => 600*600, 
                    'maxFiles' => 6, 
                    'minWidth' => 200, 
                    'maxWidth' => 300,
                    'minHeight' => 200, 
                    'maxHeight' => 300, 
                    'mimeTypes'=>['image/*'],
                    'maxSize' => 1024*1024*3, 
                    'tooBig' => 'El tamaño máximo permitido es 5MB',
                ],
            [['logo_src_nombre', 'logo_web_ruta'], 'string', 'max' => 255],
            [['id_suscripcion'], 'exist', 'skipOnError' => true, 'targetClass' => Suscripcion::className(), 'targetAttribute' => ['id_suscripcion' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'nombre' => 'Nombre',
            'direccion' => 'Dirección',
            'telefono' => 'Télefono',
            'celular' => 'Celular',
            'id_suscripcion' => 'Id Suscripcion',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSuscripcion()
    {
        return $this->hasOne(Suscripcion::className(), ['id' => 'id_suscripcion']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUsuarioSuscripcions()
    {
        return $this->hasMany(UsuarioSuscripcion::className(), ['id_clinica' => 'id']);
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getClinicaProcedimientos()
    {
        return $this->hasMany(ClinicaProcedimiento::className(), ['id_clinica' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getHorarios()
    {
        return $this->hasMany(HorarioMedico::className(), ['id_clinica' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCitas()
    {
        return $this->hasMany(Cita::className(), ['id_clinica' => 'id']);
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSrcLogo(){
        return Yii::$app->homeUrl.Yii::$app->params['srcLogoClinica'].$this->logo_src_nombre;
    }
  
    public function beforeDelete()
    {
        if (!parent::beforeDelete()) {
            return false;
        }
        if($this->getCitas()->count() > 0){
            return false;
        }
        HorarioMedico::deleteAll(['id_clinica' => $this->id]);
        ClinicaProcedimiento::deleteAll(['id_clinica' => $this->id]);
        return true;
    }
}
