<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace app\models;


use \yii\db\Query;
use yii\base\Model;
use yii\db\Expression;
use app\customs\SesionUtils;
/**
 * Description of CitaEvento
 *
 * @author jose.nieves
 */
class CitaEvento extends Model
{
    public $tiempo_estimado;
    public $fecha;
    public $fecha_fin;
    public $tipo;
    public $id_clinica;
    public $id_suscripcion;
    
    public function rules()
    {
        return [
            [['fecha', 'fecha_fin'], 'required','message'=>'El campo \'{attribute}\' no puede quedar vacío.'],
            [['tiempo_estimado','id_clinica','id_suscripcion'], 'integer'],
            [['tipo'], 'string'],
            [['fecha','fecha_fin'], 'safe']
        ];
    }
    
    /**
     * 
     * @param int $id_suscripcion
     * @param int $id_clinica
     * @param string $fecha
     * @param int $dia
     * @param string $hora_inicio
     * @param string $hora_fin
     * @return app\models\CitaEvento[]
     */
    public static function obtenerCitaEvento($id_suscripcion,$id_clinica,$fecha,$dia,$hora_inicio,$hora_fin){
        $queryCita = (new Query())
                ->select([
                    'fecha',
                    'tiempo_estimado',
                    new Expression('DATE_ADD(fecha,INTERVAL tiempo_estimado MINUTE) fecha_fin'),
                    new Expression('\'c\' tipo')
                ])
                ->from('cita')
                ->where(['=','id_suscripcion',$id_suscripcion])
                ->andFilterWhere(['=','id_clinica',$id_clinica])
                ->andFilterWhere(['=',new Expression('DATE(fecha)'),new Expression('DATE(\'' . $fecha . '\')')])
                ->andFilterWhere([
                            'AND',
                            ['=', new Expression('DAYOFWEEK(fecha)'),$dia],
                            ['BETWEEN',new Expression('HOUR(fecha)'), $hora_inicio,$hora_fin]
                        ]);
        $queryEvento = (new Query())
                ->select([
                        new Expression("(CASE WHEN fecha_inicio < (CONCAT(DATE('" . $fecha . "'),' ', TIME('" . $hora_inicio . "'))) THEN (CONCAT(DATE('" . $fecha . "'),' ', TIME('" . $hora_inicio . "'))) ELSE fecha_inicio END) fecha"),
                        new Expression("TIMESTAMPDIFF(MINUTE,fecha_inicio,fecha_fin) as tiempo_estimado"),
                        new Expression("(CASE WHEN fecha_fin > (CONCAT(DATE('" . $fecha . "'),' ', TIME('" . $hora_fin . "'))) THEN (CONCAT(DATE('" . $fecha . "'),' ', TIME('" . $hora_fin . "'))) ELSE fecha_fin END) fecha_fin"),
                        new Expression('\'e\' tipo'),
                    ])
                ->from('evento')
                ->where(['=','id_suscripcion',$id_suscripcion])
                ->andFilterWhere([
                        'OR',
                        [
                            'AND',
                            ['=', new Expression('DATE(fecha_inicio)'),new Expression('DATE(\''. $fecha .'\')')],
                            ['BETWEEN',new Expression('HOUR(fecha_inicio)'), $hora_inicio,$hora_fin]
                        ],
                        [
                            'AND',
                            ['=', new Expression('DATE(fecha_fin)'),new Expression('DATE(\''. $fecha .'\')')],
                            ['BETWEEN',new Expression('HOUR(fecha_fin)'), $hora_inicio,$hora_fin]
                        ]
                    ]);
        
        $cita_evento = (new Query())
            ->from(['cita_evento' => $queryCita->union($queryEvento)])
            ->orderBy(['fecha' => SORT_ASC])->all();
        return self::arrayQueryToModel($cita_evento);
    }
    
    /**
     * 
     * @param array $attr
     * @return \app\models\CitaEvento
     */
    private static function toModel($attr){
        $citaEvento = new CitaEvento();
        $citaEvento->tiempo_estimado = $attr['tiempo_estimado'];
        $citaEvento->fecha =$attr['fecha'];
        $citaEvento->tipo = $attr['tipo'];
        $citaEvento->fecha_fin = $attr['fecha_fin'];
        return $citaEvento;
    }
    
    /**
     * 
     * @param [] $result
     * @return app\models\CitaEvento[] 
     */
    private static function arrayQueryToModel($result){
        $citasEventos = [];
        foreach ($result as $attr){
            $citasEventos[] = self::toModel($attr);
        }
        return $citasEventos;
    }
    
    /**
     * Citas eventos para barrido no disponible
     * @param int $id_suscripcion
     * @param int $id_clinica
     * @param string $fecha
     * @param int $duracion
     * @param int $id_cita
     * @param Suscripcion $suscripcion
     * @return CitaEvento[]
     */
    public static function obtenerCitaEventos($id_suscripcion,$id_clinica,
            $fecha,$duracion,$id_cita,$suscripcion){
        $queryCita = (new Query())
                ->select([
                    new Expression('DATE_ADD(fecha,INTERVAL -' . ($duracion - 5) . ' MINUTE) fecha'),
                    'tiempo_estimado',
                    new Expression('DATE_ADD(fecha,INTERVAL tiempo_estimado MINUTE) fecha_fin'),
                    new Expression('\'c\' tipo')
                ])
                ->from('cita')
                ->where(['=','id_suscripcion',$id_suscripcion])
                ->andFilterWhere(['=','id_clinica',$id_clinica])
                ->andFilterWhere(['<>','estado', Cita::CANCELADA])
                ->andFilterWhere(['=',new Expression('DATE(fecha)'),new Expression('DATE(\'' . $fecha . '\')')]);
        if($id_cita != 0){
            $queryCita->andFilterWhere(['<>','id',$id_cita]);
        }
        $queryEvento = (new Query())
                ->select([
                        new Expression("(CASE WHEN DATE_ADD(fecha_inicio,INTERVAL -" . ($duracion - 5) . " MINUTE) < (CONCAT(DATE('" . $fecha . "'),' ', '00:00')) THEN (CONCAT(DATE('" . $fecha . "'),' ', '00:00')) ELSE DATE_ADD(fecha_inicio,INTERVAL -" . ($duracion - 5) . " MINUTE) END) fecha"),
                        new Expression("TIMESTAMPDIFF(MINUTE,fecha_inicio,fecha_fin) as tiempo_estimado"),
                        new Expression("(CASE WHEN fecha_fin > (CONCAT(DATE('" . $fecha . "'),' ', '23:59')) THEN (CONCAT(DATE('" . $fecha . "'),' ', '23:59')) ELSE fecha_fin END) fecha_fin"),
                        new Expression('\'e\' tipo'),
                    ])
                ->from('evento')
                ->where(['=','id_suscripcion',$id_suscripcion])
                ->andFilterWhere([
                        'OR',
                        ['=', new Expression('DATE(fecha_inicio)'),new Expression('DATE(\''. $fecha .'\')')],
                        ['=', new Expression('DATE(fecha_fin)'),new Expression('DATE(\''. $fecha .'\')')]
                    ]);
        if($suscripcion != null && $suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA){
            $queryEvento->andWhere(['id_clinica' => SesionUtils::ClinicaSeleccionada()->id]);
        }
        $cita_evento = (new Query())
            ->from(['cita_evento' => $queryCita->union($queryEvento)])
            ->orderBy(['fecha' => SORT_ASC])->all();
        return self::arrayQueryToModel($cita_evento);
    }
    
    
    /**
     * Citas eventos para barrido no disponible
     * @param int $id_suscripcion
     * @param int $id_clinica
     * @param string $fecha
     * @param string $horaInicio
     * @param string $horaFin
     * @param int $id_cita
     * @param Suscripcion $suscripcion
     * @return CitaEvento[]
     */
    public static function obtenerCitaEventosPorHorario($id_suscripcion,$id_clinica,$fecha,
            $horaInicio,$horaFin,$id_cita,$suscripcion = null){
        $queryCita = (new Query())
                ->select([
                    new Expression('TIME(fecha) fecha'),
                    'tiempo_estimado',
                    new Expression('TIME(DATE_ADD(fecha,INTERVAL tiempo_estimado MINUTE)) fecha_fin'),
                    new Expression('\'c\' tipo')
                ])
                ->from('cita')
                ->where(['=','id_suscripcion',$id_suscripcion])
                ->andFilterWhere(['=','id_clinica',$id_clinica])
                ->andFilterWhere(['<>','estado',Cita::CANCELADA])
                ->andFilterWhere(['=',new Expression('DATE(fecha)'),new Expression('DATE(\'' . $fecha . '\')')]);
        if($id_cita != 0){
            $queryCita->andFilterWhere(['<>','id',$id_cita]);
        }
        $queryEvento = (new Query())
                ->select([
                        new Expression("(CASE WHEN TIME(fecha_inicio) < TIME('" . $horaInicio . "') THEN '" . $horaInicio . "' ELSE TIME(fecha_inicio) END) fecha"),
                        new Expression("TIMESTAMPDIFF(MINUTE,fecha_inicio,fecha_fin) as tiempo_estimado"),
                        new Expression("(CASE WHEN TIME(fecha_fin) > '". $horaFin . "' THEN '". $horaFin . "' ELSE TIME(fecha_fin) END) fecha_fin"),
                        new Expression('\'e\' tipo'),
                    ])
                ->from('evento')
                ->where(['=','id_suscripcion',$id_suscripcion])
                ->andFilterWhere([
                        'OR',
                        ['=', new Expression('DATE(fecha_inicio)'),new Expression('DATE(\''. $fecha .'\')')],
                        ['=', new Expression('DATE(fecha_fin)'),new Expression('DATE(\''. $fecha .'\')')]
                    ]);
        if($suscripcion != null && $suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA){
            $queryEvento->andWhere(['id_clinica' => SesionUtils::ClinicaSeleccionada()->id]);
        }
        $cita_evento = (new Query())
            ->from(['cita_evento' => $queryCita->union($queryEvento)])
            ->orderBy(['fecha' => SORT_ASC])->all();
        return self::arrayQueryToModel($cita_evento);
    }
    
}
