<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "bitacora_mensaje_paciente".
 *
 * @property int $id
 * @property int $id_paciente
 * @property int $id_bitacora_mensaje
 *
 * @property BitacoraMensajeLibre $bitacoraMensaje
 * @property Paciente $paciente
 */
class BitacoraMensajePaciente extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'bitacora_mensaje_paciente';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_paciente', 'id_bitacora_mensaje'], 'required'],
            [['id_paciente', 'id_bitacora_mensaje'], 'integer'],
            [['id_bitacora_mensaje'], 'exist', 'skipOnError' => true, 'targetClass' => BitacoraMensajeLibre::className(), 'targetAttribute' => ['id_bitacora_mensaje' => 'id']],
            [['id_paciente'], 'exist', 'skipOnError' => true, 'targetClass' => Paciente::className(), 'targetAttribute' => ['id_paciente' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_paciente' => 'Id Paciente',
            'id_bitacora_mensaje' => 'Id Bitacora Mensaje',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBitacoraMensaje()
    {
        return $this->hasOne(BitacoraMensajeLibre::className(), ['id' => 'id_bitacora_mensaje']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPaciente()
    {
        return $this->hasOne(Paciente::className(), ['id' => 'id_paciente']);
    }
}
