<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "bitacora_cita_mensaje".
 *
 * @property int $id
 * @property int $id_cita
 * @property string $fecha
 * @property int $estado_cita
 * @property bool $es_sms
 * @property bool $es_correo
 * @property int $tipo
 *
 * @property Cita $cita
 */
class BitacoraCitaMensaje extends \yii\db\ActiveRecord
{
    
    const ES_RECORDATORIO = 0;
    const ES_RETROALIENTACION  = 1;
    const ES_COBRO = 2;
    
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'bitacora_cita_mensaje';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_cita', 'estado_cita'], 'required'],
            [['id_cita', 'estado_cita', 'tipo'], 'integer'],
            [['fecha'], 'safe'],
            [['es_sms', 'es_correo'], 'boolean'],
            [['id_cita'], 'exist', 'skipOnError' => true, 'targetClass' => Cita::className(), 'targetAttribute' => ['id_cita' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_cita' => 'Id Cita',
            'fecha' => 'Fecha',
            'estado_cita' => 'Estado Cita',
            'es_sms' => 'Es Sms',
            'es_correo' => 'Es Correo',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCita()
    {
        return $this->hasOne(Cita::className(), ['id' => 'id_cita']);
    }
}
