<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "bitacora".
 *
 * @property int $id
 * @property int $id_accion
 * @property int $id_usuario
 * @property string $fecha_accion
 * @property string $parametros
 *
 * @property Accion $accion
 * @property Usuario $usuario
 */
class Bitacora extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'bitacora';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_accion', 'id_usuario', 'fecha_accion', 'parametros'], 'required'],
            [['id_accion', 'id_usuario'], 'integer'],
            [['fecha_accion'], 'safe'],
            [['parametros'], 'string', 'max' => 600],
            [['id_accion'], 'exist', 'skipOnError' => true, 'targetClass' => Accion::className(), 'targetAttribute' => ['id_accion' => 'id']],
            [['id_usuario'], 'exist', 'skipOnError' => true, 'targetClass' => Usuario::className(), 'targetAttribute' => ['id_usuario' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_accion' => 'Id Accion',
            'id_usuario' => 'Id Usuario',
            'fecha_accion' => 'Fecha Accion',
            'parametros' => 'Parametros',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAccion()
    {
        return $this->hasOne(Accion::className(), ['id' => 'id_accion']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUsuario()
    {
        return $this->hasOne(Usuario::className(), ['id' => 'id_usuario']);
    }
}
