<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Accion;

/**
 * AccionSearch represents the model behind the search form of `app\models\Accion`.
 */
class AccionSearch extends Accion
{
    
    public $nombreControlador;
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'id_controlador', 'tipo'], 'integer'],
            [['nombre', 'nombre_amigable', 'descripcion','nombreControlador'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Accion::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'id_controlador' => $this->id_controlador,
            'tipo' => $this->tipo,
        ]);
        
        if($this->nombreControlador != ''){
            $query->andFilterWhere(['id_controlador' => $this->nombreControlador]);
        }

        $query->andFilterWhere(['like', 'nombre', $this->nombre])
            ->andFilterWhere(['like', 'nombre_amigable', $this->nombre_amigable])
            ->andFilterWhere(['like', 'descripcion', $this->descripcion]);

        return $dataProvider;
    }
}
