<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "accion".
 *
 * @property int $id
 * @property string $nombre
 * @property string $nombre_amigable
 * @property string $descripcion
 * @property int $id_controlador
 * @property int $tipo
 * @property string $nombreControlador
 *
 * @property Controlador $controlador
 * @property Permiso[] $permisos
 */
class Accion extends \yii\db\ActiveRecord
{
    
    const TIPO_GENERAL = 0;
    const TIPO_SUSCRIPCION = 1;
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'accion';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['nombre', 'nombre_amigable', 'descripcion', 'id_controlador'], 'required'],
            [['id_controlador','tipo'], 'integer'],
            [['nombre'], 'string', 'max' => 50],
            [['nombre_amigable'], 'string', 'max' => 150],
            [['descripcion'], 'string', 'max' => 250],
            [['id_controlador'], 'exist', 'skipOnError' => true, 'targetClass' => Controlador::className(), 'targetAttribute' => ['id_controlador' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'nombre' => 'Nombre',
            'nombre_amigable' => 'Nombre amigable',
            'descripcion' => 'Descripción',
            'id_controlador' => 'Controlador',
            'tipo' => 'Tipo',
            'nombreControlador' => 'Controlador'
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getControlador()
    {
        return $this->hasOne(Controlador::className(), ['id' => 'id_controlador']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPermisos()
    {
        return $this->hasMany(Permiso::className(), ['id_accion' => 'id']);
    }
    
    
    public function getNombreControlador(){
        return $this->controlador->nombre;
    }
}
