<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace app\customs;

use app\models\Cita;
use app\models\Usuario;
use app\customs\SesionUtils;
use app\models\Procedimiento;
use app\models\GrupoProcedimiento;
use app\models\UsuarioSuscripcion;
use app\models\GrupoTrabajoUsuario;
use app\models\ProcedimientoCita;
/**
 * Description of Utils
 *
 * @author jose.nieves
 */
class Utils {

    public static function nombreEstadoCita($estado) {
        switch ($estado) {
            case Cita::AGENDADA:
                return "Agendada";
            case Cita::REPROGRAMADA:
                return "Reprogramada";
            case Cita::CONFIRMADA:
                return "Confirmada";
            case Cita::CANCELADA:
                return "Cancelada";
            case Cita::COMPLETADA:
                return "Completada";
            case Cita::INASISTENCIA:
               return "Inasistencia";
        }
    }

    /**
     * 
     * @param string $nombres
     * @param string $apellidos
     * @return string
     */
    public static function shortName($nombres, $apellidos) {
        $arr1 = explode(' ', $nombres);
        $arr2 = explode(' ', $apellidos);
        if ($arr2[0] == 'De' || $arr2[0] == 'de') {
            return $arr1[0] . ' ' . $arr2[0] . ' ' . $arr2[1];
        } else {
            return $arr1[0] . ' ' . $arr2[0];
        }
    }

    /**
     * 
     * @param string $name
     * @return string
     */
    public static function firstPartName($name) {
        $arr1 = explode(' ', $name);
        if ($arr1[0] == 'De' || $arr1[0] == 'de') {
            return $arr1[0] . ' ' . $arr1[1];
        } else {
            return $arr1[0];
        }
    }

    /**
     * 
     * @param array $c
     * @param \yii\db\ActiveQuery $query
     * @return \yii\db\ActiveQuery
     */
    public static function filtrarPorClinicas($c, $query) {
        if (isset($c)) {
            $innerWhere = [];
            if (count($c) > 1) {
                $innerWhere[] = 'or';
                foreach ($c as $idc) {
                    $innerWhere[] = ['id_clinica' => $idc];
                }
            } else {
                foreach ($c as $idc) {
                    $innerWhere = ['id_clinica' => $idc];
                }
            }
            $query->andFilterWhere($innerWhere);
        }
        return $query;
    }
	
	public static function eliminarTildes($cadena){

       $replace = [
            'ъ'=>'-', 'Ь'=>'-', 'Ъ'=>'-', 'ь'=>'-',
            'Ă'=>'A', 'Ą'=>'A', 'À'=>'A', 'Ã'=>'A', 'Á'=>'A', 'Æ'=>'A', 'Â'=>'A', 'Å'=>'A', 'Ä'=>'Ae',
            'Þ'=>'B',
            'Ć'=>'C', 'ץ'=>'C', 'Ç'=>'C',
            'È'=>'E', 'Ę'=>'E', 'É'=>'E', 'Ë'=>'E', 'Ê'=>'E',
            'Ğ'=>'G',
            'İ'=>'I', 'Ï'=>'I', 'Î'=>'I', 'Í'=>'I', 'Ì'=>'I',
            'Ł'=>'L',
            'Ñ'=>'N', 'Ń'=>'N',
            'Ø'=>'O', 'Ó'=>'O', 'Ò'=>'O', 'Ô'=>'O', 'Õ'=>'O', 'Ö'=>'Oe',
            'Ş'=>'S', 'Ś'=>'S', 'Ș'=>'S', 'Š'=>'S',
            'Ț'=>'T',
            'Ù'=>'U', 'Û'=>'U', 'Ú'=>'U', 'Ü'=>'Ue',
            'Ý'=>'Y',
            'Ź'=>'Z', 'Ž'=>'Z', 'Ż'=>'Z',
            'â'=>'a', 'ǎ'=>'a', 'ą'=>'a', 'á'=>'a', 'ă'=>'a', 'ã'=>'a', 'Ǎ'=>'a', 'а'=>'a', 'А'=>'a', 'å'=>'a', 'à'=>'a', 'א'=>'a', 'Ǻ'=>'a', 'Ā'=>'a', 'ǻ'=>'a', 'ā'=>'a', 'ä'=>'ae', 'æ'=>'ae', 'Ǽ'=>'ae', 'ǽ'=>'ae',
            'б'=>'b', 'ב'=>'b', 'Б'=>'b', 'þ'=>'b',
            'ĉ'=>'c', 'Ĉ'=>'c', 'Ċ'=>'c', 'ć'=>'c', 'ç'=>'c', 'ц'=>'c', 'צ'=>'c', 'ċ'=>'c', 'Ц'=>'c', 'Č'=>'c', 'č'=>'c', 'Ч'=>'ch', 'ч'=>'ch',
            'ד'=>'d', 'ď'=>'d', 'Đ'=>'d', 'Ď'=>'d', 'đ'=>'d', 'д'=>'d', 'Д'=>'D', 'ð'=>'d',
            'є'=>'e', 'ע'=>'e', 'е'=>'e', 'Е'=>'e', 'Ə'=>'e', 'ę'=>'e', 'ĕ'=>'e', 'ē'=>'e', 'Ē'=>'e', 'Ė'=>'e', 'ė'=>'e', 'ě'=>'e', 'Ě'=>'e', 'Є'=>'e', 'Ĕ'=>'e', 'ê'=>'e', 'ə'=>'e', 'è'=>'e', 'ë'=>'e', 'é'=>'e',
            'ф'=>'f', 'ƒ'=>'f', 'Ф'=>'f',
            'ġ'=>'g', 'Ģ'=>'g', 'Ġ'=>'g', 'Ĝ'=>'g', 'Г'=>'g', 'г'=>'g', 'ĝ'=>'g', 'ğ'=>'g', 'ג'=>'g', 'Ґ'=>'g', 'ґ'=>'g', 'ģ'=>'g',
            'ח'=>'h', 'ħ'=>'h', 'Х'=>'h', 'Ħ'=>'h', 'Ĥ'=>'h', 'ĥ'=>'h', 'х'=>'h', 'ה'=>'h',
            'î'=>'i', 'ï'=>'i', 'í'=>'i', 'ì'=>'i', 'į'=>'i', 'ĭ'=>'i', 'ı'=>'i', 'Ĭ'=>'i', 'И'=>'i', 'ĩ'=>'i', 'ǐ'=>'i', 'Ĩ'=>'i', 'Ǐ'=>'i', 'и'=>'i', 'Į'=>'i', 'י'=>'i', 'Ї'=>'i', 'Ī'=>'i', 'І'=>'i', 'ї'=>'i', 'і'=>'i', 'ī'=>'i', 'ĳ'=>'ij', 'Ĳ'=>'ij',
            'й'=>'j', 'Й'=>'j', 'Ĵ'=>'j', 'ĵ'=>'j', 'я'=>'ja', 'Я'=>'ja', 'Э'=>'je', 'э'=>'je', 'ё'=>'jo', 'Ё'=>'jo', 'ю'=>'ju', 'Ю'=>'ju',
            'ĸ'=>'k', 'כ'=>'k', 'Ķ'=>'k', 'К'=>'k', 'к'=>'k', 'ķ'=>'k', 'ך'=>'k',
            'Ŀ'=>'l', 'ŀ'=>'l', 'Л'=>'l', 'ł'=>'l', 'ļ'=>'l', 'ĺ'=>'l', 'Ĺ'=>'l', 'Ļ'=>'l', 'л'=>'l', 'Ľ'=>'l', 'ľ'=>'l', 'ל'=>'l',
            'מ'=>'m', 'М'=>'m', 'ם'=>'m', 'м'=>'m',
            'ñ'=>'n', 'н'=>'n', 'Ņ'=>'n', 'ן'=>'n', 'ŋ'=>'n', 'נ'=>'n', 'Н'=>'n', 'ń'=>'n', 'Ŋ'=>'n', 'ņ'=>'n', 'ŉ'=>'n', 'Ň'=>'n', 'ň'=>'n',
            'о'=>'o', 'О'=>'o', 'ő'=>'o', 'õ'=>'o', 'ô'=>'o', 'Ő'=>'o', 'ŏ'=>'o', 'Ŏ'=>'o', 'Ō'=>'o', 'ō'=>'o', 'ø'=>'o', 'ǿ'=>'o', 'ǒ'=>'o', 'ò'=>'o', 'Ǿ'=>'o', 'Ǒ'=>'o', 'ơ'=>'o', 'ó'=>'o', 'Ơ'=>'o', 'œ'=>'oe', 'Œ'=>'oe', 'ö'=>'oe',
            'פ'=>'p', 'ף'=>'p', 'п'=>'p', 'П'=>'p',
            'ק'=>'q',
            'ŕ'=>'r', 'ř'=>'r', 'Ř'=>'r', 'ŗ'=>'r', 'Ŗ'=>'r', 'ר'=>'r', 'Ŕ'=>'r', 'Р'=>'r', 'р'=>'r',
            'ș'=>'s', 'с'=>'s', 'Ŝ'=>'s', 'š'=>'s', 'ś'=>'s', 'ס'=>'s', 'ş'=>'s', 'С'=>'s', 'ŝ'=>'s', 'Щ'=>'sch', 'щ'=>'sch', 'ш'=>'sh', 'Ш'=>'sh', 'ß'=>'ss',
            'т'=>'t', 'ט'=>'t', 'ŧ'=>'t', 'ת'=>'t', 'ť'=>'t', 'ţ'=>'t', 'Ţ'=>'t', 'Т'=>'t', 'ț'=>'t', 'Ŧ'=>'t', 'Ť'=>'t', '™'=>'tm',
            'ū'=>'u', 'у'=>'u', 'Ũ'=>'u', 'ũ'=>'u', 'Ư'=>'u', 'ư'=>'u', 'Ū'=>'u', 'Ǔ'=>'u', 'ų'=>'u', 'Ų'=>'u', 'ŭ'=>'u', 'Ŭ'=>'u', 'Ů'=>'u', 'ů'=>'u', 'ű'=>'u', 'Ű'=>'u', 'Ǖ'=>'u', 'ǔ'=>'u', 'Ǜ'=>'u', 'ù'=>'u', 'ú'=>'u', 'û'=>'u', 'У'=>'u', 'ǚ'=>'u', 'ǜ'=>'u', 'Ǚ'=>'u', 'Ǘ'=>'u', 'ǖ'=>'u', 'ǘ'=>'u', 'ü'=>'ue',
            'в'=>'v', 'ו'=>'v', 'В'=>'v',
            'ש'=>'w', 'ŵ'=>'w', 'Ŵ'=>'w',
            'ы'=>'y', 'ŷ'=>'y', 'ý'=>'y', 'ÿ'=>'y', 'Ÿ'=>'y', 'Ŷ'=>'y',
            'Ы'=>'y', 'ž'=>'z', 'З'=>'z', 'з'=>'z', 'ź'=>'z', 'ז'=>'z', 'ż'=>'z', 'ſ'=>'z', 'Ж'=>'zh', 'ж'=>'zh'
        ];
        return strtr($cadena, $replace);
    }
    

    public static function AllHours() {
        return [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24];
    }

    public static function AllDay() {
        return [
            'h0' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h1' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h2' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h3' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h4' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h5' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h6' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h7' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h8' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h9' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h10' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h11' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h12' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h13' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h14' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h15' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h16' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h17' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h18' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h19' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h20' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h21' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h22' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h23' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55],
            'h24' => [0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55]
        ];
    }
    
    public static function diferenciaHoras($fecha){
        $now = date('Y-m-d H:i:s');
        $fechaActual = date_create($now);
        $fechaCita = date_create($fecha);
        $intervalo = date_diff($fechaCita, $fechaActual);
        $horas = (($intervalo->format('%d') * 24)*60) + ($intervalo->format('%H')*60) + $intervalo->format('%i');
        return $horas;
    }
    
    /**
     * Obeter diferencia entre dos fechas dadas
     * @param string $fechaInicio 
     * @param string $fechaFin
     * @return date_diff object 
     */
    public static function diferenciaFechas($fechaInicio, $fechaFin){
        $fechaStart = date_create($fechaInicio);
        $fechaEnd = date_create($fechaFin);
        $diff = date_diff($fechaStart, $fechaEnd);
        return $diff;
    }
    
    
    public static function obtenerProcedimientosClinica($tipoUsuario,$idClinica,$idSuscripcion){
        $qProcedimientos = Procedimiento::find()->alias('p')->where(['id_suscripcion' => $idSuscripcion]);
        if($tipoUsuario == Usuario::ASISTENTE){
            $qProcedimientos->innerJoin('clinica_procedimiento as cp','cp.id_procedimiento = p.id')
            ->andWhere(['cp.id_clinica' => $idClinica]);
        }
        return $qProcedimientos->all();
    }
    
    
    public static function obtenerProcedimientosGrupo(){
        $idUsuario = UsuarioSuscripcion::find()->where(['id_clinica' => SesionUtils::ClinicaSeleccionada()->id])->select('id_usuario')->column();
        $idGrupos = GrupoTrabajoUsuario::find()->where(['id_usuario' => $idUsuario])->select('id_grupo')->column();
        $idProcedimientos = GrupoProcedimiento::find()->where(['id_grupo' => $idGrupos])->select('id_procedimiento')->column();
        return Procedimiento::find()->where(['id' => $idProcedimientos])->all();
    }
    
    
    public static function httpsUrlConf($url){
        if( !preg_match('~^(?:f|ht)tps?://~i', $url) ){
            $url = 'https://' . $url;
        }
        return $url;
    }
    
    /**
     * Obtener un color por un hash string
     * @param string $num
     * @param bool $lighten opcional por defecto true para aclarar el colot
     * @param bool $toHex opcional por defecto false para convertir a hexadecimal
     * @return array color
     */
    public static function getColor($num, $lighten=true, $toHex=false) {
        $hash = md5('color' . $num); // modify 'color' to get a different palette
        $g = hexdec( substr($hash, 2, 2) );
        $r = hexdec( substr($hash, 0, 2) );
        $b = hexdec( substr($hash, 4, 2) );
        return $lighten ? self::setLigthColor($r, $g, $b, $p = 70) : ($toHex ? sprintf("#%02x%02x%02x", $r,$g,$b) : [ $r, $g, $b]);
    }
    
    /**
     * Aclarar un color dado en partes rgb
     * @param int $r
     * @param int $g
     * @param int $b
     * @param int $p opcional por defecto 50
     * @return array nuevo color
     */
    public static function setLigthColor(int $r, int $g, int $b, int $p = 50){
        $curr_total_dark = ( 255 * 3) - ( $r + $g + $b );
        $rr = ( (255 - $r) / $curr_total_dark );
        $gr = ( (255 - $g) / $curr_total_dark );
        $br = ( (255 - $b) / $curr_total_dark );
        $new_total_dark = ((255 - 255 * ($p / 100)) * 3);
        
        $nr = \strval( 255 - \round($rr * $new_total_dark) );
        $ng = \strval( 255 - \round($gr * $new_total_dark) );
        $nb = \strval( 255 - \round($br * $new_total_dark) );
        
        $ro = \strlen( $nr ) == 1 ? '0'.$nr  : $nr ;
        $rg = \strlen( $ng ) == 1 ? '0'.$ng  : $ng ;
        $rb = \strlen( $nb ) == 1 ? '0'.$nb  : $nb ;
        return [ $ro, $rg, $rb ];
    }
    
    /**
     * Retorna una lista html de los errores
     * @param array $errors
     * @return string
     */
    public static function GetHtmlModelsErrors($errors){
        $errorString = "<ul><li>";
        foreach ($errors as $key => $error){
            $errorsText = implode("</li><li>", $error);
            $errorString .= $errorsText;
        }
        
        return $errorString . '</li><ul>';
    }
    
    /**
     * Retorna un string de los errores.
     * @param array $errors
     * @return string
     */
    public static function GetStringModelsErrors($errors){
        $errorString = "";
        foreach ($errors as $key => $error){
            $errorsText = implode(", ", $error);
            $errorString .=" * " . $errorsText . "\n";
        }
        
        return $errorString;
    }


    public static function guardarProcedimientos($isNewRecord,$idCita,$procedimientos,$costoProc, $costoCita){
        $i = 0;
        if(!$isNewRecord){
            ProcedimientoCita::deleteAll(['id_cita' => $idCita]);
        }
        $totalReal = \array_sum($costoProc);
        $totalProcs = \count($procedimientos); 
        for($i=0; $i < $totalProcs; $i++ ){
            $procedimientoCita = new ProcedimientoCita();
            $procedimientoCita->id_cita = $idCita;
            $procedimientoCita->id_procedimiento = $procedimientos[$i];
            $procedimientoCita->orden = $i;
            $procedimientoCita->costo_editado = $totalReal == 0 ? 0 : ($costoProc[$i]*$costoCita)/$totalReal;
            $procedimientoCita->save();
        }
    }
    

}
