<?php


namespace app\customs;

use Yii;
use app\models\Configuracion;
use app\models\ConfiguracionSuscripcion;
use app\customs\Utils;
use app\customs\StripeUtils;
use app\models\Usuario;
use app\models\HorarioMedico;
use app\models\UsuarioSuscripcion;
use app\models\GrupoTrabajo;
use app\models\GrupoTrabajoUsuario;
use app\models\Suscripcion;
/**
 * Description of SesionUtils
 *
 * @author jose.nieves
 */
class SesionUtils {
     /**
    * Obtener configuracion por llave, id suscripcion y/o  id clinica
    * @param string $llave
    * @param int $idSuscripcion
    * @param int $idClinica
    * @return Configuracion
    */
    public static function getValorLlave($llave, $idSuscripcion,$idClinica = null){
        $model = null;
        if($idClinica != null){
            $model = ConfiguracionSuscripcion::find()->where(['llave' => $llave])
                    ->andWhere(['id_suscripcion' => $idSuscripcion,'id_clinica' => $idClinica])->one();   
        }
        if($model == null){
            $model = ConfiguracionSuscripcion::find()->where(['llave' => $llave])
                    ->andWhere(['id_suscripcion' => $idSuscripcion])
                    ->andWhere(['is','id_clinica',null])->one();
            if ($model == null) {
                $model = Configuracion::find()->where(['llave' => $llave])->one();
            }
        }
        return $model;
    }
    
    /**
     * 
     * Obtener configuracion por llave.
     * @param $llave
     * @return $model  
     */
    public static function getLlaveValor($llave){
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $idSuscripcion = $suscripcion->id;
        $idClinica = null;
        if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA){
            $idClinica = SesionUtils::ClinicaSeleccionada()->id;
        }
        $model = SesionUtils::getValorLlave($llave, $idSuscripcion,$idClinica);
        return $model;
    }
    
    /**
     * Devuelve las clinicas disponibles para el usuario
     * @return app\models\Clinica[]
     */
    public static function ClinicasUsuario(){
        $clinicas = Yii::$app->session->get("usuarios_clinica");
        if($clinicas == null){
            $usuario = Yii::$app->user->identity;
            
            //Para el caso particular de Asistente de Jerarquia, ella no está asignada a clinicas.
            $sinClinica = $usuario->getUsuarioSuscripciones()->where(['activo' => 1])
                    ->andWhere(['is','id_clinica', null])
                    ->count();
            //ASISTENTE DE JERARQUIAS
            if($sinClinica > 0){
                $idGrupos = $usuario->getGruposTrabajoUsuario()->select('id_grupo')->column();
                $idUsuarios = GrupoTrabajoUsuario::find()->where(['id_grupo' => $idGrupos])->select('id_usuario')->column();
                $usuariosSuscripciones = UsuarioSuscripcion::find()->where(['id_usuario' => $idUsuarios,'activo' => 1])->all();
            }
            else{
                $suscripcion = $usuario->suscripcion;
                $usuariosSuscripciones = [];
                if($suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL){
                    $usuariosSuscripciones = $usuario->getUsuarioSuscripciones()->where(['activo' => 1])->all();
                }
                else{
                    $tipoUsuarioJerarquia = $usuario->tipoUsuarioJerarquia;
                    if($tipoUsuarioJerarquia == UsuarioSuscripcion::TIPO_ADMINISTRADOR){
                        $usuariosSuscripciones = UsuarioSuscripcion::find()
                                ->where(['id_suscripcion' => $suscripcion->id, 'activo' => 1])
                                ->all();
                    }
                    else if($tipoUsuarioJerarquia == UsuarioSuscripcion::TIPO_COORDINADOR){
                        $gruposPermitidos = $usuario->getGruposTrabajoUsuario()->select('id_grupo')->column();
                        $usuariosGrupo = GrupoTrabajoUsuario::find()
                                ->where(['id_grupo' => $gruposPermitidos])
                                ->select('id_usuario')->column();
                        $usuariosSuscripciones = UsuarioSuscripcion::find()
                                ->where(['id_suscripcion' => $suscripcion->id,'id_usuario' => $usuariosGrupo,'activo' => 1])->all();
                    }
                    else{
                        $usuariosSuscripciones = UsuarioSuscripcion::find()
                                ->where(['id_suscripcion' => $suscripcion->id,'id_usuario' => $usuario->id])
                                ->all();
                    }
                }
            }
            $clinicas = [];
            foreach($usuariosSuscripciones as $usuarioSuscripcion){
                $clinicas[] = $usuarioSuscripcion->clinica;
            }
            Yii::$app->session->set("usuarios_clinica",$clinicas);
            if(count($clinicas) > 0){
                Yii::$app->session->set("clinica_seleccionada",$clinicas[0]);
            }
        }
        return $clinicas;
    }
    
    
    public static function ClinicasAgrupadasJerarquia(){
        
        $clinicas = Yii::$app->session->get("usuarios_clinica_jerarquia");
        if($clinicas == null){
            $clinicas = [];
            $usuario = Yii::$app->user->identity;
            $suscripcion = $usuario->suscripcion;
            $usuariosSuscripciones = [];
            $tipoUsuarioJerarquia = $usuario->tipoUsuarioJerarquia;
            if($tipoUsuarioJerarquia == UsuarioSuscripcion::TIPO_ADMINISTRADOR){
                $grupos = GrupoTrabajo::find()->where(['id_suscripcion' => $suscripcion->id])->orderBy('nombre')->all();
                foreach ($grupos as $grupo){
                    $clinicasGrupo = $grupo->getGrupoClinicas();
                    if(count($clinicasGrupo)> 0){
                        $clinicas[] = ['Nombre' => $grupo->nombre, 'Clinicas' => $clinicasGrupo];
                    }
                }
            }
            else if($tipoUsuarioJerarquia == UsuarioSuscripcion::TIPO_COORDINADOR || $tipoUsuarioJerarquia == UsuarioSuscripcion::TIPO_ASISTENTE){
                $gruposPermitidos = $usuario->gruposTrabajoUsuario;
                foreach ($gruposPermitidos as $usuarioGrupo){
                    $clinicasGrupo = $usuarioGrupo->grupo->getGrupoClinicas();
                    if(count($clinicasGrupo) > 0){
                        $clinicas[] = ['Nombre' => $usuarioGrupo->grupo->nombre, 'Clinicas' => $clinicasGrupo];
                    }
                }
            }
            else{
                $grupo = GrupoTrabajoUsuario::findOne(['id_usuario' => $usuario->id]);
                $usuariosSuscripciones = UsuarioSuscripcion::find()
                        ->where(['id_suscripcion' => $suscripcion->id,'id_usuario' => $usuario->id,'activo' => 1])
                        ->one();
                $cc = $usuariosSuscripciones->clinica;
                $clinicas[] = ['Nombre' => $grupo->grupo->nombre, 'Clinicas' => [$cc]];
            }
            
            Yii::$app->session->set("usuarios_clinica_jerarquia",$clinicas);
            if(count($clinicas) > 0){
                Yii::$app->session->set("clinica_seleccionada",$clinicas[0]['Clinicas'][0]);
            }
        }
        return $clinicas;
    }
    
    /**
     * Devuelve la clinica seleccionada por el usuario
     * @return \app\models\Clinica
     */
    public static function ClinicaSeleccionada(){
        $clinica = Yii::$app->session->get("clinica_seleccionada");
        if($clinica == null){
            SesionUtils::ClinicasUsuario();
        }
        return Yii::$app->session->get("clinica_seleccionada");
    }
    
    /**
     * Guarda en sesión la clinica deseada.
     * @param app\models\Clinica $clinica
     */
    public static function SeleccionarClinica($clinica){
        Yii::$app->session->set("clinica_seleccionada",$clinica);
    }
    
    public static function LogOut(){
        Yii::$app->session->set("clinica_seleccionada",null);
        Yii::$app->session->set("usuarios_clinica",null);
        Yii::$app->session->set("usuarios_clinica_jerarquia",null);
    }
 
   /**
    * Obtener configuracion por llave, id suscripcion y/o  id clinica
    * @param string $llave
    * @param int $idSuscripcion
    * @param int $idClinica
    * @return Configuracion
    */
    public static function configuracionSuscripcion($llave, $idSuscripcion,$idClinica = null){
        $model = null;
        if($idClinica != null){
            $model = ConfiguracionSuscripcion::find()->where(['llave' => $llave])
                    ->andWhere(['id_suscripcion' => $idSuscripcion,'id_clinica' => $idClinica])->one();   
        }
        if($model == null){
            $model = ConfiguracionSuscripcion::find()->where(['llave' => $llave])
                    ->andWhere(['id_suscripcion' => $idSuscripcion])
                    ->andWhere(['is','id_clinica',null])->one();
            if ($model == null) {
                $model = Configuracion::find()->where(['llave' => $llave])->one();
            }
        }
        return $model;
    }
    
    
    /**
     * 
     * Obtener configuracion por llave.
     * @param $llave
     * @return $model  
     */
    public static function configuracionSesion($llave){
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $idSuscripcion = $suscripcion->id;
        $idClinica = null;
        if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA){
            $idClinica = SesionUtils::ClinicaSeleccionada()->id;
        }
        $model = SesionUtils::configuracionSuscripcion($llave, $idSuscripcion,$idClinica);
        return $model;
    }
    
    public static function EstadoSuscripcionStripe(){
        $estado = Yii::$app->session->get("estado_suscripcion");
        if($estado == null){
            $estado = StripeUtils::StatusSuscripcion();
            Yii::$app->session->set("estado_suscripcion",$estado);
        }
        return $estado;
    }
    
    /**
     * 
     * @param int $id_suscripcion 
     * @param boolean $eliminarTildes
     * @param boolean $isIndex 
     * @return string $articulo
     */
    public static function armarArticulo($id_suscripcion, $eliminarTildes = false, $isIndex = false){
        $prefijo = SesionUtils::configuracionSuscripcion('identificativo_profesion', $id_suscripcion)->valor;
        $nombrePl = SesionUtils::configuracionSuscripcion('nombre_publico', $id_suscripcion)->valor;
        $nombrePublico = $eliminarTildes ? Utils::eliminarTildes($nombrePl): $nombrePl;
        $articulo = '';
        switch ($prefijo){
            case 'dr': 
                $articulo = $isIndex ? 'El Dr '.$nombrePublico : 'el Dr ' .$nombrePublico;
                break;
            case 'dra':
                $articulo = $isIndex ? 'La Dra '.$nombrePublico : 'la Dra ' .$nombrePublico;
                break;
            case 'lic': 
                $articulo = $isIndex ? 'El Lic '.$nombrePublico : 'el Lic ' .$nombrePublico;
                break;
            case 'lcda':
                $articulo = $isIndex ? 'La Lcda '.$nombrePublico : 'la Lcda ' .$nombrePublico;
                break;
            case 'psic': 
                $articulo = $isIndex ? 'Tu Psic '.$nombrePublico : 'tu Psic ' .$nombrePublico;
                break;
            case 'nut':
                $articulo = $isIndex ? 'Tu Nut '.$nombrePublico : 'tu Nut ' .$nombrePublico;
                break;
            case 'lab':
                $articulo = $isIndex ? 'El Lab '.$nombrePublico : 'el Lab ' .$nombrePublico;
                break;
            case 'clinica':
                $articulo = $isIndex ? 'Clínica '.$nombrePublico : 'Clinica '.$nombrePublico;
                break;
            case 'ninguno':
                $articulo = $nombrePublico;
                break;
        }
        return $articulo;
    }
       
    public static function profesionNombre($prefijo){
        $prefijo = SesionUtils::configuracionSesion('identificativo_profesion')->valor;
        switch ($prefijo){
            case 'dr': 
                $profesion = 'Doctor';
                break;
            case 'dra':
                $profesion = 'Doctora';
                break;
            case 'lic': 
                $profesion = 'Licenciado';
                break;
            case 'lcda':
                $profesion = 'Licenciada';
                break;
            case 'psic': 
                $profesion = 'Psicologo';
                break;
            case 'nut':
                $profesion = 'Nutriologo';
                break;
            case 'lab':
                $profesion = 'Laboratorio';
                break;
            case 'clinica':
                $profesion = 'Clínica';
                break;
            case 'ninguno':
                $profesion = 'No definido';
                break;
        }
        return $profesion;
    }
    
    
    public static function RevisarStripe(){
        $activo = Yii::$app->session->get("stripe_activo");
        if($activo == null){
            $usuario = \Yii::$app->user->identity;
            $suscripcion = $usuario->suscripcion;
            $conf = Configuracion::findOne(['llave' => 'stripe_activo']);
            $activo = boolval($conf->valor) ? $suscripcion->stripe_activo : false;
            Yii::$app->session->set("stripe_activo",$activo);
        }
        return boolval($activo);
    }
    
    /**
     * Buscar una hora de inicio en el horario de la clínica a partir de la fecha actual sumando 15 dias
     * si no encuentra un horario vuelve a buscar sumando un día a la fecha. 
     * Esto en caso de que la fecha coincida con un fin de semana debe de buscar hasta encontrar un día de trabajo habilitado.
     * @param app\models\Usuario $usuario
     * @return string
     */
    public static function getHoraEntradaClinica($usuario){
        $now = date('Y-m-d');
        $HI = null;
        $days = ['Sunday'=>1,'Monday'=>2,'Tuesday'=>3,'Wednesday'=>4,'Thursday'=>5,'Friday'=>6,'Saturday'=>7];
        $where = $usuario->tipo == Usuario::ASISTENTE ? ['id_clinica'=>SesionUtils::ClinicaSeleccionada()->id] 
                    : ['id_suscripcion'=>$usuario->suscripcion->id];
        $dateAdd = date('Y-m-d', strtotime($now.'+15 days'));
        $run = true;
        $i = 0;
        while($run){
            $fecha_respaldo = date('Y-m-d', strtotime($dateAdd.'+'.$i.' days'));
            $fecha_f = date('Y-m-d-l', strtotime($fecha_respaldo));
            $d = (string) explode('-',$fecha_f)[3];
            $horario = HorarioMedico::find()->where($where)->andWhere(['dia'=>$days[$d]])->one();
            if($horario != null){
                $run = false;
                $HI = $horario->hora_inicio; 
            }
            $i = $i + 1; 
        }
        return $HI;
    }
    
    /**
     * Devuelve los grupos de trabajo de la clinica seleccionada, esto solo aplica para jerarquias
     * @return GrupoTrabajo[]
     */
    public static function gruposClinicaSeleccionada(){
        $usuarioSuscripcion = UsuarioSuscripcion::findOne(['id_clinica' => self::ClinicaSeleccionada()->id]);
        $gruposUsuario = GrupoTrabajoUsuario::find()->where(['id_usuario' => $usuarioSuscripcion->id_usuario])->select('id_grupo')->column();
        $grupos = GrupoTrabajo::find()->where(['id' => $gruposUsuario])->all();
        return $grupos;
    }
    
}
