<?php

namespace app\customs;

use Yii;
use yii\web\Controller;
use app\models\repositories\SecurityFunctions;
use app\customs\StripeUtils;

class BaseController extends Controller{
    public $bodyClass;
    
    public function excludeFromSession(){
        return [];
    }
    public function excludeFromSecurity(){
        return [];
    }
    
    public function checkForSubscription(){
        return [];
    }
    
    public function beforeAction($action) {
        if (parent::beforeAction($action)) {
            if ($this->enableCsrfValidation && Yii::$app->getErrorHandler()->exception === null && !Yii::$app->getRequest()->validateCsrfToken()) {
                throw new BadRequestHttpException(Yii::t('yii', 'Unable to verify your data submission.'));
            }
        
            if(in_array($action->id, $this->excludeFromSession()) || $action->controller->id == "default"){
                return true;
            }else{
                if(Yii::$app->user->getIsGuest()){
                    Yii::$app->user->setReturnUrl([$action->controller->id.'/'.$action->id]);
                    $this->redirect(['site/login']);
                    return false;
                }else{
                    if(in_array($action->id, $this->excludeFromSecurity())){
                        return true;
                    }
                    $s=new SecurityFunctions();
                    $p=$s->AccesoPermitido($action);
                    if(!$p){
                        $this->redirect(['site/desautorizado']);
                        return false;
                    }
                    
                    
                    if(in_array($action->id, $this->checkForSubscription())){
                        $revisarStripe = SesionUtils::RevisarStripe();
                        if($revisarStripe){
                            $estadoSuscripcion = SesionUtils::EstadoSuscripcionStripe();
                            if($estadoSuscripcion != StripeUtils::ESTADO_ACTIVA && $estadoSuscripcion != StripeUtils::ESTADO_PRUEBA){
                                $this->redirect(['forma-pago/index']);
                                return false;
                            }
                        }
                    }
                    return true;
                }
            }
        }else {
            return false;
        }
    }
    
}