<?php

namespace app\controllers;

use Yii;
use app\models\Paciente;
use app\models\Pagadito;
use yii\data\ActiveDataProvider;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\TipoEncargado;
use yii\helpers\ArrayHelper;
use app\customs\SesionUtils;
use yii\web\Response;
use yii\helpers\Html;
use app\models\PlantillaHistorial;
use app\models\Usuario;
use app\models\Clinica;
use app\models\Suscripcion;
use app\models\UsuarioSuscripcion;
use app\models\repositories\PacienteRepository;
use app\models\DocumentoPaciente;
use yii\web\UploadedFile;

/**
 * PacienteController implements the CRUD actions for Paciente model.
 */
class PacienteController extends BaseController
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Paciente models.
     * @return mixed
     */
    public function actionIndex()
    {
        $usuario = Yii::$app->user->identity;
        $suscripcion =$usuario->suscripcion;
        $id_suscripcion = $suscripcion->id;
        
        $pacienteQuery = $suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL 
                ? Paciente::find()->where(['id_suscripcion' => $id_suscripcion])
                : Paciente::find()->where(['id_suscripcion' => $id_suscripcion,'id_clinica' => SesionUtils::ClinicaSeleccionada()->id]);
        $dataProvider = new ActiveDataProvider([
            'query' => $pacienteQuery
        ]);

        return $this->render('index', [
            'dataProvider' => $dataProvider,
        ]);
    }
    
    public function actionPacientes(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $id_suscripcion = $suscripcion->id;
        $requestData = $_REQUEST;
        $db = Paciente::getDb();
        $columns = [
            0 => 'codigo',
            1 => 'nombre',
            2 => 'apellido',
            3 => 'email',
            4 => 'telefono_fijo',
            5 => 'celular'
        ];
        $sql = "SELECT * FROM paciente WHERE id_suscripcion = {$id_suscripcion}";
        if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA){
            $sql .= " AND id_clinica = " . SesionUtils::ClinicaSeleccionada()->id;
            if($usuario->tipoUsuarioJerarquia == UsuarioSuscripcion::TIPO_DEPENDIENTE){
                $sql .= " AND estado <> 5";
            }
        }
        $data = $db->createCommand($sql)->queryAll();
        $totalData = count($data);
        $totalFiltered = $totalData;
        if(!empty($requestData['search']['value'])){
            $sql.= " AND ( nombre LIKE '{$requestData['search']['value']}%' ";
            $sql.= " OR nombre LIKE '%{$requestData['search']['value']}%' ";
            $sql.= " OR apellido LIKE '{$requestData['search']['value']}%' ";
            $sql.= " OR email LIKE '{$requestData['search']['value']}%' ";
            $sql.= " OR email LIKE '%{$requestData['search']['value']}%' ";
            $sql.= " OR telefono_fijo LIKE '{$requestData['search']['value']}%' ";
            $sql.= " OR telefono_fijo LIKE '%{$requestData['search']['value']}%' ";
            $sql.= " OR celular LIKE '{$requestData['search']['value']}%' ";
            $sql.= " OR celular LIKE '%{$requestData['search']['value']}%' ";
            $sql.= " OR codigo LIKE '{$requestData['search']['value']}%' ";
            $sql.= " OR codigo LIKE '%{$requestData['search']['value']}%' ) ";
        }
        $data = $db->createCommand($sql)->queryAll();
        $totalFiltered = count($data);
        $sql.=" ORDER BY " . $columns[$requestData['order'][0]['column']] . "   " . $requestData['order'][0]['dir'] . "  LIMIT " . $requestData['start'] . " ," . 
        $requestData['length'] . "   ";
        $result = $db->createCommand($sql)->queryAll();
        $data = [];
        foreach($result as $key => $row){
            $acciones = Html::a('<span class="kt-font-primary flaticon-eye" style="padding: 2px;"></span>',['view', 'id' => $row['id']])
                        .Html::a('<span class="kt-font-warning flaticon-edit" style="padding: 2px;"></span>',['update', 'id' => $row['id']]);
            if($usuario->tipo == \app\models\Usuario::DOCTOR && Paciente::countDatosPaciente($row['id']) ){
                $acciones .= Html::a('<span class="kt-font-danger flaticon2-trash"></span>',
                                    ['delete', 'id' => $row['id']],
                                    ['data-method' => 'post','data-confirm'=>'¿Está seguro de eliminar este elemento?']);
            }
            $nestedData = [];
            $nestedData[] = $row['id'];
            $nestedData[] = $row['codigo'] != null ? $row['codigo'] : 'No definido';
            $nestedData[] = $row['nombre'];            
            $nestedData[] = $row['apellido'];
            $nestedData[] = $row['email'];
            $nestedData[] = $row['telefono_fijo'] != null ? $row['telefono_fijo'] : 'No definido';
            $nestedData[] = $row['celular'] != null ? $row['celular'] : 'No definido';
            $nestedData[] = $acciones;
            $data[] = $nestedData;
        }
        $json_data = [
            "draw" => intval($requestData['draw']), 
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data,   // pacientes,
            "query" => $sql
        ];
        return $json_data;
    }

    /**
     * Displays a single Paciente model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id, $idC = null)
    {
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $model = $this->findModel($id);
        $documentoModel = new DocumentoPaciente();
        if( Yii::$app->request->isAjax){
            Yii::$app->response->format = Response::FORMAT_JSON;
            $get = Yii::$app->request->get();
            $fecha = \DateTime::createFromFormat('d/m/Y', $get['fecha'])->format('Y-m-d');
            $documentos = UploadedFile::getInstances($documentoModel, 'documento');
            if(!is_null($documentos)){
                DocumentoPaciente::subirDocumentos($documentos, $id, $fecha);
                return ['Correcto'=> true];
            }
            return ['Correcto'=> false ];
        }
        $tipoUsuarioJerarquia = -1;
        if($model->id_suscripcion != $usuario->suscripcion->id || 
            ($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA && $usuario->tipoUsuarioJerarquia == UsuarioSuscripcion::TIPO_DEPENDIENTE && $model->id_clinica != SesionUtils::ClinicaSeleccionada()->id ) ){
            //return $this->redirect(["site/forbidden"], 403);
            return $this->redirect(['paciente/index']);
        }
        if ($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA){
            $tipoUsuarioJerarquia = $usuario->tipoUsuarioJerarquia;
            if($usuario->tipoUsuarioJerarquia  == UsuarioSuscripcion::TIPO_DEPENDIENTE 
                    && $model->estado == Paciente::ESTADO_ARCHIVADO){
                return $this->redirect(['paciente/index']);
            }
        }
        return $this->render('_view', [
            'model' => $model,
            'documento' => $documentoModel,
            'plantillasDiagnostico' => PlantillaHistorial::find()->where(['id_suscripcion' => $usuario->suscripcion->id])->all(),
            'tipo_usuario'=> $usuario->tipo,
            'tipo_suscripcion'=> $suscripcion->tipo,
            'clinicas' => $usuario->tipo == Usuario::DOCTOR ? Clinica::find()->where(['id_suscripcion' => $usuario->suscripcion->id])->all() : [],
            'clinica_seleccionada' => $usuario->tipo == Usuario::ASISTENTE ? SesionUtils::ClinicaSeleccionada()->id : '',
            'confInfoRecetas' => SesionUtils::getLlaveValor('informacion_recetas_medicas')->valor,
            'id_cita' => $idC,
            'tipoUsuarioJerarquia' => $tipoUsuarioJerarquia,
            'pagadito'=> Pagadito::find()->where(['id_suscripcion'=>$suscripcion->id])->one(),
            'medioPagoCita' => SesionUtils::getLlaveValor('conf_medio_pago')->valor
        ]);
    }

    /**
     * Creates a new Paciente model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $llaveCorreo = SesionUtils::getLlaveValor('comunicacion_paciente');
        $valores = $llaveCorreo->valor;
        $vals = explode("|", $valores);
        $this->bodyClass = "paciente-form";
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $id_suscripcion = $suscripcion->id;
        $model = new Paciente();
        $model->scenario = Paciente::SCENARIO_OLIVIA_REGISTER;
        $model->id_suscripcion = $id_suscripcion;
        $model->fecha_creacion = date('Y-m-d H:i:s');
        $post = Yii::$app->request->post();
        
        $grupos = $suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL 
                            ? []
                            : SesionUtils::gruposClinicaSeleccionada();
        
        if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA){
            $model->id_clinica = SesionUtils::ClinicaSeleccionada()->id;
            $model->estado = Paciente::ESTADO_EN_ESPERA;
            $model->id_grupo = count($grupos) > 0 ? $grupos[0]->id : null;
        }
        
        if ( $model->load($post) ) {
            if( $model->save() ){
                PacienteRepository::GuardarBitacoraPaciente($model->id, $model->estado, $suscripcion,$model->id_clinica,$model->id_grupo);
                $this->setMensaje($model, $vals, 'creado');
                return $this->redirect(['view', 'id' => $model->id]);
            } 
        }
        $aseguradoras = Paciente::find()->select('aseguradora')
                ->where(['id_suscripcion' => $id_suscripcion])
                ->andFilterWhere(['not',['aseguradora' => null]])
                ->orderBy(['aseguradora' => SORT_ASC])
                ->distinct()->all();
        $tipos = ArrayHelper::map(TipoEncargado::find()->all(), "id", 'nombre');
        
        $procedencias = $this->procedenciasDisponibles($suscripcion);
        
        return $this->render('create', [
            'model' => $model,
            'tipos' => $tipos,
            'valores' => $valores,
            'grupos' => ArrayHelper::map($grupos,'id','nombre'),
            'aseguradoras' => ArrayHelper::map($aseguradoras, 'aseguradora', 'aseguradora'),
            'procedencias' => ArrayHelper::map($procedencias,'procedencia','procedencia')
        ]);
    }
    
    

    /**
     * Updates an existing Paciente model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $llaveCorreo = SesionUtils::getLlaveValor('comunicacion_paciente');
        $valores = $llaveCorreo->valor;
        $vals = explode("|", $valores);
        $this->bodyClass = 'paciente-form';
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $id_suscripcion = $suscripcion->id;
        $model = $this->findModel($id);
        $model->scenario = Paciente::SCENARIO_OLIVIA_REGISTER;
        $post = Yii::$app->request->post();
        if($model->id_suscripcion != $id_suscripcion){
            //return $this->redirect(["site/forbidden"], 403);
            return $this->redirect(['paciente/index']);
        }
        if ( $model->load( $post ) ) {
            $model->id_suscripcion = $id_suscripcion;
            if( $model->save() ){
                $this->setMensaje($model, $vals, 'actualizado');
                return $this->redirect(['view', 'id' => $model->id]);
            }
        }
        $aseguradoras = Paciente::find()->select('aseguradora')
                ->where(['id_suscripcion' => $id_suscripcion])
                ->andFilterWhere(['not',['aseguradora' => null]])
                ->orderBy(['aseguradora' => SORT_ASC])
                ->distinct()->all();
        $grupos = $suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL 
                            ? []
                            : SesionUtils::gruposClinicaSeleccionada();
        
        $tipos = ArrayHelper::map(TipoEncargado::find()->all(), "id", 'nombre');        
        $procedencias = $this->procedenciasDisponibles($suscripcion);
        
        return $this->render('update', [
            'model' => $model,
            'tipos' => $tipos,
            'valores'=> $valores,
            'grupos' => ArrayHelper::map($grupos,'id','nombre'),
            'aseguradoras' => ArrayHelper::map($aseguradoras, 'aseguradora', 'aseguradora'),
            'procedencias' => ArrayHelper::map($procedencias,'procedencia','procedencia'),
            'clinicas' => $this->clinicasDisponibles($model, $usuario, $suscripcion)
        ]);
    }
    
    /**
     * Devuelve las procedencias de los pacientes, aplica solo para jerarquias
     * @param Suscripcion $suscripcion
     * @return string[]
     */
    private function procedenciasDisponibles($suscripcion){
        $procedencias = $suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL 
                ? []
                : Paciente::find()->select('procedencia')
                    ->where(['id_suscripcion' => $suscripcion->id])
                    ->andWhere(['is not', 'procedencia', null])
                    ->orderBy(['procedencia' => SORT_ASC])
                    ->distinct()->all();
        return $procedencias;
    }
    
    /**
     * Devuelve un arreglo [id=>nombre] de las clinicas disponibles para administrador
     * y coordinador.
     * @param Usuario $usuario
     * @param Suscripcion $suscripcion
     * @param Paciente $paciente
     * @return []
     */
    private function clinicasDisponibles($model,$usuario, $suscripcion){
        $clinicas = [];
        if(!$model->isNewRecord
                    && $suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA 
                    && ($usuario->tipoUsuarioJerarquia == UsuarioSuscripcion::TIPO_ADMINISTRADOR
                        || $usuario->tipoUsuarioJerarquia == UsuarioSuscripcion::TIPO_COORDINADOR)){
            
        
            if($usuario->tipoUsuarioJerarquia == UsuarioSuscripcion::TIPO_ADMINISTRADOR){
                $clinicas = Clinica::find()->where(['id_suscripcion' => $suscripcion->id])->all();
            }
            if($usuario->tipoUsuarioJerarquia == UsuarioSuscripcion::TIPO_COORDINADOR){
                $gruposPermitidos = $usuario->gruposTrabajoUsuario;
                foreach ($gruposPermitidos as $usuarioGrupo){
                    $clinicasGrupo = $usuarioGrupo->grupo->getGrupoClinicas();
                    foreach($clinicasGrupo as $clinica){
                        $clinicas[] = $clinica;
                    }
                }
            }
        }
        return ArrayHelper::map($clinicas, 'id', 'nombre');
    }
    
    private function setMensaje($model, $vals, $accion){
        if(in_array('correo', $vals) && $model->email == ''  && in_array('sms', $vals) && $model->celular == '' ){
            Yii::$app->session->setFlash('success', 'El paciente '.$model->nombreCorto.' se ha '.$accion.' exitosamente. Pero no se establecerá comunicación');
        } else if(in_array('sms', $vals) && ($model->celular == '' || $model->celular == null)){
            Yii::$app->session->setFlash('success', 'El paciente '.$model->nombreCorto.' se ha '.$accion.' exitosamente. Pero no se establecerá comunicación por teléfono');
        } else if(in_array('correo', $vals) && ($model->email == '' || $model->email == null)){
            Yii::$app->session->setFlash('success', 'El paciente '.$model->nombreCorto.' se ha '.$accion.' exitosamente. Pero no se establecerá comunicación por email');
        } else{
            Yii::$app->session->setFlash('success', 'El paciente '.$model->nombreCorto.' se ha '.$accion.' exitosamente');
        }
    }

    private function setMensajeFlash($model, $vals){
        if(in_array('correo', $vals) && ($model->email == '' || $model->email == null) && in_array('sms', $vals) && ($model->celular == '' || $model->celular == null)){
            Yii::$app->session->setFlash('success', 'El paciente '.$model->nombreCorto.' se ha guardado exitosamente. Pero no se establecerá comunicación');
        } else if(in_array('sms', $vals) && ($model->celular == '' || $model->celular == null)){
            Yii::$app->session->setFlash('success', 'El paciente '.$model->nombreCorto.' se ha guardado exitosamente. Pero no se establecerá comunicación');
        } else if(in_array('sms', $vals) && ($model->celular == '' || $model->celular == null)){
            Yii::$app->session->setFlash('success', 'El paciente '.$model->nombreCorto.' se ha guardado exitosamente. Pero no se establecerá comunicación');
        } else{
            Yii::$app->session->setFlash('success', 'El paciente '.$model->nombreCorto.' se ha guardado exitosamente');
        }
    }
    
    /**
     * Deletes an existing Paciente model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $usuario = Yii::$app->user->identity;
        $model = $this->findModel($id);
        if($model->id_suscripcion != $usuario->suscripcion->id){
            //return $this->redirect(["site/forbidden"], 403);
            return $this->redirect(['paciente/index']);
        }
        if($model->getCitas()->count() > 0){
            Yii::$app->session->setFlash("danger","El paciente tiene citas asociadas. No puede ser eliminado");
            return $this->redirect(['index']);
        }
        $model->delete();
        Yii::$app->session->setFlash('danger','Se ha eliminado el paciente '.$model->nombreCorto);
        return $this->redirect(['index']);
    }
    
    
    public function actionPacienteRapido(){
        $model = new Paciente;
        $model->scenario = Paciente::SCENARIO_OLIVIA_REGISTER;
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $post = Yii::$app->request->post();
        if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA){
            $model->id_clinica = SesionUtils::ClinicaSeleccionada()->id;
        }
        if ($model->load($post) && Yii::$app->request->isAjax) {
            $usuario = Yii::$app->user->identity;
            $id_suscripcion = $usuario->suscripcion->id;
            $model->id_suscripcion = $id_suscripcion;
            $model->fecha_creacion = date('Y-m-d H:i:s');
            $model->nombre = $post['Paciente']['nombre'];
            $model->apellido = $post['Paciente']['apellido'];
            $model->sexo = $post['Paciente']['sexo'];
            $model->celular = $post['Paciente']['celular'];
            $model->email = $post['Paciente']['email'];
            if($model->save()){
               Yii::$app->response->format = Response::FORMAT_JSON;
               return ["Correcto"=> True, "id_paciente" =>$model->id , "nombre"=>$model->nombreCompleto];
            } else {
                echo "MODEL NOT SAVED";
                print_r($model->getAttributes());
                print_r($model->getErrors());
                exit;
            }
        }
    }
    
    public function actionCambiarEstado(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $post = Yii::$app->request->post();
        $model = $this->findModel($post['id']);
        $model->estado = $post['estado'];
        $model->scenario = Paciente::SCENARIO_OLIVIA_REGISTER;
        if( $model->id_suscripcion != $suscripcion->id ){
            return ['Correcto' => false, 'mensaje'=> 'No se pudo completar la acción'];
        }
        if( $model->save() ){
            return ['Correcto' => true]; 
        }
        return ['Correcto' => false, 'mensaje'=> 'No se pudo actualizar el estado: ' . \app\customs\Utils::GetStringModelsErrors($model->getErrors())]; 
        
    }
    
    
    
    public function actionQuickSearch($query){
        $this->layout = false;
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $id_suscripcion = $suscripcion->id;
        
        $queryPacientes = Paciente::find()
                ->where(['id_suscripcion' => $id_suscripcion]);
        
        if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA && $usuario->tipoUsuarioJerarquia == UsuarioSuscripcion::TIPO_DEPENDIENTE){
            $queryPacientes->andWhere(['id_clinica' => SesionUtils::ClinicaSeleccionada()->id]);
        }
        if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA && ($usuario->tipoUsuarioJerarquia == UsuarioSuscripcion::TIPO_COORDINADOR || $usuario->tipoUsuarioJerarquia == UsuarioSuscripcion::TIPO_ASISTENTE)){
            $ids = $usuario->getGruposTrabajoUsuario()->select('id_grupo')->column();
            $queryPacientes->andWhere(['id_grupo' => $ids]);
        }
        if(count(explode(' ', $query)) > 1){
            $filtroWhere = ['OR'];
            foreach (explode(' ', $query) as $item){
                if($item != ''){
                    $filtroWhere[] = [
                            'OR',
                            ['LIKE', 'lower(nombre)',\strtolower($item) . '%', false],
                            ['LIKE', 'lower(nombre)','% ' . \strtolower($item) . '%', false],
                        ];
                    $filtroWhere[] = [
                            'OR',
                            ['LIKE', 'lower(apellido)', \strtolower($item) . '%', false],
                            ['LIKE', 'lower(apellido)','% ' .  \strtolower($item) . '%', false]
                        ];
                    $filtroWhere[] = [
                            'OR',
                            ['LIKE', 'lower(nombre_encargado)', \strtolower($item) . '%', false],
                            ['LIKE', 'lower(nombre_encargado)','% ' .  \strtolower($item) . '%', false]
                        ];
                    $filtroWhere[] = [
                            'OR',
                            ['LIKE', 'lower(codigo)', \strtolower($item) . '%', false],
                            ['LIKE', 'lower(codigo)','% ' .  \strtolower($item) . '%', false]
                        ];
                }    
            }
            $queryPacientes->andFilterWhere($filtroWhere);
        }
        else{
            $queryPacientes->andFilterWhere([
                    'or',
                    ['like','nombre',$query . '%', false],
                    ['like','nombre','% ' . $query . '%', false],
                    ['like','apellido',$query . '%', false],
                    ['like','apellido','% ' . $query . '%', false],
                    ['like','nombre_encargado',$query . '%', false],
                    ['like','nombre_encargado','% ' . $query . '%', false],
                    ['like','codigo', $query . '%', false],
                    ['like','codigo','% ' . $query . '%', false]

                ]);
        }
        $pacientes =  $queryPacientes->all();
        return $this->render('quicksearch',['model' => $pacientes]);
    }
    
    public function actionDuplicados(){
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $idSuscripcion = $suscripcion->id;
        $strQuery = 'c2.id!=c1.id
                    AND ( SUBSTRING_INDEX(c2.email, "@", 1)=SUBSTRING_INDEX(c1.email, "@", 1) OR c2.celular=c1.celular OR c2.telefono_fijo=c1.telefono_fijo ) 
                    AND ( c2.email IS NOT NULL OR c1.email IS NOT NULL )
                    AND ( c2.email!="" OR c1.email!="" )
                    AND ( c2.celular!="" OR c1.celular!="" )
                    AND ( c2.celular IS NOT NULL OR c1.celular IS NOT NULL )';
        $pacientes = Paciente::find()->alias('c1')
                ->innerJoin('paciente c2', $strQuery)
                ->andWhere([
                    'AND',
                    ['c1.id_suscripcion' => $idSuscripcion],
                    ['c2.id_suscripcion' => $idSuscripcion]
                ])->orderBy('email ASC, celular asc');
        return $this->render('duplicados', [
            'pacientes' => $pacientes->all(),
        ]);
    }

    
    public function actionObtenerPacientesUnir(){
        
        Yii::$app->response->format = Response::FORMAT_JSON;
        
        $id1 = Yii::$app->request->post("id1");
        $id2 = Yii::$app->request->post("id2");
        
        $paciente1 = $this->findModel($id1);
        $paciente2 = $this->findModel($id2);
        
        return ['Correcto' => true,'Paciente1' => $paciente1, 'Paciente2' => $paciente2];
    }
    
    
    

    
    public function actionUnir(){
        
        Yii::$app->response->format = Response::FORMAT_JSON;
        
        $id1 = Yii::$app->request->post("id1");
        $id2 = Yii::$app->request->post("id2");
        
        $paciente1 = $this->findModel($id1);
        $paciente2 = $this->findModel($id2);
        if($paciente2->migrar($paciente1->id)){
            $paciente2->delete();
        }
        
        return ['Correcto' => true,'Paciente1' => $paciente1, 'Paciente2' => $paciente2];
    }
    /**
     * Finds the Paciente model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Paciente the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Paciente::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    public function excludeFromSecurity() {
        return ['quick-search', 'paciente-rapido',
            'cambiar-estado',
            'obtener-pacientes-unir','unir'];
    }
    
    public function beforeAction($action)
    {            
        if ($action->id == 'pacientes') {
            $this->enableCsrfValidation = false;
        }

        return parent::beforeAction($action);
    }
    
    public function checkForSubscription() {
        return ['create','update'];
    }
}
