<?php

namespace app\controllers;

use Yii;
use app\models\Cita;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\ProcedimientoCita;
use app\models\HorarioMedico;
use app\models\UrlCita;
use app\models\Paciente;
use app\models\Usuario;
use app\models\Clinica;
use app\models\CitaSearch;
use app\models\repositories\CitaRepository;
use app\models\repositories\UrlCitaRepository;
use yii\web\Response;
use yii\helpers\ArrayHelper;
use app\customs\Utils;
use app\customs\SesionUtils;
use ClickSend\Configuration;
use ClickSend\Api\SMSApi;
use GuzzleHttp\Client;
use ClickSend\Model\SmsMessage;
use ClickSend\Model\SmsMessageCollection;
use app\models\BitacoraCitaMensaje;
use app\models\Pagadito;
use app\models\Suscripcion;
use app\models\UsuarioSuscripcion;
use app\models\repositories\ClinicaRepository;
use \app\models\ListaEspera;
use app\models\repositories\TokenRepository;
use app\customs\CitaPeriodica;
use app\models\BitacoraCita;

/**
 * CitaController implements the CRUD actions for Cita model.
 */
class CitaController extends BaseController
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                    'confirmar-cita' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Cita models.
     * @return mixed
     */
    public function actionIndex()
    {
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $idSuscripcion = $suscripcion->id;
        $where = [];
        $clinicas = [];
        if(($suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL && $usuario->tipo == Usuario::DOCTOR) 
                || ($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA && $usuario->tipoUsuarioJerarquia == UsuarioSuscripcion::TIPO_ADMINISTRADOR)){
            $where = ['cita.id_suscripcion' => $idSuscripcion];
            $clinicas = Clinica::find()->where(['clinica.id_suscripcion' => $idSuscripcion])->all();
        }
        else{
            $where = ['cita.id_suscripcion' => $idSuscripcion ,'cita.id_clinica' => SesionUtils::ClinicaSeleccionada()->id];
            $clinicas = $suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL 
                    ? $usuario->getClinicasActivasSuscripcion($idSuscripcion)
                    : ClinicaRepository::obtenerClinicasUsuario($usuario, $suscripcion);
                    
        }
        $c = \Yii::$app->request->post('c');
        $searchModel = new CitaSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams,$where,$c);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'clinicas'=> $clinicas,
            'clinicas_seleccionadas' => isset($c) ? $c : []
        ]);
        
    }
    
    

    /**
     * Displays a single Cita model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id,$createCita = false,$reprogramar = false, $fecha_anterior = null)
    {
        $usuario = Yii::$app->user->identity;
        $id_suscripcion = $usuario->suscripcion->id;
        $model = $this->findModel($id);
        $existCitaProx = false;
        $citaProx = $model->paciente->citaProxima;
        if($citaProx != null )$existCitaProx = true; 
        //$procedimiento_cita_array=$usuario->tipo == Usuario::DOCTOR ? ProcedimientoCita::find()->where(['id_cita' => $model->id])->all() :[];
        $procedimiento_cita_array = ProcedimientoCita::find()->where(['id_cita' => $model->id])->all();
        if($model->id_suscripcion != $usuario->suscripcion->id){
            //return $this->redirect(["site/forbidden"], 403);
            return $this->redirect(["cita/index"]);
        }
        return $this->render('view', [
            'model' => $model,
            'existCitaProx' => $existCitaProx,
            'createCita' => $createCita,
            'reprogramar' => $reprogramar,
            'fecha_anterior' => $fecha_anterior,
            'procedimiento_cita_array'=>$procedimiento_cita_array,
            'pagadito'=> Pagadito::find()->where(['id_suscripcion'=>$id_suscripcion])->one(),
            'medioPagoCita' => SesionUtils::getLlaveValor('conf_medio_pago')->valor
        ]);
    }
    
        /**
     * Displays a single Cita model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionViewTemplate($id,$createCita = false,$reprogramar = false, $fecha_anterior = null)
    {
        //Yii::$app->response->format = Response::FORMAT_JSON;
        $this->layout = false;
        $usuario = Yii::$app->user->identity;
        $id_suscripcion = $usuario->suscripcion->id;
        $model = $this->findModel($id);
        $existCitaProx = false;
        $citaProx = $model->paciente->citaProxima;
        if($citaProx != null )$existCitaProx = true; 
        //$procedimiento_cita_array=$usuario->tipo == Usuario::DOCTOR ? ProcedimientoCita::find()->where(['id_cita' => $model->id])->all() :[];
        $procedimiento_cita_array = ProcedimientoCita::find()->where(['id_cita' => $model->id])->all();
        if($model->id_suscripcion != $usuario->suscripcion->id){
            //return $this->redirect(["site/forbidden"], 403);
            return $this->redirect(["cita/index"]);
        }
        return $this->render('view-template', [
            'model' => $model,
            'existCitaProx' => $existCitaProx,
            'createCita' => $createCita,
            'reprogramar' => $reprogramar,
            'fecha_anterior' => $fecha_anterior,
            'procedimiento_cita_array'=>$procedimiento_cita_array,
            'pagadito'=> Pagadito::find()->where(['id_suscripcion'=>$id_suscripcion])->one(),
            'medioPagoCita' => SesionUtils::getLlaveValor('conf_medio_pago')->valor
        ]);
    }
    
    /**
     * Creates a new Cita model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($idLs = null)
    {   
        $llaveComunicacion = SesionUtils::getLlaveValor('comunicacion_paciente')->valor;
        $llaveCamposRequeridos = SesionUtils::getLlaveValor('campos_requeridos_paciente')->valor;
        $post = Yii::$app->request->post();
        $model = new Cita();
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $idSuscripcion = $suscripcion->id;
        $model->id_suscripcion = $idSuscripcion;
        $model->estado = Cita::AGENDADA;
        $model->id_clinica = ($usuario->tipo == Usuario::DOCTOR && $suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL
                        ? $model->id_clinica 
                        : SesionUtils::ClinicaSeleccionada()->id);
        if ($model->load($post)){       
            $model->cita_periodica_token = $model->repetirCita != CitaPeriodica::NO_REPETIR ? TokenRepository::getToken(10) : null;                
            $model->tipo_cita = $post['tipo-cita'];
            $model->fecha .= $model->horaFormat;
            if($idLs != null) $this->cambiarEstadoListaEspera(intval($idLs));
            if($model->save()){
                $costoProcs = explode(',', $post['costo-procedimiento']);
                Utils::guardarProcedimientos($model->isNewRecord,$model->id,$_POST['procedimientos'],$costoProcs,$model->costo);
                $this->enviarCreacionCita($model->id, $llaveComunicacion);
                $this->quitarPacienteDeListaEspera($model->id_paciente);
                if( $model->repetirCita != CitaPeriodica::NO_REPETIR ) CitaPeriodica::crear($model,$post['procedimientos'],$costoProcs,$usuario->id);
                if($model->repetirCita == CitaPeriodica::NO_REPETIR) CitaRepository::GuardarBitacoraCita($model->id, Cita::AGENDADA, $usuario->id, $model->cita_periodica_token);
                if( !empty($model->paciente->email_encargado_sec) ){ $this->enviarCreacionCitaEncargado($model); }
                Yii::$app->session->setFlash('success', 'La cita del paciente '.$model->nombrePaciente.' ha sido guardada exitosamente');
                return $this->redirect(['view', 'id' => $model->id, 'createCita' => true]);
            }
        }
        
        $get = Yii::$app->request->get();
        $paciente = new Paciente();
        if(isset($get['pid'])){
            $paciente = Paciente::findOne(['id' => $get['pid'],'id_suscripcion' => $idSuscripcion]);
            $model->id_paciente = $get['pid'];
        }
        
        $parametrosAdicionales = $this->parametrosAdicionales($get);
        $clinicas = ($usuario->tipo == Usuario::DOCTOR && $suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL
                                ? ArrayHelper::map(Clinica::find()->where(['id_suscripcion' => $idSuscripcion])->all(),'id','nombre')
                                : []);
        return $this->render('create', [
            'model' => $model,
            'modelP' => new Paciente(),
            'valoresComunicacion' => $llaveComunicacion, 
            'valoresCamposRequeridos' => $llaveCamposRequeridos, 
            'procedimientos' => $suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL 
                ? Utils::obtenerProcedimientosClinica($usuario->tipo,$model->id_clinica,$idSuscripcion)
                : Utils::obtenerProcedimientosGrupo(),
            'clinicas' => $clinicas,
            'diasNoHabiles' => $this->obtenerBloqueoDias($usuario->tipo, $idSuscripcion, $model->id_clinica),
            'paciente' => $paciente,
            'fecha' => $parametrosAdicionales['fecha'],
            'hora' => $parametrosAdicionales['hora'],
            'idsProcCalendario' => $parametrosAdicionales['idsProcCalendarios'],
            'tipo_suscripcion' => $suscripcion->tipo
        ]);
    }
    
    private function parametrosAdicionales($get){
        $fecha = null;
        $hora = null;
        $idsProcCalendarios = [];
        if(isset($get['fc'])){
            list($reqFecha, $procIds) = explode('?',$get['fc']);
            $fechaApoyo = null;
            $idsProcCalendarios = explode(',',$procIds);
            if( strlen($reqFecha) > 14 ){
                list($y,$m, $d, $h, $min, ,) = explode(',',$reqFecha);
                $fecha = date('d/m/Y', strtotime($y.'-'.($m+1).'-'.$d));
                $hora = date('h:i A', strtotime("$h:$min"));
            } else {
                $fechaApoyo = (int) $reqFecha;
                $d = date('Y-m-d', substr($fechaApoyo,0,10));
                $fecha = date('d/m/Y', strtotime($d.'+1 days'));
            }          
        }
        return ['fecha' => $fecha, 'hora' => $hora,'idsProcCalendarios' => $idsProcCalendarios];
    }
    
    
    /**
     * Añadir un cero a las horas y minutos correspondientes ejem de '0' a '01'
     * @param integer $n hora o minuto
     * @return string 
     */
    private function addCero($n){
        return $n < 10 ? '0'.$n : $n;
    }

    /**
     * Updates an existing Cita model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $fecha_cita = $model->fechaDB;
        $fecha = explode(' ', $model->fecha);
        $h_format = explode(':',date('g:i A', strtotime($fecha[1])));
        $h_F = $this->addCero( $h_format[0] ).':'.$h_format[1];
        $llaveComunicacion = SesionUtils::getLlaveValor('comunicacion_paciente')->valor;
        $llaveCamposRequeridos = SesionUtils::getLlaveValor('campos_requeridos_paciente')->valor;
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $idSuscripcion = $suscripcion->id;
        $post = Yii::$app->request->post();
        $reprogramar = false;
        if ($model->load($post)) {
            $model->tipo_cita = $post['tipo-cita'];
            $model->id_suscripcion = $idSuscripcion;
            $model->fecha .= $model->horaFormat;
            if($model->save()){
                $costoProcedimiento = explode(',', $post['costo-procedimiento']);
                if($model->estado != Cita::COMPLETADA){
                    Utils::guardarProcedimientos($model->isNewRecord,$model->id,$_POST['procedimientos'],$costoProcedimiento,$model->costo);
                }    
                if($fecha_cita != $model->fechaDB){
                    CitaRepository::LimpiarBitacoraReprogramacion($model->id);
                    CitaRepository::GuardarBitacoraCita($model->id, Cita::REPROGRAMADA, $usuario->id);
                    //$this->enviarReprogramacionCita($model->id, $fecha_cita, $valoresConf);
                    $reprogramar = true;
                }
                Yii::$app->session->setFlash('success', 'La cita del paciente '.$model->nombrePaciente.' ha sido actualizada correctamente');
                return $this->redirect(['view', 'id' => $model->id, 'reprogramar'=>$reprogramar, 'fecha_anterior'=>$fecha_cita]);
            }
        }
        if($model->id_suscripcion != $usuario->suscripcion->id){
            //return $this->redirect(["site/forbidden"], 403);
            return $this->redirect(["cita/index"]);

        }
        if($model->estado == Cita::CANCELADA || $model->estado == Cita::INASISTENCIA){
            \Yii::$app->session->setFlash("warning","La cita ya se encuentra " . Utils::nombreEstadoCita($model->estado) . ", no puede ser editada.");
            return $this->redirect(["index"]);
        }
        
        $clinicas = ($usuario->tipo == Usuario::DOCTOR && $suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL
                                ? ArrayHelper::map(Clinica::find()->where(['id_suscripcion' => $idSuscripcion])->all(),'id','nombre')
                                : []);
        return $this->render('update', [
            'model' => $model,
            'modelP' => $modelP = new Paciente(),
            'valoresComunicacion' => $llaveComunicacion, 
            'valoresCamposRequeridos' => $llaveCamposRequeridos, 
            'procedimientos' => $suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL 
                ? Utils::obtenerProcedimientosClinica($usuario->tipo,$model->id_clinica,$idSuscripcion)
                : Utils::obtenerProcedimientosGrupo(),
            'clinicas' => $clinicas,
            'diasNoHabiles' => $this->obtenerBloqueoDias($usuario->tipo,$idSuscripcion,$model->id_clinica),
            'fecha' => $fecha[0],
            'hora' => $h_F,
            'idsProcCalendario' => []
        ]);
    }
    
    /**
     * Deletes an existing Cita model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $usuario = Yii::$app->user->identity;
        $model = $this->findModel($id);
        if($model->estado == Cita::CANCELADA || $model->estado == Cita::COMPLETADA){
            Yii::$app->session->setFlash("danger","La cita se encuentra " . ($model->estado == Cita::CANCELADA ? "cancelada" : "completada"));
            return $this->redirect(['index']);
        }
        if($model->id_suscripcion != $usuario->suscripcion->id){
            return $this->redirect(["site/forbidden"], 403);
        }

        $model->estado = Cita::CANCELADA;
        $model->save();
        
        Yii::$app->session->setFlash("success","La cita se ha cancelado");
        CitaRepository::GuardarBitacoraCita($model->id, Cita::CANCELADA, $usuario->id);
        $this->enviarCancelarCita($id);
        return $this->redirect(['index']);
    }
    
    public function actionCancelarCita(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $idSuscripcion = $usuario->suscripcion->id;
        $post =  Yii::$app->request->post();
        if(isset($post['cita_periodica_token'])){
            $this->cancelarCitasPeriodicas($post['cita_periodica_token'],$post['fecha'],$idSuscripcion);
            Yii::$app->session->setFlash("danger","Las citas periodicas se han cancelado");
            return ['Correcto'=>true];
        }
        $model = $this->findModel($post['id']);
        if($model->estado == Cita::CANCELADA || $model->estado == Cita::COMPLETADA){
            Yii::$app->session->setFlash("danger","La cita se encuentra " . ($model->estado == Cita::CANCELADA ? "cancelada" : "completada"));
            return $this->redirect(['index']);
        }
        if($model->id_suscripcion != $idSuscripcion){
            return $this->redirect(["site/forbidden"], 403);
        }
        $model->estado = Cita::CANCELADA;
        if($model->save()){
            CitaRepository::GuardarBitacoraCita($model->id, Cita::CANCELADA, $usuario->id);
            $this->enviarCancelarCita($post['id']);
            Yii::$app->session->setFlash("danger","La cita se ha cancelado");
            return ['Correcto'=>true];
        }
        return ['Correcto'=>false];
    }
    
    private function cancelarCitasPeriodicas($token,$fecha,$idSuscripcion){
        $citasPeriodicas = Cita::find()
        ->where(['id_suscripcion'=>$idSuscripcion])
        ->andWhere(['cita_periodica_token'=>$token])
        ->andWhere(['>=', 'fecha', $fecha])
        ->andWhere(['<','estado', Cita::CANCELADA])
        ->all();
        foreach ($citasPeriodicas as  $cita) {
            $cita->estado = Cita::CANCELADA;
            if( $cita->update(false) ){
                $bitacora = BitacoraCita::find()
                    ->where(['id_cita'=>$cita->id])
                    ->andWhere(['estado' => Cita::AGENDADA])
                    ->one();
                $bitacora->estado = Cita::CANCELADA;
                $bitacora->update(false);
            }
        }
    }

    public function actionConfirmarCita(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = Yii::$app->request->post();
        $usuario = Yii::$app->user->identity;
        $id = $post['id'];
        $asistio = $post['asistio'];
        $cita = $this->findModel($id);
        if($cita->id_suscripcion != $usuario->suscripcion->id){
            return ['Correcto' => false, 'Mensaje' => 'La cita no pertenece a su suscripción'];
        }
        if($cita->estado  >= 3){ 
            return ['Correcto' => false, 'Mensaje' => 'La cita ya se encuentra ' . Utils::nombreEstadoCita($cita->estado)];
        }
        $cita->estado = $asistio == 'si' ? Cita::COMPLETADA : Cita::INASISTENCIA;
        $cita->save();
        CitaRepository::GuardarBitacoraCita($cita->id, $cita->estado, $usuario->id);
        UrlCitaRepository::eliminarUrlCitas($cita->id,UrlCita::PARA_CITA);
        if($cita->estado == Cita::COMPLETADA){
            $this->enviarFeedbackCita($cita->id);
        }
        return ['Correcto' => true, 'Cita'=>['id'=>$cita->id,'estado'=>$cita->estado]];
    }
    
    
    public function actionCambiarestadocita(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = Yii::$app->request->post();
        $model = $this->findModel($post['id']);
        $usuario = Yii::$app->user->identity;
        $idSuscripcion = $usuario->suscripcion->id;
        $model->id_suscripcion = $idSuscripcion;
        $model->estado = $post['estado'];
            if($model->save()){
                CitaRepository::GuardarBitacoraCita($model->id, $post['estado'], $usuario->id);
                return ['Correcto'=>true, 'Cita' => $model];
            }
            
    }
    
    /**
     * Envía el correo de satisfacción al paciente.-
     * @param int $idCita
     */
    private function enviarFeedbackCita($idCita){
        $valComunicacion = explode('|',SesionUtils::getLlaveValor('comunicacion_paciente')->valor);
        $tiemposComunicacion = explode('|', SesionUtils::getLlaveValor('tiempos_de_comunicacion')->valor);
        $cita = Cita::findOne(['id' => $idCita]);
        $urlCita = UrlCitaRepository::crearUrlCita($idCita, UrlCita::PARA_FEEDBACK);
        $urlFeedback = Yii::$app->params['urlFeedback'];
        $articuloMail = SesionUtils::armarArticulo($cita->id_suscripcion, false, false);        
        $articuloSms = SesionUtils::armarArticulo($cita->id_suscripcion, true, false);
        $esSms = (\in_array('sms', $valComunicacion) && \in_array('Retroalimentación', $tiemposComunicacion)) ? true : false;
        $esMail = (\in_array('correo', $valComunicacion) && \in_array('Retroalimentación', $tiemposComunicacion)) ? true : false;
        $this->guardarBitacora($cita->id,$cita->estado,$esMail,$esSms);
        if($esMail && $cita->paciente->email != '' ){
            $email = $cita->paciente->email;
            Yii::$app->mailer->compose('feedback',['model' => $cita,'urlCita' => $urlCita, 'articulo'=>$articuloMail])
                    ->setFrom(['citas@oliviahealth.com' => 'Olivia Health'])
                    ->setTo($email)
                    ->setSubject("¿Qué tal tu cita con " .$articuloMail. "?")
                    ->send();
        }
        
        if($esSms && $cita->paciente->celular != '' ){
            $username = \yii::$app->params["clickSendU"];
            $password = \yii::$app->params["clickSendP"];
            $csConfig = Configuration::getDefaultConfiguration()
                    ->setUsername($username)
                    ->setPassword($password);
            $csApi = new SMSApi(new Client(['verify' => false]),$csConfig);
            $smsCollector = new SmsMessageCollection();
            $paciente = $cita->paciente;
            $mensaje = "¿Que tal tu cita con " .$articuloSms. "?\n"
                    ."Para que mejoremos, cuentanos la experiencia de tu cita en el siguiente link.\n\n"
                    .$urlFeedback."?t=".$urlCita->llave;
            $sms = new SmsMessage();
            $sms->setBody($mensaje);
            $sms->setTo($paciente->celular);
            $sms->setSource("sdk");
            $messages[] = $sms;
            if(\count($messages) > 0){
                $smsCollector->setMessages($messages);
                $result = $csApi->smsSendPost($smsCollector);
                $this->guardarBitacoraMsg($cita->id, $cita->estado, false, true, BitacoraCitaMensaje::ES_RETROALIENTACION);
            }
        }
    }
    
    private function guardarBitacoraMsg($idCita,$estado,$esMail,$esSMS, $tipo){
        $bitacoraCita = new BitacoraCitaMensaje();
        $bitacoraCita->fecha = \date("Y-m-d H:i:s");
        $bitacoraCita->id_cita = $idCita;
        $bitacoraCita->estado_cita = $estado;
        $bitacoraCita->es_correo = $esMail;
        $bitacoraCita->es_sms = $esSMS;
        $bitacoraCita->tipo = $tipo;
        $bitacoraCita->save();
    }
    
    /**
     * Envía el correo de satisfacción al paciente.-
     * @param int $idCita
     */
    private function enviarReprogramacionCita($idCita,$fecha_anterior, $valoresConfig){
        $cita = $this->findModel($idCita);
        $email = $cita->paciente->email;
        $articulo = SesionUtils::armarArticulo($cita->id_suscripcion, false, false);
        if($email != '' && in_array('correo', $valoresConfig)){
            Yii::$app->mailer->compose('reprogramar-cita',['model' => $cita,'fecha_anterior' => $fecha_anterior])
                    ->setFrom(['citas@oliviahealth.com' => 'Olivia Health'])
                    ->setTo($email)
                    ->setSubject("Cita reprogramada con " .$articulo)
                    ->send();
        }
    }
    
    /**
     * Envía el correo de cambio de fecha de la cita.-
     */
    public function actionEnviarReprogramacionCitaPaciente(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $llave = SesionUtils::getLlaveValor('comunicacion_paciente');
        $valoresConf = explode('|', $llave->valor);
        $post = Yii::$app->request->post();
        if(Yii::$app->request->isAjax){
            $fecha_anterior = $post['fecha_anterior'];
            $cita = $this->findModel($post['id_cita']);
            $email = $cita->paciente->email;
            $articulo = SesionUtils::armarArticulo($cita->id_suscripcion, false, false);
            if($email != '' && in_array('correo', $valoresConf  )){
                Yii::$app->mailer->compose('reprogramar-cita',['model' => $cita,'fecha_anterior' => $fecha_anterior])
                        ->setFrom(['citas@oliviahealth.com' => 'Olivia Health'])
                        ->setTo($email)
                        ->setSubject("Cita reprogramada con " .$articulo)
                        ->send();
            }
            return ['Correcto'=>true];
        }
        return ['Correcto'=>false];
    }
    
    /**
     * Envía el correo de creación de cita al paciente.-
     * @param int $idCita
     * @param string $llaveComunicacion
     */
    private function enviarCreacionCita($idCita, $llaveComunicacion){
        $cita = Cita::findOne(['id' => $idCita]);
        $email = $cita->paciente->email;
        $articulo = SesionUtils::armarArticulo($cita->id_suscripcion, false, false);
        $valoresComunicacion = explode('|', $llaveComunicacion);
        $linkTeleconsulta = $cita->suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL 
                ? SesionUtils::getLlaveValor('link_teleconsulta')->valor
                : SesionUtils::getValorLlave('link_teleconsulta',$cita->id_suscripcion,$cita->id_clinica)->valor;
        
        if( !empty($email) && in_array('correo', $valoresComunicacion)){
            Yii::$app->mailer->compose('crear-cita',
                    [
                        'model' => $cita,
                        'articulo'=>$articulo,
                        'linkTeleconsulta' => $linkTeleconsulta,
                        'omitirClinica' => $cita->suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA
                    ])
                ->setFrom(['citas@oliviahealth.com' => 'Olivia Health'])
                ->setTo($email)
                ->setSubject("Cita con ".$articulo)
                ->send();
        }
    }
    
    /**
     * Envía el correo de creación de cita al paciente.-
     * @param app\models\Cita $cita 
     */
    private function enviarCreacionCitaEncargado($cita){
        $email = $cita->paciente->email_encargado_sec;
        $articulo = SesionUtils::armarArticulo($cita->id_suscripcion, false, false);
        $linkTeleconsulta = SesionUtils::getLlaveValor('link_teleconsulta')->valor;
        Yii::$app->mailer->compose('crear-cita-encargado',['model' => $cita, 'articulo'=>$articulo, 'linkTeleconsulta' => $linkTeleconsulta])
            ->setFrom(['citas@oliviahealth.com' => 'Olivia Health'])
            ->setTo($email)
            ->setSubject("Cita con ".$articulo)
            ->send();
    }
    
    /**
     * Envía el correo de creación de cita al paciente.-
     * @param int $idCita
     */
    private function enviarCancelarCita($idCita){
        $cita = Cita::findOne(['id' => $idCita]);
        $now = time();
        $articulo = SesionUtils::armarArticulo($cita->id_suscripcion, false, false);
        if(strtotime($cita->fechaDB) < $now){
            $email = $cita->paciente->email;
            Yii::$app->mailer->compose('cancelar-cita',['model' => $cita, 'articulo'=>$articulo])
                    ->setFrom(['citas@oliviahealth.com' => 'Olivia Health'])
                    ->setTo($email)
                    ->setSubject("Cita cancelada con " .$articulo)
                    ->send();
        }
    }
    
    private function obtenerBloqueoDias($tipoUsuario,$idSuscripcion,$idClinica){
        $whereDiasHabiles = $tipoUsuario == Usuario::DOCTOR 
                ? ['id_suscripcion' => $idSuscripcion] 
                : ['id_clinica' => $idClinica];
        $dias = [1,2,3,4,5,6,7];
        $r = [];
        $horarios = ArrayHelper::getColumn(HorarioMedico::find()->where($whereDiasHabiles)->select('dia')->distinct()->all(),'dia');
        foreach ($dias as $dia){
            if(!in_array($dia, $horarios)){
                $r[]=$dia;
            }
        }
        return $r;
    }
    
    /**
     * Cambiar estado de un elemento de la lista de espera a completado
     * @param integer $id id de la lista de espera
     */
    private function cambiarEstadoListaEspera($id){
        $model = ListaEspera::findOne($id);
        $usuario = Yii::$app->user->identity;
        if($model->id_suscripcion == $usuario->suscripcion->id){
            $model->estado = ListaEspera::COMPLETADO;
            $model->save();
        }
    }
    
    private function quitarPacienteDeListaEspera($id){
        $condicion = ['id_paciente' => $id];
        $actualizar = ['estado' => ListaEspera::COMPLETADO]; 
        ListaEspera::updateAll($actualizar,$condicion);
    }
    
    private function guardarBitacora($idCita,$estado,$esMail,$esSMS){
        $bitacoraCita = new BitacoraCitaMensaje();
        $bitacoraCita->fecha = \date("Y-m-d H:i:s");
        $bitacoraCita->id_cita = $idCita;
        $bitacoraCita->estado_cita = $estado;
        $bitacoraCita->es_correo = $esMail;
        $bitacoraCita->es_sms = $esSMS;
        $bitacoraCita->save();
    }
    
    /**
     * Finds the Cita model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Cita the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Cita::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    public function excludeFromSecurity() {
        return ['view-template', 'adjuntos-cita', 'enviar-reprogramacion-cita-paciente'];
    }


    public function beforeAction($action)
    {            
        if ($action->id == 'confirmar-cita') {
            $this->enableCsrfValidation = false;
        }

        return parent::beforeAction($action);
    }
    
    public function checkForSubscription() {
        return ['create','update'];
    }
}
