<?php

namespace app\controllers;

use Yii;
use app\models\Usuario;
use app\models\Perfil;
use yii\data\ActiveDataProvider;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Rol;
use app\models\Paciente;
use app\models\Clinica;
use app\models\UsuarioSuscripcion;
use app\models\Feedback;
use yii\helpers\ArrayHelper;
use app\models\repositories\TokenRepository;
use app\customs\SesionUtils;


/**
 * UsuarioController implements the CRUD actions for Usuario model.
 */
class UsuarioController extends BaseController {

    /**
     * {@inheritdoc}
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Usuario models.
     * @return mixed
     */
    public function actionIndex() {
        $dataProvider = new ActiveDataProvider([
            'query' => Usuario::find(),
        ]);

        return $this->render('index', [
                    'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Usuario model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Usuario model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $model = new Usuario();
        $perfil = new Perfil();
        $model->setValidateOldPassword(false);
        $model->oldPassword = "123456";
        if ($model->load(Yii::$app->request->post()) && $perfil->load(Yii::$app->request->post())) {
            if ($model->save()) {
                $perfil->id = $model->id;
                if ($perfil->save()) {
                    return $this->redirect(['view', 'id' => $model->id]);
                } else {
                    $list = ArrayHelper::map(Rol::find()->all(), 'id', 'nombre');
                    $model->isNewRecord = false;
                    return $this->render('update', [
                                'model' => $model,
                                'perfil' => $perfil,
                                'roles' => $list
                    ]);
                }
            }
        }
        $list = ArrayHelper::map(Rol::find()->all(), 'id', 'nombre');
        return $this->render('create', [
                    'model' => $model,
                    'perfil' => $perfil,
                    'roles' => $list
        ]);
    }

    /**
     * Updates an existing Usuario model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);
        $perfil = Perfil::findOne(['id' => $id]);
        if ($perfil == null) {
            $perfil = new Perfil();
        }
        $isPost = $model->load(Yii::$app->request->post());
        $canSave = false;
        if ($isPost) {
            $model->setValidateOldPassword(false);
            $model->oldPassword = "123456";
            $canSave = $model->save();
        }
        if ($isPost && $canSave) {
            Yii::$app->session->setFlash('success', 'El usuario '.$model->nombre_usuario.' se ha actualizado correctamente');
            return $this->redirect(['view', 'id' => $model->Id]);
        } else {
            $list = ArrayHelper::map(Rol::find()->all(), 'id', 'nombre');
            return $this->render('update', [
                        'model' => $model, 'roles' => $list,
                        'perfil' => $perfil
            ]);
        }
    }

    public function actionChangePassword() {
        $id = \Yii::$app->user->identity->Id;
        $model = $this->findModel($id);
        $model->setValidateOldPassword(true);
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Contraseña actualizada exitosamente');
            return $this->redirect(['site/index']);
        } else {
            return $this->render('change-password', [
                        'model' => $model
            ]);
        }
    }

//Invocar el formulario profile.php
    public function actionProfile() {
        $usuario = Yii::$app->user->identity;
        $id_suscripcion = $usuario->suscripcion->id;
        $clinicas = $usuario->tipo == Usuario::DOCTOR ? Clinica::find()->where(["id_suscripcion" => $id_suscripcion])->all() : SesionUtils::ClinicaSeleccionada();
        $pacientes = Paciente::find()->where(["id_suscripcion" => $id_suscripcion])->all();
        $feedback = $usuario->tipo == Usuario::DOCTOR ? Feedback::find()->alias('f')->join('INNER JOIN', 'cita as c', 'c.id=f.id_cita')->where(['c.id_suscripcion' => $id_suscripcion])->all() : NULL;
        $asistentes = UsuarioSuscripcion::find()->where(["id_suscripcion" => $id_suscripcion])->all();
        $firma = $usuario->tipo == Usuario::DOCTOR ? $usuario->suscripcion->firma : null;
        $labelFirma = empty($firma) ? 'Agregar' : 'Actualizar';
        return $this->render('profile', [
                    'clinicas' => $clinicas,
                    'pacientes' => $pacientes,
                    'feedback' => $feedback,
                    'asistentes' => $asistentes,
                    'firma' => $firma,
                    'labelFirma' => $labelFirma
        ]);
    }
    
    public function actionUpdatepassword($id) {
        $model = Usuario::findOne(['id' => $id]);
        $usuario = $model;
        $password = TokenRepository::getToken(TokenRepository::TamanioPassword);
        $usuario->password = $password;
        $usuario->passwordConfirm = $password;
        if ($usuario->update()) {
            $this->reestablecerPassword($model, $password);
            \Yii::$app->session->setFlash("success","Contraseña reestablecida correctamente ".$password);
            return $this->redirect(['view', 'id'=>$id]);
        }
    }

    /**
     * 
     * @param app\models\Usuario $usuario
     */
    private function reestablecerPassword($usuario, $password) {
        //$suscripcion = Yii::$app->user->identity->suscripcion;
    \yii::$app->mailer->compose('new-password-usuario', ['model' => $usuario, 'password' => $password])
                ->setFrom(['info@oliviahealth.com' => 'Olivia Health'])
                ->setTo($usuario->perfil->email)
                ->setSubject("Estimado ".$usuario->perfil->nombreCorto.": Tu contraseña fue reestablecida")
                ->send();
    }

    public function actionBillings() {
        return $this->render('billings');
    }

    /**
     * Deletes an existing Usuario model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id) {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Usuario model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Usuario the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = Usuario::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    public function excludeFromSecurity() {
        return ['change-password', 'profile'];
    }

}
