<?php

namespace app\controllers;

use Yii;
use app\models\UrlSuscripcion;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\Response;
use app\models\repositories\TokenRepository;

class UrlSolicitudCitaController extends BaseController{

         /**
     * {@inheritdoc}
     */
    public function behaviors(){
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'guardar-url-usuario' => ['POST'],
                    'validar-existencia' => ['GET'],
                ],
            ],
        ];
    }
    
    
    public function actionIndex(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $model = self::getModel([ 'id_suscripcion' => $usuario->suscripcion->id ])->one();
        if( $model == null || empty($model) ){
            $model = self::confDefault( $usuario ); 
        }
        return ['Correcto' => true , 'UsuarioUrl' => $model->usuario ];
    }
    
    public function actionGuardarUrlUsuario(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $post = Yii::$app->request->post();
        $model = self::getModel( ['id_suscripcion' => $usuario->suscripcion->id ])->one();
        $comparModel = self::getModel(['usuario' => $post['str']])->one();
        if( ($comparModel != null || !empty($comparModel)) && $comparModel->id_suscripcion != $usuario->suscripcion->id ){
            return [ 'Correcto' => false, 'Mensaje' => 'El usuario ingresado ya se encuentra en uso'];
        }
        
        $model->usuario = $post['str'];
        $model->save();
        return [ 'Correcto' => true, 'Mensaje'=> 'Url configurada correctamnete' ];
        
    }
    
    public function actionValidarExistencia($str){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $model = self::getModel(['usuario' => $str])->one();
        if( $model != null && $model->id_suscripcion != $usuario->suscripcion->id){
            return ['Correcto'=> false, 'Mensaje' => 'El usuario ingresado ya se encuentra en uso'];
        }
        return ['Correcto'=> true ];
    }
    
    /**
     * Agregar la configuracion por defecto del string para la URL de solicitudes. Se crea una configuracion con un token por defecto
     * @param app\models\Usuario $usuario
     * @return app\models\UrlSuscripcion
     */
    private static function confDefault($usuario){
        $model = new UrlSuscripcion();
        $model->id_suscripcion = $usuario->suscripcion->id;
        $model->usuario = TokenRepository::getToken( $length=25 );
        $model->save();
        return $model;
    }
    
    /**
     * Buscar la configuracion de usuario
     * @param array $where Condicion de la consulta
     * @return app\models\UrlSuscripcion
     */
    private static function getModel( $where ){
        return UrlSuscripcion::find()->where($where);
    }

    
    public function beforeAction($action) {
        if($action->id == 'guardar-url-usuario'){
            $this->enableCsrfValidation = false;
        }
        return parent::beforeAction($action);
    }
    
    public function excludeFromSecurity() {
        return ['index', 'guardar-url-usuario', 'validar-existencia'];
    }
    
}

