<?php

namespace app\controllers;

use yii\filters\VerbFilter;
use yii\web\Response;
use app\customs\BaseController;
use Yii;
use yii\db\Expression;
use app\models\Cita;
use app\models\Feedback;
use kartik\mpdf\Pdf;
use yii\helpers\ArrayHelper;
use app\models\Usuario;
use app\models\Evento;
use app\models\RecordatorioDoctor;
use app\customs\SesionUtils;
use app\models\Paciente;
use app\models\GrupoTrabajo;

class ReportesController extends BaseController {
    //put your code here
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'datos-citas-periodo' => ['post'],
                ],
            ],
        ];
    }
    
    public function actionRetroalimentacion()

    {
        $usuario = \Yii::$app->user->identity;
        $id_suscripcion = $usuario->suscripcion->id; 
        $get = \Yii::$app->request->get();
        $totalFeedbacks = 0;
        $totalCitas = 0;
        $totalValoraciones = 0;
        $calificacion_promedio = 0;
        $porcentaje_respuesta = 0; 
        $feedbacks = Feedback::find()->alias('f')->join('INNER JOIN','cita as c','c.id=f.id_cita')
                ->where(['c.id_suscripcion'=>$id_suscripcion]);
        $cita = Cita::find()
                ->where(['id_suscripcion'=>$id_suscripcion])
                ->andWhere(['estado' => Cita::COMPLETADA]);
        $cita_calificacion = [];
        $citas = $cita
                ->where(['id_suscripcion'=>$id_suscripcion])
                ->andWhere(['estado' => Cita::COMPLETADA])
                ->all();
        $periodo = isset($get['periodo']) ? explode('?',$get['periodo'])[0] : 'week';
        $label =  $periodo == 'week' ? 'Semana' : ($periodo == 'month' ? 'Mes' : ($periodo == 'trimester' ? 'Trimestre' : 'Personalizado'));
        if(isset($get['periodo']) &&  count($p = explode('?',$get['periodo'])) > 1 ){
            $rango = explode('|',$p[1]);
            $fecha_i = \DateTime::createFromFormat('d/m/Y', $rango[0])->format('Y-m-d');
            $fecha_f = \DateTime::createFromFormat('d/m/Y', $rango[1])->format('Y-m-d');
        }
        switch ($periodo){
            case 'week':
                $feedbacks
                    ->andWhere(['<=',new Expression('DATE(f.fecha)'), new Expression('DATE(NOW())')])
                    ->andWhere(['>=',new Expression('DATE(f.fecha)'), new Expression('DATE(NOW() - INTERVAL 7 DAY)')])
                    ->orderBy(['f.fecha'=>SORT_DESC]);
                $cita_calificacion=$feedbacks->all();
                $totalFeedbacks=$feedbacks->count();
                $totalValoraciones=$feedbacks->sum('f.puntuacion');
                $totalCitas=$cita
                    ->andWhere(['<=',new Expression('DATE(fecha)'), new Expression('DATE(NOW())')])
                    ->andWhere(['>=',new Expression('DATE(fecha)'), new Expression('DATE(NOW() - INTERVAL 7 DAY)')])
                    ->count();
            break;
            case 'trimester':
                $cita_calificacion=$feedbacks
                    ->where(['<=',new Expression('DATE(f.fecha)'), new Expression('DATE(NOW())')])
                    ->where(['>=',new Expression('DATE(f.fecha)'), new Expression('DATE(NOW() - INTERVAL 3 MONTH)')])
                    ->orderBy(['f.fecha'=>SORT_DESC])->all();
                $totalFeedbacks=$feedbacks
                    ->andWhere(['<=',new Expression('DATE(f.fecha)'), new Expression('DATE(NOW())')])
                    ->andWhere(['>=',new Expression('DATE(f.fecha)'), new Expression('DATE(NOW() - INTERVAL 3 MONTH)')])
                    ->count();
                $totalValoraciones=$feedbacks
                    ->andWhere(['<=',new Expression('DATE(f.fecha)'), new Expression('DATE(NOW())')])
                    ->andWhere(['>=',new Expression('DATE(f.fecha)'), new Expression('DATE(NOW() - INTERVAL 3 MONTH)')])
                    ->sum('f.puntuacion');
                $totalCitas=$cita
                    ->andWhere(['<=',new Expression('DATE(fecha)'), new Expression('DATE(NOW())')])
                    ->andWhere(['>=',new Expression('DATE(fecha)'), new Expression('DATE(NOW() - INTERVAL 3 MONTH)')])
                    ->count();
            break; 
            case 'custom':
                $cita_calificacion=$feedbacks
                    ->where(['<=',new Expression('DATE(f.fecha)'), $fecha_f])
                    ->where(['>=',new Expression('DATE(f.fecha)'), $fecha_i])
                    ->orderBy(['f.fecha'=>SORT_DESC])->all();
                $totalFeedbacks=$feedbacks
                    ->andWhere(['<=',new Expression('DATE(f.fecha)'), $fecha_f])
                    ->andWhere(['>=',new Expression('DATE(f.fecha)'), $fecha_i])
                    ->count();
                $totalValoraciones=$feedbacks
                    ->andWhere(['<=',new Expression('DATE(f.fecha)'), $fecha_f])
                    ->andWhere(['>=',new Expression('DATE(f.fecha)'), $fecha_i])
                    ->sum('f.puntuacion');
                $totalCitas=$cita
                    ->andWhere(['<=',new Expression('DATE(fecha)'), $fecha_f])
                    ->andWhere(['>=',new Expression('DATE(fecha)'), $fecha_i])
                    ->count();
            break; 
            default:
                $cita_calificacion=$feedbacks
                    ->andWhere(['<=',new Expression('DATE(f.fecha)'), new Expression('DATE(NOW())')])
                    ->andWhere(['>=',new Expression('DATE(f.fecha)'), new Expression('DATE(NOW() - INTERVAL 1 MONTH)')])
                    ->orderBy(['f.fecha'=>SORT_DESC])->all();
                $totalFeedbacks=$feedbacks
                    ->andWhere(['<=',new Expression('DATE(f.fecha)'), new Expression('DATE(NOW())')])
                    ->andWhere(['>=',new Expression('DATE(f.fecha)'), new Expression('DATE(NOW() - INTERVAL 1 MONTH)')])
                    ->count();
                $totalValoraciones=$feedbacks
                    ->andWhere(['<=',new Expression('DATE(f.fecha)'), new Expression('DATE(NOW())')])
                    ->andWhere(['>=',new Expression('DATE(f.fecha)'), new Expression('DATE(NOW() - INTERVAL 1 MONTH)')])
                    ->sum('f.puntuacion');
                $totalCitas=$cita
                    ->andWhere(['<=',new Expression('DATE(fecha)'), new Expression('DATE(NOW())')])
                    ->andWhere(['>=',new Expression('DATE(fecha)'), new Expression('DATE(NOW() - INTERVAL 1 MONTH)')])
                    ->count();
            break;
        }
        
        $porcentaje_respuesta = $totalCitas == 0 ? 0 : $totalFeedbacks/$totalCitas;
        $calificacion_promedio = $totalFeedbacks == 0 ? 0 : ($totalValoraciones/$totalFeedbacks)*(10/3);          
        return $this->render('retroalimentacion',[
            'citas'=> $citas,
            'cita_calificacion' => $cita_calificacion,
            'totalFeedbacks'=> $totalFeedbacks,
            'calificacion_promedio' => $calificacion_promedio,
            'porcentaje_respuesta' => $porcentaje_respuesta,
            'periodo' => $periodo,
            'label' => $label
     
        ]);
        return $this->refresh();
        
    }
     public function actionRecordatorios()
    {
        return $this->render('recordatorios');
    }
    
    public function actionCitas()
    {
        return $this->render('citas');
    }
    
    public function actionDatosCitasPeriodo(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = \Yii::$app->request->post();
        $periodo = $post['periodo'];
        $rango = isset($post['rango']) ? $post['rango'] : null;
        $usuario = \Yii::$app->user->identity;
        $id_suscripcion = $usuario->suscripcion->id;
        $resultado = [];
        switch ($periodo){
            case 'week':
                $resultado = $this->conteoSemana($id_suscripcion);
                break;
            case 'month':
                $resultado = $this->conteoMes($id_suscripcion,$periodo);
                break;
            case 'custom':
                $resultado = $this->conteoRango($id_suscripcion,$rango);
                break;
            default:
                $resultado = $this->conteoMes($id_suscripcion,$periodo);
                break;
        }
        return ['Correcto' => true, 'Resultado' => $resultado];
    }
    
    private function conteoSemana($id_suscripcion){
        $conteo = [];
        $labels = [];
        $totalCitas = 0;
        for($i = 7; $i >= 1; $i--){        
                    $citasSemana = Cita::find()
                    ->where(['id_suscripcion' => $id_suscripcion])
                    ->andWhere(['<>','estado',Cita::CANCELADA])
                    ->andWhere(['=',new Expression('DATE(fecha)'), new Expression('DATE_ADD(CURDATE(),INTERVAL -' . $i . ' DAY)')])
                    ->count();
            $conteo[] = $citasSemana;
            $totalCitas += $citasSemana;
            $date = new \DateTime('-' . $i . ' day');
            $labels[] = $date->format('d/m/Y');
        }
        return $this->formatoRespuesta(7,$totalCitas,$conteo,$labels,$id_suscripcion);
    }
    
    private function conteoMes($id_suscripcion,$tipo){
        $now = \date('Y-m-d');
        $conteo = [];
        $labels = [];
        $totalCitas = 0;
        $inicio_i = $tipo == 'month' ? 3 : 6;
        $factor_multiplo = $tipo == 'month' ? 7 : 15;
        $factor_suma = $tipo == 'month' ? 6 : 14;
        for($i = $inicio_i; $i >= 0; $i--){
            $factorInicial = ($i * $factor_multiplo) + 1;
            $factorFinal = ($factorInicial + $factor_suma);
            $query = Cita::find()
                    ->where(['id_suscripcion' => $id_suscripcion])
                    ->andWhere(['<>','estado',Cita::CANCELADA])
                    ->andWhere([
                        'between',
                        new Expression('DATE(fecha)'),
                        new Expression('DATE_ADD(\'' . $now . '\',INTERVAL -' . $factorFinal . ' DAY)'),
                        new Expression('DATE_ADD(\'' . $now . '\',INTERVAL -' . $factorInicial . ' DAY)')
                        ]);
            $totalMes =  $query->count();
            $strQuery = $query->createCommand()->rawSql;
            $totalCitas += $totalMes;
            $conteo[] = $totalMes;
            $date1 = new \DateTime('-' . $factorFinal . ' day');
            $date2 = new \DateTime('-' . $factorInicial . ' day');
            $labels[] = $date1->format('d/m/Y') . ' - ' . $date2->format('d/m/Y');
        }
        $diasFinal = ($inicio_i * $factor_multiplo) + $factor_suma;
        return $this->formatoRespuesta($diasFinal,$totalCitas,$conteo,$labels,$id_suscripcion,$strQuery);
    }
    
    private function conteoRango($id_suscripcion,$rango){
        list( $inicio, $fin ) = explode('|', $rango);
        $fecha_inicial = \DateTime::createFromFormat('d/m/Y', $inicio)->format('Y-m-d');
        $fecha_final = \DateTime::createFromFormat('d/m/Y', $fin)->format('Y-m-d');
        $nDias = $this->totalDiasFechas($fecha_inicial,$fecha_final);
        $count = floor($nDias/7);
        if( $nDias % 7 == 0 ){ $count--; }
        $rangos = $this->rangosFechasConteo($fecha_inicial,$fecha_final,$count);
        $conteo = [];
        $labels = [];
        $totalCitas = 0;
        $nRangos = count($rangos)/2;
        $f_i = 0;
        $f_l = 1;
        for($i = 0; $i < $nRangos; $i++){
            $query = Cita::find()
                    ->where(['id_suscripcion' => $id_suscripcion])
                    ->andWhere(['<>','estado',Cita::CANCELADA])
                    ->andWhere(['<>','estado',Cita::INASISTENCIA])
                    ->andWhere([
                        'between',
                        new Expression('DATE(fecha)'),
                        $rangos[$f_i],
                        $rangos[$f_l]
                        ]);
            $totalPeriodo =  $query->count();
            $strQuery = $query->createCommand()->rawSql;
            $totalCitas += $totalPeriodo;
            $conteo[] = $totalPeriodo;
            $labels[] = \DateTime::createFromFormat('Y-m-d', $rangos[$f_i])->format('d/m/Y').' - '.\DateTime::createFromFormat('Y-m-d', $rangos[$f_l])->format('d/m/Y');
            $f_i = $f_i + 2;
            $f_l = $f_l + 2;
        }
        $diasFinal = $nDias;
        return $this->formatoRespuesta($diasFinal,$totalCitas,$conteo,$labels,$id_suscripcion,$strQuery,$fecha_final);
    }
    
    private function rangosFechasConteo($fecha_inicial,$fecha_final,$count){
        $rangos = [];
        $rangos[] = $fecha_inicial;
        $fechaApoyo = $fecha_inicial;
        for($i=1; $i<=$count; $i++){
            if( strtotime($fechaApoyo.'+7 days') >= strtotime($fecha_final) ){
                break;
            }
            $fechaApoyo = date('Y-m-d', strtotime($fechaApoyo.'+7 days'));
            $rangos[] = $fechaApoyo;
            $fechaApoyo2 = date('Y-m-d', strtotime($fechaApoyo.'+1 days'));
            $rangos[] = $fechaApoyo2;
        }
        $rangos[] = $fecha_final;
        
        return $rangos;
    }
    
    private function totalDiasFechas($fecha_inicial,$fecha_final){
        $dias = ( strtotime($fecha_inicial) - strtotime($fecha_final) )/86400;
        $diasAbs = abs($dias); 
        $diasFloor = floor($diasAbs);
        return $diasFloor;
    }

    private function formatoRespuesta($diasFinal,$totalCitas,$conteo,$labels,$id_suscripcion,$strQuery = '',$fecha = null){
        $now = $fecha != null ? $fecha : \date('Y-m-d');
        $queryCompletas = Cita::find()->alias('c')->where(['c.id_suscripcion' => $id_suscripcion])
                    ->andWhere(['c.estado' => Cita::COMPLETADA])
                    ->andWhere([
                        'between',
                        new Expression('DATE(c.fecha)'),
                        new Expression('DATE_ADD(\'' . $now . '\',INTERVAL -' . $diasFinal . ' DAY)'),
                        new Expression('DATE_ADD(\'' . $now . '\',INTERVAL -1 DAY)')
                        ]);
        //$strQuery = $queryCompletas->createCommand()->rawSql;
        $total_completas =  $queryCompletas->count();
        $qMonto = $queryCompletas
                ->join('INNER JOIN', 'procedimiento_cita as pc','c.id=pc.id_cita')
                ->join('INNER JOIN', 'procedimiento as p','p.id=pc.id_procedimiento');
        $monto = $qMonto->sum('pc.costo_editado');
        $monto_entero = floor($monto);
        $centavos = round( ($monto - $monto_entero) * 100, 0, PHP_ROUND_HALF_UP );
        $datosCitas =[
                    'Query' => $qMonto->createCommand()->rawSql,
                    'TotalCitas' => $totalCitas,
                    'TotalCompletas' => $total_completas,
                    'Porcentaje' => $totalCitas == 0 ? 0 : round(($total_completas/$totalCitas),2)*100,
                    'Monto' => $monto,
                    'MontoEntero' => $monto_entero,
                    'Centavos' => $centavos
            ];
        $datosGrafica = ['Conteo' => $conteo,'Labels' => $labels];
        $respuesta = ['DatosGrafica' => $datosGrafica,'DatosCitas' => $datosCitas,'TopProcedimientos' => $this->obtenerResultadosVentas($diasFinal,$id_suscripcion)];
        if(!empty($strQuery)){
            $respuesta['strQuery'] = $strQuery;
        }
        return $respuesta;
    }
    
    private function obtenerResultadosVentas($diasFinal,$id_suscripcion){
        $now = \date('Y-m-d');
        $db = Cita::getDb();
        $sqlStr1 = 'SELECT p.nombre,COUNT(*) total FROM cita c
                    INNER JOIN procedimiento_cita pc ON  pc.id_cita = c.id
                    INNER JOIN procedimiento p ON p.id = pc.id_procedimiento
                    WHERE (c.id_suscripcion = ' . $id_suscripcion . ')
                        AND (DATE(c.fecha) BETWEEN DATE_ADD(\'' . $now . '\',INTERVAL -' . $diasFinal . ' DAY) AND DATE_ADD(\'' . $now . '\',INTERVAL -1 DAY)) 
                        AND (c.estado = ' . Cita::COMPLETADA . ')
                    GROUP BY p.nombre
                    ORDER BY 2 DESC';
        $rest1 = $db->createCommand($sqlStr1)->queryAll();
        $sqlStr2 = 'SELECT T.nombre, T.total*pp.costo venta, T.ventaSumProc ventaSum FROM(
                        SELECT p.id,p.nombre,COUNT(*) total, SUM(pc.costo_editado) ventaSumProc FROM cita c
                        INNER JOIN procedimiento_cita pc ON  pc.id_cita = c.id
                        INNER JOIN procedimiento p ON p.id = pc.id_procedimiento
                        WHERE (c.id_suscripcion = ' . $id_suscripcion . ')
                            AND (DATE(c.fecha) BETWEEN DATE_ADD(\'' . $now . '\',INTERVAL -' . $diasFinal . ' DAY) AND DATE_ADD(\'' . $now . '\',INTERVAL -1 DAY))
                            AND (c.estado = ' . Cita::COMPLETADA . ')
                        GROUP BY p.nombre,p.id
                    )T
                    INNER JOIN procedimiento pp ON pp.id = T.id
                    ORDER BY 2 DESC';
        $rest2 = $db->createCommand($sqlStr2)->queryAll();
        return ['Top' => $rest1, 'Ventas' => $rest2];
    }
    
    
    public function actionExcelCitas(){
        $this->layout = false;
        $fileName = date('Y_m_d').'_'.date('H:i:s').'_Citas-Seleccionadas'.'.xls';
        $post = Yii::$app->request->post();
        $opt = $post['optradio'];
        $estado = $post['estado'];
        $semanaFechaI = \DateTime::createFromFormat('d/m/Y', $post['fecha-inicio-semana'])->format('Y-m-d'); 
        $semanaFechaF = \DateTime::createFromFormat('d/m/Y',$post['fecha-fin-semana'])->format('Y-m-d'); 
        $customFechaI = \DateTime::createFromFormat('d/m/Y', $post['fecha-inicio-semana-c'])->format('Y-m-d'); //custom date inicio        
        $customFechaF = \DateTime::createFromFormat('d/m/Y', $post['fecha-fin-semana-c'])->format('Y-m-d'); //custom date fin
        Yii::$app->response->getHeaders()->add('Content-Type',  'application/vnd.ms-excel; charset=utf-8');        
        Yii::$app->response->getHeaders()->add('Content-Disposition', 'attachment; filename='.$fileName);
        $usuario = \Yii::$app->user->identity;
        $id_suscripcion = $usuario->suscripcion->id;
        $model = Cita::find()->where(['id_suscripcion' => $id_suscripcion]);
        if( $usuario->suscripcion->tipo == \app\models\Suscripcion::TIPO_JERARQUIZADA ){
            $model->andWhere(['id_clinica' => SesionUtils::ClinicaSeleccionada()->id]);
        } 
        if ( $opt == 'week' ){
            switch ( $estado ){
                case '-1'://todos los estados
                $model->andWhere(['between','fecha', $semanaFechaI, new Expression('DATE_ADD(\''.$semanaFechaF.'\', INTERVAL +1 DAY)') ]);   
                break;
                default:
                $model->andWhere(['estado'=>$estado])
                    ->andWhere(['between','fecha', $semanaFechaI, new Expression('DATE_ADD(\''.$semanaFechaF.'\', INTERVAL +1 DAY)') ]);
                break;
            }
        } else { 
            switch ( $estado ){
                case '-1'://todos los estados
                $model->andWhere(['between','fecha', $customFechaI, new Expression('DATE_ADD(\''.$customFechaF.'\', INTERVAL +1 DAY)')]);
                break;
                default:
                $model->andWhere(['estado'=>$estado])
                    ->andWhere(['between','fecha', $customFechaI, new Expression('DATE_ADD(\''.$customFechaF.'\', INTERVAL +1 DAY)')]);
                break;
            }
            
        }    
        return $this->render( 'excel-citas', [ 'model'=>$model->orderBy(['fecha'=>SORT_ASC])->all() ] );
    }
    
    public function actionPacientesXls(){
        $fileName = date('Y_m_d').'_'.date('H:i:s').'_Pacientes'.'.xls';
        $this->layout = false;
        Yii::$app->response->getHeaders()->add('Content-Type',  'application/vnd.ms-excel; charset=utf-8');        
        Yii::$app->response->getHeaders()->add('Content-Disposition', 'attachment; filename='.$fileName);
        $usuario = \Yii::$app->user->identity;
        $id_suscripcion = $usuario->suscripcion->id;
        $model = Paciente::find()->where(['id_suscripcion'=>$id_suscripcion]);
        if( $usuario->suscripcion->tipo == \app\models\Suscripcion::TIPO_JERARQUIZADA ){
            $model->andWhere(['id_clinica' => SesionUtils::ClinicaSeleccionada()->id]);
        } 
        return $this->render('excel-pacientes',['model'=>$model->all()]);
    }
      
    public function actionAgendaPdf($fe){
        Yii::$app->response->format = \yii\web\Response::FORMAT_RAW;
        $meses = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
        $usuario = \Yii::$app->user->identity;
        $date = date('Y-m-d');
        list($d,$m,$y) = explode('-', $date);
        $fechaEncabezado = $d." de ".$meses[$m - 1]." del " .$y;
        if(isset($fe) && $fe != 0 ){
            $date = \DateTime::createFromFormat('d/m/Y', $fe)->format('Y-m-d');
            list($d,$m,$y) = explode('-', $date);
            $fechaEncabezado = $d." de ".$meses[$m - 1]." del " .$y;
        }  
        $agenda = ArrayHelper::merge($this->obtenerCitas($usuario,$date), $this->obtenerEventos($usuario,$date));
        $agenda = ArrayHelper::merge($agenda, $this->obtenerRecordatorios($usuario,$date));
        asort($agenda);
        $pdf = new Pdf([
            'mode' => '', 
            'destination' => Pdf::DEST_BROWSER,
            'content' => $this->renderPartial('agendaPdf',['agenda'=>$agenda, 'fecha'=>$fechaEncabezado]),
            'cssFile' => '../web/css/agendaPdf.css',
            'options' => [
            ],
            'methods' => [
                'SetTitle' => 'Agenda Díaria - oliviahealth.com',
                'SetSubject' => 'Agenda Personal',
                'SetHeader' => ['Olivia Health||Generado en: ' . date("d-m-Y")],
                'SetFooter' => ['|Pag {PAGENO}|'],
                'SetAuthor' => 'OliviaHealth',
                'SetCreator' => 'OliviaHealth',
                'SetKeywords' => '',
            ]
        ]);
        return $pdf->render();
    }
      
    public function actionImprimirCita($id_cita){
        
        Yii::$app->response->format = \yii\web\Response::FORMAT_RAW;
        $meses = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
        $usuario = \Yii::$app->user->identity;
        $model = Cita::find()
                ->where(['id'=>$id_cita, 'id_suscripcion' => $usuario->suscripcion->id])
                ->one();
        $f = explode('/', $model->fecha);
        $fechacita = $f[0]." de ".$meses[$f[1] - 1]." del " .explode(' ',$f[2])[0];
        $pdf = new Pdf([
            'mode'=>'',
            'destination'=> Pdf::DEST_BROWSER,
            'content' => $this->renderPartial('imprimir-cita', ['model'=>$model, 'fechaCita'=>$fechacita]),
            'cssFile' => '../web/css/agendaPdf.css',
            'options' => [
            ],
            'methods' => [
                'SetTitle' => 'Agenda Díaria - oliviahealth.com',
                'SetSubject' => 'Agenda Personal',
                'SetHeader' => ['Olivia Health||Cita del día: ' . date("d/m/Y")],
                'SetAuthor' => 'OliviaHealth',
                'SetCreator' => 'OliviaHealth',
                'SetKeywords' => '',
            ]           
        ]);
        
        return $pdf->render();
    }
    
    
    /**
     * 
     * @param app\models\Usuario $usuario
     * @param string $date 
     * @return Array
     */
    private function obtenerCitas($usuario,$date){
        $qCitas = Cita::find()->where(['id_suscripcion' => $usuario->suscripcion->id])
            ->andWhere(['date(fecha)' => new Expression('date(\'' . $date . '\')')])
            ->andWhere(['or',['estado' => Cita::AGENDADA],['estado' => Cita::CONFIRMADA],['estado' => Cita::REPROGRAMADA]]);
        if($usuario->tipo == Usuario::ASISTENTE){
            $qCitas->andWhere(['id_clinica' => SesionUtils::ClinicaSeleccionada()->id]);
        }
        $citas = $qCitas->all();
        $result = [];
        $titulo = '';
        foreach($citas as $cita){
            $fecha = \DateTime::createFromFormat('d/m/Y H:i', $cita->fecha)->format('Y-m-d H:i');
            $titulo = 'Cita con ' . $cita->paciente->nombreCorto;
            $hora_inicial = strtotime($fecha);
            $addMinutos = $cita->tiempo_estimado*60;
            $hora_fin = date('g:iA', $hora_inicial+$addMinutos);
            $result[] = [
                    'fecha' => $cita->fecha,
                    'date' => strtotime($fecha),
                    'titulo' => $titulo,
                    'procedimientos' => $cita->procedimientosAplicadosStr,
                    'diagnostico' => $cita->diagnostico == '' ? 'No definido' : $cita->diagnostico,
                    'tipo' => 'cita',
                    'tiempo' => date('g:iA',strtotime($fecha)).' - '.$hora_fin,
            ];
        }
        return $result;
    }
    
    
    /**
     * 
     * @param app\models\Usuario $usuario
     * @param string $date 
     * @return Array
     */
    private function obtenerEventos($usuario,$date){
        $qEventos = Evento::find()->where(['id_suscripcion' => $usuario->suscripcion->id])
            ->andWhere(['date(fecha_inicio)' => new Expression('date(\'' . $date . '\')')]);
        if($usuario->tipo == Usuario::ASISTENTE){
            $qEventos->andWhere(['id_suscripcion' => SesionUtils::ClinicaSeleccionada()->id]);
        }
        $eventos = $qEventos->all();
        $titulo = '';
        $result = [];
        foreach ($eventos as $evento){
            $fecha = \DateTime::createFromFormat('d/m/Y H:i', $evento->fecha_inicio)->format('Y-m-d H:i');
            $fechaFin = \DateTime::createFromFormat('d/m/Y H:i', $evento->fecha_fin)->format('Y-m-d H:i');
            $titulo = 'Evento '.$evento->nombre.' desde '.date('g:iA',strtotime($fecha)). ' hasta '.date('d/m/Y g:iA',strtotime($fechaFin))."\n";
            if(strtotime(explode(' ', $fecha)[0] ) ==  strtotime(explode(' ', $fechaFin)[0]) ) {
                $T = date('g:iA',strtotime($fecha)).'-'.date('g:iA',strtotime($fechaFin));
            }else {
                $T = date('g:iA',strtotime($fecha));
            }
            $result[] = [
                'fecha' => $evento->fecha_inicio,
                'date' => strtotime($fecha),
                'titulo' => $titulo,
                'procedimientos' => null,
                'diagnostico' => null,
                'tipo' => 'evento',
                'tiempo' => $T,
            ];
            
        }
        
        return $result;
    }
    
    /**
     * 
     * @param objet app\models\Usuario $usuario
     * @param string $date  
     * @return Array
     */
    private function obtenerRecordatorios($usuario,$date){
        $qRecordatorios = RecordatorioDoctor::find()->where(['id_suscripcion' => $usuario->suscripcion->id])
            ->andWhere(['date(fecha_inicio)' => new Expression('date(\'' . $date . '\')')]);
        $recordatorios = $qRecordatorios->all();
        $titulo = '';
        $result = [];
        foreach ($recordatorios as $recordatorio){
            $fecha = \DateTime::createFromFormat('d/m/Y H:i', $recordatorio->fecha_inicio)->format('Y-m-d H:i');      
            $titulo = ( ($usuario->tipo == Usuario::ASISTENTE && $recordatorio->privacidad ) ? 'Recordatorio privado' :  'Recordatorio: '.$recordatorio->asunto);
            $result[] = [
                'fecha'  => $recordatorio->fecha_inicio,
                'date'   => strtotime($fecha),
                'titulo' => $titulo,
                'procedimientos' => null,
                'diagnostico' => null,
                'tipo'   => 'recordatorio-doctor',
                'tiempo' => date('g:iA',strtotime($fecha)),
            ];
            
        }
        
        return $result;
    }
    
    
    
    /// REPORTES UNIS
    public function actionPacientesPorGrupo(){
        
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        
        $post = Yii::$app->request->post();
        
        
        $fechaHasta = isset($post['fechaHasta']) ?  \DateTime::createFromFormat('d/m/Y', $post['fechaHasta'])->format('Y-m-d') : date('Y-m-d');
        
        $sqlStr = "CALL spReportePacientePorGrupo(" . $suscripcion->id . ",'" . $fechaHasta . "')";
        $resultado = \yii::$app->db->createCommand($sqlStr)->queryAll();
        
        return $this->render('pacientes-por-grupo',[
            'resultado'=> $resultado,
            'fechaHasta' => $fechaHasta
     
        ]);
    }
    
    public function actionPacientesPorEstado(){
        
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        
        $post = Yii::$app->request->post();
        $grupos = GrupoTrabajo::find()->where(['id_suscripcion' => $suscripcion->id])->orderBy('nombre')->all();
        $fechaHasta = isset($post['fechaHasta']) ?  \DateTime::createFromFormat('d/m/Y', $post['fechaHasta'])->format('Y-m-d') : date('Y-m-d');
        $idGrupo = isset($post['idGrupo']) ? $post['idGrupo'] : $grupos[0]->id;
        $sqlStr = "CALL spReportePacientePorEstado(" . $suscripcion->id . "," . $idGrupo . ",'" . $fechaHasta . "')";
        $resultado = \yii::$app->db->createCommand($sqlStr)->queryAll();
        
        return $this->render('pacientes-por-estado',[
            'resultado'=> $resultado,
            'fechaHasta' => $fechaHasta,
            'grupos' => ArrayHelper::map($grupos,'id','nombre'),
            'idGrupo' => $idGrupo
     
        ]);
    }
    
    
    public function actionPacientesUnis(){
        
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        
        $post = Yii::$app->request->post();

        

        $grupos = GrupoTrabajo::find()->where(['id_suscripcion' => $suscripcion->id])->orderBy('nombre')->all();
        $arrayGrupos = ArrayHelper::map($grupos,'id','nombre');
        $arrayIdsGrupo = [];
        foreach ($arrayGrupos as $key => $value) {
            //$arrayIdsGrupo;
            $arrayIdsGrupo[] = $key;
            
        }
        $listIdsGrupos =  implode(',',$arrayIdsGrupo);

        $fecha_actual = date("Y-m-d");

        $fechaHasta = isset($post['fechaHasta']) ?  \DateTime::createFromFormat('d/m/Y', $post['fechaHasta'])->format('Y-m-d') : date('Y-m-d');
        $fechaDesde = isset($post['fechaDesde']) ?  \DateTime::createFromFormat('d/m/Y', $post['fechaDesde'])->format('Y-m-d') : date("Y-m-d",strtotime($fecha_actual."- 1 month"));
         
        $grupoIs = true; //(isset($post['grupos'])) ? true : false;
        $idGrupo = isset($post['idGrupo']) ? $post['idGrupo'] : $grupos[0]->id;
        $idGrupos = isset($post['grupos']) ? implode(',', $post['grupos']) : $listIdsGrupos;
                    
        $idGruposSelected = (is_null($post['grupos']))? $arrayIdsGrupo :  $post['grupos'];
        

        #$sqlStr = "CALL spReportePacientePorEstado(" . $suscripcion->id . ",'" . $idGrupos . "','" . $fechaHasta . "','" . $fechaDesde . "')";
        #$resultadoEstados = \yii::$app->db->createCommand($sqlStr)->queryAll();

        $sqlStr = "CALL spReportePacientePorProcedencia(" . $suscripcion->id . "," . $idGrupo . ",'" . $fechaHasta . "')";
        $resultadoProcedencias = \yii::$app->db->createCommand($sqlStr)->queryAll();

            
        $resultadoGrupos= $this->resultadosGrupos($suscripcion->id,$idGrupos,$fechaDesde,$fechaHasta);
        $resultadoGruposTotal= $this->resultadosGrupos($suscripcion->id,$idGrupos,$fechaDesde,$fechaHasta,false);
        
        $resultadoSexos= $this->resultadoSexos($suscripcion->id,$idGrupos,$fechaDesde,$fechaHasta);
        $resultadoSexosTotal= $this->resultadoSexos($suscripcion->id,$idGrupos,$fechaDesde,$fechaHasta,false);
        
        $resultadoEstados = $this->resultadoEstados($suscripcion->id,$idGrupos,$fechaDesde,$fechaHasta);
        $resultadoEstadosTotal = $this->resultadoEstados($suscripcion->id,$idGrupos,$fechaDesde,$fechaHasta,false);

        $resultadoEdad = $this->resultadoEdades($suscripcion->id,$idGrupos,$fechaDesde,$fechaHasta);
        $resultadoEdadTotal = $this->resultadoEdades($suscripcion->id,$idGrupos,$fechaDesde,$fechaHasta,false);

        $resultadoTipoCita = $this->resultadoTipoCita($suscripcion->id,$idGrupos,$fechaDesde,$fechaHasta);
        $resultadoTipoCitaTotal = $this->resultadoTipoCita($suscripcion->id,$idGrupos,$fechaDesde,$fechaHasta,false);

        $resultadoNivelSocial = $this->resultadoNivelSocial($suscripcion->id,$idGrupos,$fechaDesde,$fechaHasta);
        $resultadoNivelSocialTotal = $this->resultadoNivelSocial($suscripcion->id,$idGrupos,$fechaDesde,$fechaHasta,false);

        $resultadoPorProcedimiento = $this->resultadoProcedimiento($suscripcion->id,$idGrupos,$fechaDesde,$fechaHasta);
        $resultadoPorProcedimientoTotal = $this->resultadoProcedimiento($suscripcion->id,$idGrupos,$fechaDesde,$fechaHasta,false);

        //var_dump($resultadoPorProcedimientoTotal); exit();
        
        return $this->render('pacientes-unis',[
            'resultadoEstados'      => $resultadoEstados,
            'resultadoEstadosTotal'      => $resultadoEstadosTotal,
            'resultadoGrupos'       => $resultadoGrupos,
            'resultadoGruposTotal'  => $resultadoGruposTotal,
            'resultadoEdad'         => $resultadoEdad,
            'resultadoEdadTotal'    => $resultadoEdadTotal,
            'resultadoSexos'        => $resultadoSexos,
            'resultadoSexosTotal'   => $resultadoSexosTotal,
            'resultadoTipoCita'     => $resultadoTipoCita,
            'resultadoTipoCitaTotal'=> $resultadoTipoCitaTotal,
            'resultadoNivelSocial'  => $resultadoNivelSocial,
            'resultadoNivelSocialTotal'  => $resultadoNivelSocialTotal,
            'resultadoProcedencias' => $resultadoProcedencias,
            'resultadoPorProcedimiento' => $resultadoPorProcedimiento,
            'resultadoPorProcedimientoTotal' => $resultadoPorProcedimientoTotal,
            'fechaHasta'            => $fechaHasta,
            'fechaDesde'            => $fechaDesde,
            'grupos'                => ArrayHelper::map($grupos,'id','nombre'),
            'idGrupos'               => $idGruposSelected,
            'grupoIs'               => $grupoIs,

     
        ]);
    }
    
    
    private function resultadosGrupos($suscripcion_id,$idGrupo,$fechaDesde,$fechaHasta,$group_by = true){
        if($group_by){
                $sqlStr = "SELECT 
                            COUNT(T.id) cantidad,
                            T.nombre_grupo as nombre
                        FROM
                            (SELECT 
                                p.id,
                                gt.nombre as nombre_grupo,            
                                    (SELECT 
                                            fecha
                                        FROM
                                            bitacora_paciente bp
                                        WHERE
                                            bp.id_paciente = p.id
                                                AND (bp.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')
                                        ORDER BY fecha DESC
                                        LIMIT 1) fecha
                            FROM
                                paciente p
                            INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id
                            WHERE
                                p.id_suscripcion = '".$suscripcion_id."'
                                    AND gt.id_suscripcion = '".$suscripcion_id."'
                                    AND FIND_IN_SET(p.id_grupo, '".$idGrupo."')) T
                        WHERE
                            (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."') 
                            GROUP BY T.nombre_grupo";
            $resultadoGrupos = \yii::$app->db->createCommand($sqlStr)->queryAll();
            
            return $resultadoGrupos;
        }else{
            $gruposArray = explode(',',$idGrupo);
            $total = [];
            
            foreach($gruposArray as $grupo){
                $grupoArray = GrupoTrabajo::find($grupo)->where(['id' => $grupo])->orderBy('nombre')->one();
                 

                $sqlStr = "SELECT 
                            COUNT(T.id) cantidad,
                            T.nombre_grupo as nombre
                        FROM
                            (SELECT 
                                p.id,
                                gt.nombre as nombre_grupo,            
                                    (SELECT 
                                            fecha
                                        FROM
                                            bitacora_paciente bp
                                        WHERE
                                            bp.id_paciente = p.id
                                                AND (bp.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')
                                        ORDER BY fecha DESC
                                        LIMIT 1) fecha
                            FROM
                                paciente p
                            INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id
                            WHERE
                                p.id_suscripcion = '".$suscripcion_id."'
                                    AND gt.id_suscripcion = '".$suscripcion_id."'
                                    AND p.id_grupo = '".$grupo."') T
                        WHERE
                            (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')";

                $resultadoGrupos = \yii::$app->db->createCommand($sqlStr)->queryAll();
                foreach($resultadoGrupos as $g){
                    $total[]=[
                        'nombre'=>$grupoArray->nombre,
                        'cantidad'=>$g['cantidad']
                    ];
                }
            }
            return $total;
        }
    }

    private function resultadoSexos($suscripcion_id,$idGrupos,$fechaDesde,$fechaHasta,$group_by = true){
        if($group_by){
            $sql_por_sexo = "SELECT COUNT(T.id) cantidad, IF(sexo='m','Masculino','Femenino') as sexo FROM (SELECT p.id, p.sexo, (SELECT fecha FROM bitacora_paciente bp WHERE bp.id_paciente = p.id AND (bp.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."') ORDER BY fecha DESC LIMIT 1) fecha FROM paciente p INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id WHERE p.id_suscripcion = '".$suscripcion_id."'AND gt.id_suscripcion = '".$suscripcion_id."'AND FIND_IN_SET(p.id_grupo, '".$idGrupos."')) T WHERE (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."') AND sexo is not null AND sexo <> ''GROUP BY sexo";
            $resultadoSexos= \yii::$app->db->createCommand($sql_por_sexo)->queryAll();
            
            return $resultadoSexos;
        }else{
            $gruposArray = explode(',',$idGrupos);
            $total = [];

            foreach($gruposArray as $grupo){

                $cantidad_masculino  = 0;
                $cantidad_femenino  = 0;
                $grupoArray = GrupoTrabajo::find($grupo)->where(['id' => $grupo])->orderBy('nombre')->one();
                
                $sqlStr_masculino = "SELECT COUNT(T.id) cantidad, IF(sexo='m','Masculino','Femenino') as sexo FROM (SELECT p.id, p.sexo, (SELECT fecha FROM bitacora_paciente bp WHERE bp.id_paciente = p.id AND (bp.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."') ORDER BY fecha DESC LIMIT 1) fecha FROM paciente p INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id WHERE p.id_suscripcion = '".$suscripcion_id."'AND gt.id_suscripcion = '".$suscripcion_id."'AND p.id_grupo = '".$grupo."') T WHERE (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."') AND sexo is not null AND sexo <> ''AND sexo = 'm'GROUP BY sexo";

                $resultadoGrupos = \yii::$app->db->createCommand($sqlStr_masculino)->queryAll();

                foreach($resultadoGrupos as $g){                   

                    $cantidad_masculino = $g['cantidad'];
                }

                $sqlStr_femenino = "SELECT COUNT(T.id) cantidad, IF(sexo='m','Masculino','Femenino') as sexo FROM (SELECT p.id, p.sexo, (SELECT fecha FROM bitacora_paciente bp WHERE bp.id_paciente = p.id AND (bp.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."') ORDER BY fecha DESC LIMIT 1) fecha FROM paciente p INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id WHERE p.id_suscripcion = '".$suscripcion_id."'AND gt.id_suscripcion = '".$suscripcion_id."'AND p.id_grupo = '".$grupo."') T WHERE (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."') AND sexo is not null AND sexo <> ''AND sexo <> 'm'GROUP BY sexo";

                $resultadoGrupos = \yii::$app->db->createCommand($sqlStr_femenino)->queryAll();

                foreach($resultadoGrupos as $g){
                    
                    $cantidad_femenino = $g['cantidad'];
                }

                $total[$grupoArray->nombre]=array([
                        'sexo'      =>'Masculino',
                        'cantidad'  => $cantidad_masculino
                    ],[
                        'sexo'      =>'Femenino',
                        'cantidad'  =>$cantidad_femenino
                    ] );

            }

            return $total;
        }
    }

    private function resultadoEstados($suscripcion_id,$idGrupos,$fechaDesde,$fechaHasta,$group_by = true){
        if($group_by){
            $sql_estados = "SELECT 
                        COUNT(T.id) cantidad, estado
                    FROM
                        (SELECT 
                        p.id,
                            IFNULL((SELECT 
                                    estado
                                FROM
                                    bitacora_paciente bp
                                WHERE
                                    bp.id_paciente = p.id
                                        AND bp.fecha BETWEEN  '".$fechaDesde."' AND '".$fechaHasta."'
                                ORDER BY fecha DESC
                                LIMIT 1), 5) estado,
                            (SELECT 
                                    fecha
                                FROM
                                    bitacora_paciente bp
                                WHERE
                                    bp.id_paciente = p.id
                                        AND bp.fecha BETWEEN  '".$fechaDesde."' AND '".$fechaHasta."'
                                ORDER BY fecha DESC
                                LIMIT 1) fecha
                    FROM
                        paciente p
                    INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id
                    WHERE
                        p.id_suscripcion = '".$suscripcion_id."'
                            AND gt.id_suscripcion = '".$suscripcion_id."'
                            AND FIND_IN_SET(p.id_grupo, '".$idGrupos."')
                         
                        ) T
                    WHERE    
                         (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."') 
                         AND T.estado <> 5
                    GROUP BY T.estado";

                      

            $resultadoSexos= \yii::$app->db->createCommand($sql_estados)->queryAll();
            
            return $resultadoSexos;

        }else{
            $gruposArray = explode(',',$idGrupos);
            $total = [];

            
            
            foreach($gruposArray as $grupo){
                $cantidad_en_espera  = 0;
                $cantidad_activo = 0;

                $grupoArray = GrupoTrabajo::find($grupo)->where(['id' => $grupo])->orderBy('nombre')->one();
                 
                $sql_en_espera = "SELECT 
                        COUNT(T.id) cantidad, estado
                    FROM
                        (SELECT 
                        p.id,
                            IFNULL((SELECT 
                                    estado
                                FROM
                                    bitacora_paciente bp
                                WHERE
                                    bp.id_paciente = p.id
                                        AND bp.fecha BETWEEN  '".$fechaDesde."' AND '".$fechaHasta."'
                                ORDER BY fecha DESC
                                LIMIT 1), 5) estado,
                            (SELECT 
                                    fecha
                                FROM
                                    bitacora_paciente bp
                                WHERE
                                    bp.id_paciente = p.id
                                        AND bp.fecha BETWEEN  '".$fechaDesde."' AND '".$fechaHasta."'
                                ORDER BY fecha DESC
                                LIMIT 1) fecha
                    FROM
                        paciente p
                    INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id
                    WHERE
                        p.id_suscripcion = '".$suscripcion_id."'
                            AND gt.id_suscripcion = '".$suscripcion_id."'
                            AND p.id_grupo = '".$grupo."'
                         
                        ) T
                    WHERE    
                         (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."') 
                         AND T.estado = 1
                    GROUP BY T.estado";

                $resultadoGrupos = \yii::$app->db->createCommand($sql_en_espera)->queryAll();

                foreach($resultadoGrupos as $g){                   
                    $cantidad_en_espera = $g['cantidad'];
                }

                $sql_activo = "SELECT 
                        COUNT(T.id) cantidad, estado
                    FROM
                        (SELECT 
                        p.id,
                            IFNULL((SELECT 
                                    estado
                                FROM
                                    bitacora_paciente bp
                                WHERE
                                    bp.id_paciente = p.id
                                        AND bp.fecha BETWEEN  '".$fechaDesde."' AND '".$fechaHasta."'
                                ORDER BY fecha DESC
                                LIMIT 1), 5) estado,
                            (SELECT 
                                    fecha
                                FROM
                                    bitacora_paciente bp
                                WHERE
                                    bp.id_paciente = p.id
                                        AND bp.fecha BETWEEN  '".$fechaDesde."' AND '".$fechaHasta."'
                                ORDER BY fecha DESC
                                LIMIT 1) fecha
                    FROM
                        paciente p
                    INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id
                    WHERE
                        p.id_suscripcion = '".$suscripcion_id."'
                            AND gt.id_suscripcion = '".$suscripcion_id."'
                            AND p.id_grupo = '".$grupo."'
                         
                        ) T
                    WHERE    
                         (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."') 
                         AND T.estado = 0
                    GROUP BY T.estado";

                $resultadoGrupos = \yii::$app->db->createCommand($sql_activo)->queryAll();

                foreach($resultadoGrupos as $g){                   
                    $cantidad_activo = $g['cantidad'];
                }


                  $total[$grupoArray->nombre]=array([
                        'estado'      =>'Activo',
                        'cantidad'  => $cantidad_activo
                    ],[
                        'estado'      =>'En Espera',
                        'cantidad'  =>$cantidad_en_espera
                    ] );
            }

            return $total;
        }
    }

    private function resultadoEdades($suscripcion_id,$idGrupos,$fechaDesde,$fechaHasta,$group_by = true){
        
        if($group_by){
           
            $sql_edad = "SELECT 
                            COUNT(T.id) cantidad,
                            IFNULL(TIMESTAMPDIFF(YEAR,
                                    T.fecha_nacimiento,
                                    CURDATE()),
                                '-') AS edad
                        FROM
                            (SELECT 
                                p.id,
                                p.fecha_nacimiento,             
                                    (SELECT 
                                            fecha
                                        FROM
                                            bitacora_paciente bp
                                        WHERE
                                            bp.id_paciente = p.id
                                                AND (bp.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')
                                        ORDER BY fecha DESC
                                        LIMIT 1) fecha
                            FROM
                                paciente p
                            INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id
                            WHERE
                                p.id_suscripcion = '".$suscripcion_id."'
                                    AND gt.id_suscripcion = '".$suscripcion_id."'
                                    AND FIND_IN_SET(p.id_grupo, '".$idGrupos."')) T
                        WHERE
                            (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."') 
                            GROUP BY edad";


              //var_dump($sql_edad);            

            $resultadoEdades= \yii::$app->db->createCommand($sql_edad)->queryAll();
            
            return $resultadoEdades;

        }else{
            $gruposArray = explode(',',$idGrupos);
            $total = [];
            
            
            foreach($gruposArray as $grupo){
                $cantidad_de_0_a_10  = 0;
                $cantidad_de_10_a_20  = 0;
                $cantidad_de_20_a_30  = 0;
                $cantidad_de_30_a_40  = 0;
                $grupoArray = GrupoTrabajo::find($grupo)->where(['id' => $grupo])->orderBy('nombre')->one();
                $sql_edad = " SELECT 
                                COUNT(T.id) cantidad,
                                T.edad
                                    FROM
                                        (SELECT 
                                            p.id,
                                           IFNULL(TIMESTAMPDIFF(YEAR,
                                                p.fecha_nacimiento,
                                                CURDATE()),
                                            '-') AS edad,            
                                                (SELECT 
                                                        fecha
                                                    FROM
                                                        bitacora_paciente bp
                                                    WHERE
                                                        bp.id_paciente = p.id
                                                            AND (bp.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')
                                                    ORDER BY fecha DESC
                                                    LIMIT 1) fecha
                                        FROM
                                            paciente p
                                        INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id
                                        WHERE
                                            p.id_suscripcion = '".$suscripcion_id."'
                                                AND gt.id_suscripcion = '".$suscripcion_id."'
                                                AND p.id_grupo = '".$grupo."') T
                                    WHERE
                                        (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')  
                                        AND (T.edad BETWEEN 0 AND 10) 
                                        GROUP BY  T.edad";
                           
                $resultadoGrupos = \yii::$app->db->createCommand($sql_edad)->queryAll(); 

                              
                foreach($resultadoGrupos as $gru){
                    $cantidad_de_0_a_10 = $cantidad_de_0_a_10 + intval($gru['cantidad']);
                }


                $sql_edad = " SELECT 
                                COUNT(T.id) cantidad,
                                T.edad
                                    FROM
                                        (SELECT 
                                            p.id,
                                           IFNULL(TIMESTAMPDIFF(YEAR,
                                                p.fecha_nacimiento,
                                                CURDATE()),
                                            '-') AS edad,            
                                                (SELECT 
                                                        fecha
                                                    FROM
                                                        bitacora_paciente bp
                                                    WHERE
                                                        bp.id_paciente = p.id
                                                            AND (bp.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')
                                                    ORDER BY fecha DESC
                                                    LIMIT 1) fecha
                                        FROM
                                            paciente p
                                        INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id
                                        WHERE
                                            p.id_suscripcion = '".$suscripcion_id."'
                                                AND gt.id_suscripcion = '".$suscripcion_id."'
                                                AND p.id_grupo = '".$grupo."') T
                                    WHERE
                                        (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')  
                                        AND (T.edad BETWEEN 11 AND 20) 
                                        GROUP BY  T.edad";
                           
                $resultadoGrupos = \yii::$app->db->createCommand($sql_edad)->queryAll(); 

                              
                foreach($resultadoGrupos as $gru){
                    $cantidad_de_10_a_20 = $cantidad_de_10_a_20 + intval($gru['cantidad']);
                }


                $sql_edad = " SELECT 
                                COUNT(T.id) cantidad,
                                T.edad
                                    FROM
                                        (SELECT 
                                            p.id,
                                           IFNULL(TIMESTAMPDIFF(YEAR,
                                                p.fecha_nacimiento,
                                                CURDATE()),
                                            '-') AS edad,            
                                                (SELECT 
                                                        fecha
                                                    FROM
                                                        bitacora_paciente bp
                                                    WHERE
                                                        bp.id_paciente = p.id
                                                            AND (bp.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')
                                                    ORDER BY fecha DESC
                                                    LIMIT 1) fecha
                                        FROM
                                            paciente p
                                        INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id
                                        WHERE
                                            p.id_suscripcion = '".$suscripcion_id."'
                                                AND gt.id_suscripcion = '".$suscripcion_id."'
                                                AND p.id_grupo = '".$grupo."') T
                                    WHERE
                                        (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')  
                                        AND (T.edad BETWEEN 21 AND 30) 
                                        GROUP BY  T.edad";
                           
                $resultadoGrupos = \yii::$app->db->createCommand($sql_edad)->queryAll(); 

                              
                foreach($resultadoGrupos as $gru){
                    $cantidad_de_20_a_30 = $cantidad_de_20_a_30 + intval($gru['cantidad']);
                }

                $sql_edad = " SELECT 
                                COUNT(T.id) cantidad,
                                T.edad
                                    FROM
                                        (SELECT 
                                            p.id,
                                           IFNULL(TIMESTAMPDIFF(YEAR,
                                                p.fecha_nacimiento,
                                                CURDATE()),
                                            '-') AS edad,            
                                                (SELECT 
                                                        fecha
                                                    FROM
                                                        bitacora_paciente bp
                                                    WHERE
                                                        bp.id_paciente = p.id
                                                            AND (bp.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')
                                                    ORDER BY fecha DESC
                                                    LIMIT 1) fecha
                                        FROM
                                            paciente p
                                        INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id
                                        WHERE
                                            p.id_suscripcion = '".$suscripcion_id."'
                                                AND gt.id_suscripcion = '".$suscripcion_id."'
                                                AND p.id_grupo = '".$grupo."') T
                                    WHERE
                                        (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')  
                                        AND (T.edad BETWEEN 31 AND 40) 
                                        GROUP BY  T.edad";
                           
                $resultadoGrupos = \yii::$app->db->createCommand($sql_edad)->queryAll(); 

                              
                foreach($resultadoGrupos as $gru){
                    $cantidad_de_30_a_40 = $cantidad_de_30_a_40 + intval($gru['cantidad']);
                }
                
                

                    $total[$grupoArray->nombre]=array([
                        'grupo'=>'De 0 a 10 años',
                        'cantidad'  => $cantidad_de_0_a_10
                    ],[
                        'grupo'=>'De 10 a 20 años',
                        'cantidad'  =>$cantidad_de_10_a_20
                    ],[
                        'grupo'=>'De 20 a 30 años',
                        'cantidad'  =>$cantidad_de_20_a_30
                    ],[
                        'grupo'=>'De 30 a 40 años',
                        'cantidad'  =>$cantidad_de_30_a_40
                    ] );

            }
            return $total;
        }
    }

    private function resultadoTipoCita($suscripcion_id,$idGrupos,$fechaDesde,$fechaHasta,$group_by = true){
        if($group_by){
            $sql_tipo_cita = "SELECT 
                            COUNT(T.id) cantidad,
                            IF(T.tipo_cita>0,'En Linea','Presencial') as tipo_cita
                        FROM
                            (SELECT 
                                p.id,
                                 ci.tipo_cita,             
                                    (SELECT 
                                            fecha
                                        FROM
                                            bitacora_paciente bp
                                        WHERE
                                            bp.id_paciente = p.id
                                                AND (bp.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')
                                        ORDER BY fecha DESC
                                        LIMIT 1) fecha
                            FROM
                                paciente p
                            INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id
                            INNER JOIN cita ci ON p.id = ci.id_paciente
                            WHERE
                                p.id_suscripcion = '".$suscripcion_id."'
                                    AND gt.id_suscripcion = '".$suscripcion_id."'
                                    AND FIND_IN_SET(p.id_grupo, '".$idGrupos."')) T
                        WHERE
                            (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."') 
                            GROUP BY tipo_cita";

                      

            $resultadoTipoCita= \yii::$app->db->createCommand($sql_tipo_cita)->queryAll();
            
            return $resultadoTipoCita;

        }else{
            $gruposArray = explode(',',$idGrupos);
            $total = [];

                        
            foreach($gruposArray as $grupo){
                $cantidad_presencial  = 0;
                $cantidad_en_linea = 0;

                $grupoArray = GrupoTrabajo::find($grupo)->where(['id' => $grupo])->orderBy('nombre')->one();
                 
                $sql_presencial =  "SELECT 
                            COUNT(T.id) cantidad,
                            IF(T.tipo_cita>0,'En Linea','Presencial') as tipo_cita
                        FROM
                            (SELECT 
                                p.id,
                                 ci.tipo_cita,             
                                    (SELECT 
                                            fecha
                                        FROM
                                            bitacora_paciente bp
                                        WHERE
                                            bp.id_paciente = p.id
                                                AND (bp.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')
                                        ORDER BY fecha DESC
                                        LIMIT 1) fecha
                            FROM
                                paciente p
                            INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id
                            INNER JOIN cita ci ON p.id = ci.id_paciente
                            WHERE
                                p.id_suscripcion = '".$suscripcion_id."'
                                    AND gt.id_suscripcion = '".$suscripcion_id."'
                                     AND p.id_grupo = '".$grupo."' ) T
                        WHERE
                            (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."') 
                            AND tipo_cita = 0
                            GROUP BY tipo_cita";

                $resultadoGrupos = \yii::$app->db->createCommand($sql_presencial)->queryAll();

                foreach($resultadoGrupos as $g){                   
                    $cantidad_presencial = $g['cantidad'];
                }

                $sql_en_linea =  "SELECT 
                            COUNT(T.id) cantidad,
                            IF(T.tipo_cita>0,'En Linea','Presencial') as tipo_cita
                        FROM
                            (SELECT 
                                p.id,
                                 ci.tipo_cita,             
                                    (SELECT 
                                            fecha
                                        FROM
                                            bitacora_paciente bp
                                        WHERE
                                            bp.id_paciente = p.id
                                                AND (bp.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')
                                        ORDER BY fecha DESC
                                        LIMIT 1) fecha
                            FROM
                                paciente p
                            INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id
                            INNER JOIN cita ci ON p.id = ci.id_paciente
                            WHERE
                                p.id_suscripcion = '".$suscripcion_id."'
                                    AND gt.id_suscripcion = '".$suscripcion_id."'
                                     AND p.id_grupo = '".$grupo."' ) T
                        WHERE
                            (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."') 
                            AND tipo_cita = 1
                            GROUP BY tipo_cita";

                $resultadoGrupos = \yii::$app->db->createCommand($sql_en_linea)->queryAll();

                foreach($resultadoGrupos as $g){                   
                    $cantidad_en_linea = $g['cantidad'];
                }


                  $total[$grupoArray->nombre]=array([
                        'estado'      =>'En Linea',
                        'cantidad'  => $cantidad_en_linea
                    ],[
                        'estado'      =>'Presencial',
                        'cantidad'  =>$cantidad_presencial
                    ] );
            }

            

            return $total;
        }
    }

    private function resultadoNivelSocial($suscripcion_id,$idGrupos,$fechaDesde,$fechaHasta,$group_by = true){
        if($group_by){
            $sql_nivel_social = "SELECT 
                                    COUNT(T.id) cantidad,
                                    T.nivel_social as nombre
                                FROM
                                    (SELECT 
                                        p.id,
                                        CASE ( p.nivel_socioeconomico)
                                            WHEN 'nivel_a_b' THEN 'Nivel A/B'
                                            WHEN 'nivel_c_mas' THEN 'Nivel C+'
                                            WHEN 'nivel_c' THEN 'Nivel C'
                                            WHEN 'nivel_d_mas' THEN 'Nivel D+'
                                            WHEN 'nivel_d' THEN 'Nivel D'
                                            WHEN 'nivel_e' THEN 'Nivel E'
                                            ELSE 'Otro'
                                        END AS nivel_social,           
                                            (SELECT 
                                                    fecha
                                                FROM
                                                    bitacora_paciente bp
                                                WHERE
                                                    bp.id_paciente = p.id
                                                        AND (bp.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')
                                                ORDER BY fecha DESC
                                                LIMIT 1) fecha
                                    FROM
                                        paciente p
                                    INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id
                                    WHERE
                                        p.id_suscripcion = '".$suscripcion_id."'
                                            AND gt.id_suscripcion = '".$suscripcion_id."'
                                            AND FIND_IN_SET(p.id_grupo, '".$idGrupos."')) T
                                WHERE
                                    (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."') 
                                    GROUP BY T.nivel_social";

                      
                         
            $resultadoNivelSocial= \yii::$app->db->createCommand($sql_nivel_social)->queryAll();
            
            return $resultadoNivelSocial;

        }else{
            $gruposArray = explode(',',$idGrupos);
            $total = [];

            

            foreach($gruposArray as $grupo){
                $cantidad_nivel_a_b = 0;
                $cantidad_nivel_c_mas = 0;
                $cantidad_nivel_c = 0;
                $cantidad_nivel_d_mas = 0;
                $cantidad_nivel_d = 0;
                $cantidad_nivel_e = 0;
                $cantidad_nivel_otro = 0;

                $grupoArray = GrupoTrabajo::find($grupo)->where(['id' => $grupo])->orderBy('nombre')->one();
                 
                $sql_nivel_social = "SELECT 
                                    COUNT(T.id) cantidad,
                                    T.nivel_social as nombre
                                FROM
                                    (SELECT 
                                        p.id,
                                        CASE ( p.nivel_socioeconomico)
                                            WHEN 'nivel_a_b' THEN 'Nivel A/B'
                                            WHEN 'nivel_c_mas' THEN 'Nivel C+'
                                            WHEN 'nivel_c' THEN 'Nivel C'
                                            WHEN 'nivel_d_mas' THEN 'Nivel D+'
                                            WHEN 'nivel_d' THEN 'Nivel D'
                                            WHEN 'nivel_e' THEN 'Nivel E'
                                            ELSE 'Otro'
                                        END AS nivel_social,           
                                            (SELECT 
                                                    fecha
                                                FROM
                                                    bitacora_paciente bp
                                                WHERE
                                                    bp.id_paciente = p.id
                                                        AND (bp.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')
                                                ORDER BY fecha DESC
                                                LIMIT 1) fecha
                                    FROM
                                        paciente p
                                    INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id
                                    WHERE
                                        p.id_suscripcion = '".$suscripcion_id."'
                                            AND gt.id_suscripcion = '".$suscripcion_id."'
                                            AND p.id_grupo = '".$grupo."' ) T
                                WHERE
                                    (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."') 
                                    AND T.nivel_social = 'Nivel A/B'
                                    GROUP BY T.nivel_social";

                $resultadoNivelSocial= \yii::$app->db->createCommand($sql_nivel_social)->queryAll();

                foreach($resultadoNivelSocial as $g){                   
                    $cantidad_nivel_a_b = $g['cantidad'];
                }
                //var_dump( $sql_nivel_social); exit();
                $sql_nivel_social = "SELECT 
                                    COUNT(T.id) cantidad,
                                    T.nivel_social as nombre
                                FROM
                                    (SELECT 
                                        p.id,
                                        CASE ( p.nivel_socioeconomico)
                                            WHEN 'nivel_a_b' THEN 'Nivel A/B'
                                            WHEN 'nivel_c_mas' THEN 'Nivel C+'
                                            WHEN 'nivel_c' THEN 'Nivel C'
                                            WHEN 'nivel_d_mas' THEN 'Nivel D+'
                                            WHEN 'nivel_d' THEN 'Nivel D'
                                            WHEN 'nivel_e' THEN 'Nivel E'
                                            ELSE 'Otro'
                                        END AS nivel_social,           
                                            (SELECT 
                                                    fecha
                                                FROM
                                                    bitacora_paciente bp
                                                WHERE
                                                    bp.id_paciente = p.id
                                                        AND (bp.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')
                                                ORDER BY fecha DESC
                                                LIMIT 1) fecha
                                    FROM
                                        paciente p
                                    INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id
                                    WHERE
                                        p.id_suscripcion = '".$suscripcion_id."'
                                            AND gt.id_suscripcion = '".$suscripcion_id."'
                                            AND p.id_grupo = '".$grupo."' ) T
                                WHERE
                                    (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."') 
                                    AND T.nivel_social = 'Nivel C+'
                                    GROUP BY T.nivel_social";

                $resultadoNivelSocial= \yii::$app->db->createCommand($sql_nivel_social)->queryAll();

                foreach($resultadoNivelSocial as $g){                   
                    $cantidad_nivel_c_mas = $g['cantidad'];
                }

                $sql_nivel_social = "SELECT 
                                    COUNT(T.id) cantidad,
                                    T.nivel_social as nombre
                                FROM
                                    (SELECT 
                                        p.id,
                                        CASE ( p.nivel_socioeconomico)
                                            WHEN 'nivel_a_b' THEN 'Nivel A/B'
                                            WHEN 'nivel_c_mas' THEN 'Nivel C+'
                                            WHEN 'nivel_c' THEN 'Nivel C'
                                            WHEN 'nivel_d_mas' THEN 'Nivel D+'
                                            WHEN 'nivel_d' THEN 'Nivel D'
                                            WHEN 'nivel_e' THEN 'Nivel E'
                                            ELSE 'Otro'
                                        END AS nivel_social,           
                                            (SELECT 
                                                    fecha
                                                FROM
                                                    bitacora_paciente bp
                                                WHERE
                                                    bp.id_paciente = p.id
                                                        AND (bp.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')
                                                ORDER BY fecha DESC
                                                LIMIT 1) fecha
                                    FROM
                                        paciente p
                                    INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id
                                    WHERE
                                        p.id_suscripcion = '".$suscripcion_id."'
                                            AND gt.id_suscripcion = '".$suscripcion_id."'
                                            AND p.id_grupo = '".$grupo."' ) T
                                WHERE
                                    (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."') 
                                    AND T.nivel_social = 'Nivel C'
                                    GROUP BY T.nivel_social";

                $resultadoNivelSocial= \yii::$app->db->createCommand($sql_nivel_social)->queryAll();

                foreach($resultadoNivelSocial as $g){                   
                    $cantidad_nivel_c = $g['cantidad'];
                }

                $sql_nivel_social = "SELECT 
                                    COUNT(T.id) cantidad,
                                    T.nivel_social as nombre
                                FROM
                                    (SELECT 
                                        p.id,
                                        CASE ( p.nivel_socioeconomico)
                                            WHEN 'nivel_a_b' THEN 'Nivel A/B'
                                            WHEN 'nivel_c_mas' THEN 'Nivel C+'
                                            WHEN 'nivel_c' THEN 'Nivel C'
                                            WHEN 'nivel_d_mas' THEN 'Nivel D+'
                                            WHEN 'nivel_d' THEN 'Nivel D'
                                            WHEN 'nivel_e' THEN 'Nivel E'
                                            ELSE 'Otro'
                                        END AS nivel_social,           
                                            (SELECT 
                                                    fecha
                                                FROM
                                                    bitacora_paciente bp
                                                WHERE
                                                    bp.id_paciente = p.id
                                                        AND (bp.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')
                                                ORDER BY fecha DESC
                                                LIMIT 1) fecha
                                    FROM
                                        paciente p
                                    INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id
                                    WHERE
                                        p.id_suscripcion = '".$suscripcion_id."'
                                            AND gt.id_suscripcion = '".$suscripcion_id."'
                                            AND p.id_grupo = '".$grupo."' ) T
                                WHERE
                                    (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."') 
                                    AND T.nivel_social = 'Nivel D+'
                                    GROUP BY T.nivel_social";

                $resultadoNivelSocial= \yii::$app->db->createCommand($sql_nivel_social)->queryAll();

                foreach($resultadoNivelSocial as $g){                   
                    $cantidad_nivel_d_mas = $g['cantidad'];
                }

                $sql_nivel_social = "SELECT 
                                    COUNT(T.id) cantidad,
                                    T.nivel_social as nombre
                                FROM
                                    (SELECT 
                                        p.id,
                                        CASE ( p.nivel_socioeconomico)
                                            WHEN 'nivel_a_b' THEN 'Nivel A/B'
                                            WHEN 'nivel_c_mas' THEN 'Nivel C+'
                                            WHEN 'nivel_c' THEN 'Nivel C'
                                            WHEN 'nivel_d_mas' THEN 'Nivel D+'
                                            WHEN 'nivel_d' THEN 'Nivel D'
                                            WHEN 'nivel_e' THEN 'Nivel E'
                                            ELSE 'Otro'
                                        END AS nivel_social,           
                                            (SELECT 
                                                    fecha
                                                FROM
                                                    bitacora_paciente bp
                                                WHERE
                                                    bp.id_paciente = p.id
                                                        AND (bp.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')
                                                ORDER BY fecha DESC
                                                LIMIT 1) fecha
                                    FROM
                                        paciente p
                                    INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id
                                    WHERE
                                        p.id_suscripcion = '".$suscripcion_id."'
                                            AND gt.id_suscripcion = '".$suscripcion_id."'
                                            AND p.id_grupo = '".$grupo."' ) T
                                WHERE
                                    (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."') 
                                    AND T.nivel_social = 'Nivel D'
                                    GROUP BY T.nivel_social";

                $resultadoNivelSocial= \yii::$app->db->createCommand($sql_nivel_social)->queryAll();

                foreach($resultadoNivelSocial as $g){                   
                    $cantidad_nivel_d = $g['cantidad'];
                }


                $sql_nivel_social = "SELECT 
                                    COUNT(T.id) cantidad,
                                    T.nivel_social as nombre
                                FROM
                                    (SELECT 
                                        p.id,
                                        CASE ( p.nivel_socioeconomico)
                                            WHEN 'nivel_a_b' THEN 'Nivel A/B'
                                            WHEN 'nivel_c_mas' THEN 'Nivel C+'
                                            WHEN 'nivel_c' THEN 'Nivel C'
                                            WHEN 'nivel_d_mas' THEN 'Nivel D+'
                                            WHEN 'nivel_d' THEN 'Nivel D'
                                            WHEN 'nivel_e' THEN 'Nivel E'
                                            ELSE 'Otro'
                                        END AS nivel_social,           
                                            (SELECT 
                                                    fecha
                                                FROM
                                                    bitacora_paciente bp
                                                WHERE
                                                    bp.id_paciente = p.id
                                                        AND (bp.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')
                                                ORDER BY fecha DESC
                                                LIMIT 1) fecha
                                    FROM
                                        paciente p
                                    INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id
                                    WHERE
                                        p.id_suscripcion = '".$suscripcion_id."'
                                            AND gt.id_suscripcion = '".$suscripcion_id."'
                                            AND p.id_grupo = '".$grupo."' ) T
                                WHERE
                                    (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."') 
                                    AND T.nivel_social = 'Nivel E'
                                    GROUP BY T.nivel_social";

                $resultadoNivelSocial= \yii::$app->db->createCommand($sql_nivel_social)->queryAll();

                foreach($resultadoNivelSocial as $g){                   
                    $cantidad_nivel_e = $g['cantidad'];
                }


                $sql_nivel_social = "SELECT 
                                    COUNT(T.id) cantidad,
                                    T.nivel_social as nombre
                                FROM
                                    (SELECT 
                                        p.id,
                                        CASE ( p.nivel_socioeconomico)
                                            WHEN 'nivel_a_b' THEN 'Nivel A/B'
                                            WHEN 'nivel_c_mas' THEN 'Nivel C+'
                                            WHEN 'nivel_c' THEN 'Nivel C'
                                            WHEN 'nivel_d_mas' THEN 'Nivel D+'
                                            WHEN 'nivel_d' THEN 'Nivel D'
                                            WHEN 'nivel_e' THEN 'Nivel E'
                                            ELSE 'Otro'
                                        END AS nivel_social,           
                                            (SELECT 
                                                    fecha
                                                FROM
                                                    bitacora_paciente bp
                                                WHERE
                                                    bp.id_paciente = p.id
                                                        AND (bp.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')
                                                ORDER BY fecha DESC
                                                LIMIT 1) fecha
                                    FROM
                                        paciente p
                                    INNER JOIN grupo_trabajo gt ON p.id_grupo = gt.id
                                    WHERE
                                        p.id_suscripcion = '".$suscripcion_id."'
                                            AND gt.id_suscripcion = '".$suscripcion_id."'
                                            AND p.id_grupo = '".$grupo."' ) T
                                WHERE
                                    (T.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."') 
                                    AND T.nivel_social = 'Otro'
                                    GROUP BY T.nivel_social";

                $resultadoNivelSocial= \yii::$app->db->createCommand($sql_nivel_social)->queryAll();

                foreach($resultadoNivelSocial as $g){                   
                    $cantidad_nivel_otro = $g['cantidad'];
                }


                $total[$grupoArray->nombre]=array(
                    [
                        'estado'    => 'Nivel A/B',
                        'cantidad'  => $cantidad_nivel_a_b
                    ],[
                        'estado'      =>'Nivel C+',
                        'cantidad'  =>$cantidad_nivel_c_mas
                    ],[
                        'estado'      =>'Nivel C',
                        'cantidad'  =>$cantidad_nivel_c
                    ],[
                        'estado'      =>'Nivel D+',
                        'cantidad'  =>$cantidad_nivel_d_mas
                    ],[
                        'estado'      =>'Nivel D',
                        'cantidad'  =>$cantidad_nivel_d
                    ],[
                        'estado'      =>'Nivel E',
                        'cantidad'  =>$cantidad_nivel_e
                    ],[
                        'estado'      =>'Nivel Otro',
                        'cantidad'  =>$cantidad_nivel_otro
                    ]
                );
            }

            

            return $total;
        }
    }


    private function resultadoProcedimiento($suscripcion_id,$idGrupos,$fechaDesde,$fechaHasta,$group_by = true){
        if($group_by){
            $sql_por_procedimiento =  "
                            SELECT 
                                count(*) cantidad,
                                pro.nombre
                            FROM procedimiento pro
                            INNER JOIN procedimiento_cita pc ON  
                                  pro.id = pc.id_procedimiento
                            INNER JOIN cita ci ON    
                                  ci.id = pc.id_cita
                            INNER JOIN paciente pa ON    
                                  pa.id = ci.id_paciente
                            INNER JOIN bitacora_paciente 
                                bp on bp.id_paciente = pa.id
                            WHERE pa.id_suscripcion =  '".$suscripcion_id."'
                            AND FIND_IN_SET(pa.id_grupo, '".$idGrupos."')
                            AND (ci.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')
                            GROUP BY pro.id
                            ORDER BY cantidad DESC
                            lIMIT 0,5";
                      

            $resultadoProcedimiento= \yii::$app->db->createCommand($sql_por_procedimiento)->queryAll();
            
            return $resultadoProcedimiento;

        }else{
            $gruposArray = explode(',',$idGrupos);
            $total = [];

            $cantidad_en_linea  = '0';
            $cantidad_evaluacion_completa = '0';
            
            foreach($gruposArray as $grupo){

                $cantidad_en_linea  = 0;
                $cantidad_evaluacion_completa = 0;
                $grupoArray = GrupoTrabajo::find($grupo)->where(['id' => $grupo])->orderBy('nombre')->one();
                 
                $sql_en_espera =  "
                            SELECT 
                                count(*) cantidad,
                                pro.nombre
                            FROM procedimiento pro
                            INNER JOIN procedimiento_cita pc ON  
                                  pro.id = pc.id_procedimiento
                            INNER JOIN cita ci ON    
                                  ci.id = pc.id_cita
                            INNER JOIN paciente pa ON    
                                  pa.id = ci.id_paciente
                            INNER JOIN bitacora_paciente 
                                bp on bp.id_paciente = pa.id
                            WHERE pa.id_suscripcion =  '".$suscripcion_id."'
                            AND pa.id_grupo = '".$grupo."'
                            AND (ci.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')
                            AND pro.nombre = 'Consulta en Línea'                            
                            GROUP BY pro.id
                            ORDER BY cantidad DESC
                            lIMIT 0,5";

                $resultadoGrupos = \yii::$app->db->createCommand($sql_en_espera)->queryAll();

                foreach($resultadoGrupos as $g){                   
                    $cantidad_en_linea = $g['cantidad'];
                }

                $sql_en_espera =  "
                            SELECT 
                                count(*) cantidad,
                                pro.nombre
                            FROM procedimiento pro
                            INNER JOIN procedimiento_cita pc ON  
                                  pro.id = pc.id_procedimiento
                            INNER JOIN cita ci ON    
                                  ci.id = pc.id_cita
                            INNER JOIN paciente pa ON    
                                  pa.id = ci.id_paciente
                            INNER JOIN bitacora_paciente 
                                bp on bp.id_paciente = pa.id
                            WHERE pa.id_suscripcion =  '".$suscripcion_id."'
                            AND pa.id_grupo = '".$grupo."'
                            AND (ci.fecha BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')
                            AND pro.nombre = 'Evaluación Completa'                            
                            GROUP BY pro.id
                            ORDER BY cantidad DESC
                            lIMIT 0,5";

                $resultadoGrupos = \yii::$app->db->createCommand($sql_en_espera)->queryAll();

                foreach($resultadoGrupos as $g){                   
                    $cantidad_evaluacion_completa = $g['cantidad'];
                }


                  $total[$grupoArray->nombre]=array([
                        'estado'      =>'Evaluación Completa',
                        'cantidad'  => $cantidad_evaluacion_completa
                    ],[
                        'estado'      =>'Consulta en Línea',
                        'cantidad'  =>$cantidad_en_linea
                    ] );
            }

            return $total;
        }
    }


    public function excludeFromSecurity() {
        return ['datos-citas-periodo', 'actividad-manana', 'retroalimentacion-periodo'];
    }
    
    public function beforeAction($action)
    {            
        if ($action->id == 'datos-citas-periodo' || $action->id == 'retroalimentacion-periodo') {
            $this->enableCsrfValidation = false;
        }

        return parent::beforeAction($action);
    }
}