<?php

namespace app\controllers;

use Yii;
use yii\data\ActiveDataProvider;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Usuario;
use app\models\RecordatorioDoctor;
use app\models\Paciente;
use yii\web\Response;
use app\customs\SesionUtils;
use app\models\Suscripcion;

/**
 * RecordatorioDoctorController implements the CRUD actions for RecordatorioDoctor model.
 */
class RecordatorioDoctorController extends BaseController
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all RecordatorioDoctor models.
     * @return mixed
     */
    public function actionIndex()
    {
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $id_suscripcion = $suscripcion->id;
        $query = RecordatorioDoctor::find()->where(['id_suscripcion' => $id_suscripcion]);
        if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA){
            $query->andWhere(['id_clinica' => SesionUtils::ClinicaSeleccionada()->id]);
        }
        $dataProvider = new ActiveDataProvider([
            'query' => $query
        ]);

        return $this->render('index', [
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single RecordatorioDoctor model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        $usuario = Yii::$app->user->identity;
        $model = $this->findModel($id);
        if($model->id_suscripcion != $usuario->suscripcion->id){
            //return $this->redirect(["site/forbidden"], 403);
            return $this->redirect(['recordatorio-doctor/index']);
        }
        return $this->render('view', [
            'model' => $model,
        ]);
    }

    /**
     * Creates a new RecordatorioDoctor model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new RecordatorioDoctor();
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $model->id_suscripcion = $suscripcion->id;
        $model->finalizado = 0;
        if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA){
            $model->id_clinica = SesionUtils::ClinicaSeleccionada()->id;
        }
        if ($model->load(Yii::$app->request->post()) && $model->save()){ 
            Yii::$app->session->setFlash('success', "El recordatorio con asunto ".$model->asuntoRecordatorio." se ha guardado exitosamente");
            //return $this->redirect(['view', 'id' => $model->id]);
            return $this->redirect(['recordatorio-doctor/index']);
        }
        $get = Yii::$app->request->get();
        $paciente = new Paciente();
        if(isset($get['pid'])){
            $paciente = Paciente::findOne(['id' => $get['pid'],'id_suscripcion' => $usuario->suscripcion->id]);
            $model->id_paciente = $get['pid'];
        }
        $this->bodyClass ="recordatorio-form";
        return $this->render('create', [
            'model' => $model,
            'paciente'=>$paciente
        ]);
    }

    /**
     * Updates an existing RecordatorioDoctor model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $usuario = Yii::$app->user->identity;
        if($model->id_suscripcion != $usuario->suscripcion->id){
            //return $this->redirect(["site/forbidden"], 403);
            return $this->redirect(['recordatorio-doctor/index']);
        }
        if($model->privacidad == 1  && $usuario->tipo == Usuario::ASISTENTE){
            //return $this->redirect(["site/forbidden"], 403);
            return $this->redirect(['recordatorio-doctor/index']);
        }
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', "El recordatorio con asunto  ".$model->asuntoRecordatorio." ha sido actualizado exitosamente");
            return $this->redirect(['view', 'id' => $model->id]);
        }
        $this->bodyClass ="recordatorio-form";
        return $this->render('update', [
            'model' => $model,
        ]);
    }
    
    public function actionFinalizado(){
        Yii::$app->response->format = Response::FORMAT_JSON;
        $post = Yii::$app->request->post();
        $usuario = Yii::$app->user->identity;
        if(Yii::$app->request->isAjax){
            $model = $this->findModel($post['id']);
            $model->finalizado = true;
            if($model->save()){
                return ['Correcto'=>true];
            }
        }
        return ['Correcto'=>false];
    }

    /**
     * Deletes an existing RecordatorioDoctor model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $usuario = Yii::$app->user->identity;
        $model = $this->findModel($id);
        if($model->id_suscripcion != $usuario->suscripcion->id){
            return $this->redirect(["site/forbidden"], 403);
        }
        if($model->privacidad == 1  && $usuario->tipo == Usuario::ASISTENTE){
            return $this->redirect(["site/forbidden"], 403);
        }
        $model->delete();
        Yii::$app->session->setFlash('danger', "Se ha eliminado el recordatorio con asunto".$model->asuntoRecordatorio);
        return $this->redirect(['index']);
    }

    /**
     * Finds the RecordatorioDoctor model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return RecordatorioDoctor the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = RecordatorioDoctor::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    public function excludeFromSecurity(){
         return ['finalizado'];
    }
    
    public function checkForSubscription() {
        return ['create','update'];
    }
}
