<?php

namespace app\controllers;

use Yii;
use app\models\Recordatorio;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * RecordatorioController implements the CRUD actions for Recordatorio model.
 */
class RecordatorioController extends BaseController
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'guardar-recordatorios' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Recordatorio models.
     * @return mixed
     */
    public function actionIndex()
    {
        $usuario = Yii::$app->user->identity;
        $id_suscripcion = $usuario->suscripcion->id;
        return $this->render('index', [
            'recordatorios' => Recordatorio::find()->where(['id_suscripcion' => $id_suscripcion])->all(),
        ]);
    }

    public function actionGuardarRecordatorios(){
        $post = \Yii::$app->request->post();
        $ids = $post['id_recordatorio'];
        $nombres = $post['nombre_recordatorio'];
        $tiempos = $post['tiempo_previo'];
        for ($i = 0; $i < 3; $i++){
            $id = $ids[$i];
            $nombre = $nombres[$i];
            $tiempo = $tiempos[$i];
            $unidad = $post['unidad_tiempo' . $id];
            $recordatorio = $this->findModel($id);
            $recordatorio->nombre = $nombre;
            $recordatorio->tiempo_previo = $tiempo;
            $recordatorio->unidad_tiempo = $unidad;
            $recordatorio->save();
        }
        Yii::$app->session->setFlash('success', "Se han actualizados los recordatorios.");
        return $this->redirect('index');
    }
    

    /**
     * Finds the Recordatorio model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Recordatorio the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Recordatorio::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
