<?php

namespace app\controllers;

use Yii;
use app\models\Receta;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use kartik\mpdf\Pdf;
use yii\web\Response;
use app\models\Clinica;
use app\customs\SesionUtils;
use app\models\Suscripcion;

/**
 * EventoController implements the CRUD actions for Evento model.
 */
class RecetaController extends BaseController
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Receta models.
     * @return mixed
     */
//    public function actionIndex()
//    {
//        $usuario = Yii::$app->user->identity;
//        $id_suscripcion = $usuario->suscripcion->id;
//        $dataProvider = new ActiveDataProvider([
//            'query' => Receta::find()->where(['id_suscripcion' => $id_suscripcion]),
//        ]);
//
//        return $this->render('index', [
//            'dataProvider' => $dataProvider,
//        ]);
//    }

    /**
     * Displays a single Receta model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = \Yii::$app->user->identity;
        $model = $this->findModel($id);
        if($model->id_suscripcion != $usuario->suscripcion->id){
            return $this->redirect(["site/forbidden"], 403);
        }
        $receta = [
            'id' => $model->id,
            'idSuscripcion' => $model->id_suscripcion,
            'idPaciente' => $model->id_paciente,
            'formatoReceta' => $model->receta,
            'receta' => $model->formatoReceta,
            'fechaCita' => $model->fecha_cita,
            'proximaCita' => $model->proxima_cita
            
            
        ];
        return ['Correcto'=>true, 'model'=>$receta];
    }
    

    /**
     * Creates a new Receta model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
    Yii::$app->response->format = Response::FORMAT_JSON;
        $model = new Receta();
        $usuario = Yii::$app->user->identity;
        $post = Yii::$app->request->post();
        if (Yii::$app->request->isAjax) {
            $model->id_suscripcion = $usuario->suscripcion->id;
            $model->id_paciente = $post['id_paciente'];
            $model->receta = $post['receta'];
            $model->fecha_cita = $post['fechaCita'];
            if($post['proximaCita'] != null || $post['proximaCita'] != ''){
                $model->proxima_cita = $post['proximaCita'];   
            }
            if($model->save()){
                return ['Correcto'=>true, 'id'=>$model->id];                
            }
        }
        return ['Correcto'=>false];
    }

    /**
     * Updates an existing Receta model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate()
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $post = Yii::$app->request->post();
        $model = $this->findModel($post['id']);
        if($model->id_suscripcion != $usuario->suscripcion->id){
            return $this->redirect(["site/forbidden"], 403);
        }
        if (Yii::$app->request->isAjax) {
            $model->receta = $post['receta'];
            $model->fecha_cita = $post['fechaCita'];
            if($post['proximaCita'] != null || $post['proximaCita'] != ''){
                $model->proxima_cita = $post['proximaCita'];   
            }
            if($model->save()){
                return ['Correcto'=>true, 'id'=>$model->id];                
            }
        }
        return ['Correcto'=>false];
    }
    
    
    public function actionRecetaPdf(){
        Yii::$app->response->format = Response::FORMAT_RAW;
        $get = Yii::$app->request->get();
        $usuario = \Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $confInfoReceta = SesionUtils::getLlaveValor('informacion_recetas_medicas');
        $prefijo = SesionUtils::getLlaveValor('identificativo_profesion')->valor;
        $model = $this->findModel($get['id']);
        $clinica = $suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL ? Clinica::findOne($get['clinica']) : null;
        if( $confInfoReceta->valor == 0 ){
            Yii::$app->session->setFlash('warning','Para continuar debe configurar la información para generar recetas y confirmar que se puede utilizar dicha información');
            return $this->redirect(["settings/index"]);
        }
        list($clinicaInfo,$infoMedico,$clinicaInfoHead,$logoSRC,$nombreMedReceta) = $this->infoContacto($suscripcion,$clinica,$confInfoReceta->posibles_valores,$prefijo);
        if($model->id_suscripcion != $usuario->suscripcion->id){
            return $this->redirect(["site/forbidden"], 403);
        }
        if( $clinica != null && $clinica->id_suscripcion != $usuario->suscripcion->id){
            return $this->redirect(["site/forbidden"], 403);
        }
        $firma = $usuario->suscripcion->firma;
        $data = [
            'paciente'        => $model->paciente->nombreCompleto,
            'medico'          => $nombreMedReceta,
            'infoMedico'      => $infoMedico,
            'clinicaInfoHead' => $clinicaInfoHead,
            'logoSRC'         => $logoSRC, 
            'fechaCita'       => $model->fecha_cita,
            'proximaCita'     => $model->proxima_cita != null ? $model->proxima_cita : 'Sin cita agendada',
            'receta'          => $model->formatoReceta,
            'clinicaInfo'     => $clinicaInfo,
            'copias'          => 2 
            
        ];
        $pdf = new Pdf([
            'mode'=>'',
            'destination'=> Pdf::DEST_BROWSER,
            'content' => $this->renderPartial('receta-pdf', ['model' => $data, 'firma'=>$firma]),
            'cssFile' => '../web/css/recetaPDF.css',
            'options' => [
            ],
            'methods' => [
                'SetTitle' => 'oliviahealth.com',
                'SetSubject' => 'Receta Médica',
                'SetHeader' => [''],
                'SetAuthor' => 'OliviaHealth',
                'SetCreator' => 'OliviaHealth',
                'SetKeywords' => '',
            ]           
        ]);
        
        return $pdf->render();
    }
    
    /**
     * @param  app\models\Suscripcion $suscripcion
     * @param  app\models\Clinica|null $clinica
     * @param  string $confReceta
     * @param  string $prefijo
     */
    private function infoContacto($suscripcion,$clinica,$confReceta,$prefijo){
        //nombre|apellido|tipoCedula|nCedula|especialidad|universidad|email|pais
        list($nombre,$apellido,$tipoCedula,$nCedula,$especialidad,$universidad,$email,$pais) = explode('|', $confReceta);
        $confNombrePublico = SesionUtils::getLlaveValor('nombre_publico')->valor;
        $nombreMedReceta = ucwords($prefijo).($prefijo == 'clinica' ? ' ' : '. ').$nombre.' '.$apellido;
        if( $suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA ){
            $clinicaInfo = $confNombrePublico .'<br>'.' '.'<br>'.($pais == '-' ? '' : $pais);
            $infoMedico = $especialidad.'<br>'.$universidad.'<br>'.$tipoCedula.' No. '.$nCedula;
            $tel_cel = $suscripcion->telefono_notificacion == null ? '' : $suscripcion->telefono_notificacion.'<br>';
            $clinicaInfoHead = $confNombrePublico .'<br>'.$tel_cel.($email == '-' ? '' : $email);
            $logoSRC = null;
        } else {
            $clinicaInfo = $clinica->nombre .'<br>'. ($clinica->direccion != null ? $clinica->direccion : 'Direción no definida').'<br>'.($pais == '-' ? '' : $pais);
            $infoMedico = $especialidad.'<br>'.$universidad.'<br>'.$tipoCedula.' No. '.$nCedula;
            $tel_cel = (($clinica->telefono == null && $clinica->celular == null) ? '' : 
                        ($clinica->telefono != null ? $clinica->telefono.($clinica->celular != null ? '|'.$clinica->celular.'<br>' 
                                : '<br>' ) : ($clinica->celular != null ? $clinica->celular.'<br>' : '') ));
            $clinicaInfoHead = $clinica->nombre .'<br>'.$tel_cel.($email == '-' ? '' : $email);
            $logoSRC = $clinica->logo_src_nombre == null ? null : $clinica->srcLogo;
        }
        
        return [$clinicaInfo,$infoMedico,$clinicaInfoHead,$logoSRC,$nombreMedReceta];
    }

    /**
     * Deletes an existing Receta model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete()
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $usuario = Yii::$app->user->identity;
        $post = Yii::$app->request->post();
        $model = $this->findModel($post['id']);
        if($model->id_suscripcion != $usuario->suscripcion->id){
            return ['Correcto'=>false];
        }
        $model->delete();
        return ['Correcto'=>true];
    }

    /**
     * Finds the Receta model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Evento the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Receta::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    public function excludeFromSecurity() {
        return ['create','view','update','delete',];
    }
    
    public function checkForSubscription() {
        return ['create','update'];
    }
}
