<?php

namespace app\controllers;

use Yii;
use app\models\Producto;
use yii\data\ActiveDataProvider;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Proveedor;
use app\models\CategoriaProducto;
use app\models\UnidadMedida;
use \yii\helpers\ArrayHelper;

/**
 * ProductoController implements the CRUD actions for Producto model.
 */
class ProductoController extends BaseController
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Producto models.
     * @return mixed
     */
    public function actionIndex()
    {
        $usuario = \Yii::$app->user->identity;
        $dataProvider = new ActiveDataProvider([
            'query' => Producto::find()->where(['id_suscripcion' => $usuario->suscripcion->id]),
        ]);

        return $this->render('index', [
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Producto model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Producto model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $usuario = \Yii::$app->user->identity;
        $model = new Producto();
        $model->id_suscripcion = $usuario->suscripcion->id;
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }
        $unidades = ArrayHelper::map(UnidadMedida::find()->orderBy("abreviatura ASC")->where(['id_suscripcion' => $usuario->suscripcion->id])->all(),'id','abreviatura');
        $proveedores = ArrayHelper::map(Proveedor::find()->orderBy("nombre ASC")->where(['id_suscripcion' => $usuario->suscripcion->id])->all(), 'id','nombre');
        $categorias = ArrayHelper::map(CategoriaProducto::find()->where(['id_suscripcion' => $usuario->suscripcion->id])->orderBy("nombre ASC")->all(), 'id','nombre');
        return $this->render('create', [
            'model' => $model,
            'unidades' => $unidades,
            'proveedores' => $proveedores,
            'categorias' => $categorias
        ]);
    }

    /**
     * Updates an existing Producto model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }
        $unidades = ArrayHelper::map(UnidadMedida::find()->where(['id_suscripcion' => $usuario->suscripcion->id])->orderBy("abreviatura ASC")->all(),'id','abreviatura');
        $proveedores = ArrayHelper::map(Proveedor::find()->where(['id_suscripcion' => $usuario->suscripcion->id])->orderBy("nombre ASC")->all(), 'id','nombre');
        $categorias = ArrayHelper::map(CategoriaProducto::find()->where(['id_suscripcion' => $usuario->suscripcion->id])->orderBy("nombre ASC")->all(), 'id','nombre');
        return $this->render('update', [
            'model' => $model,
            'unidades' => $unidades,
            'proveedores' => $proveedores,
            'categorias' => $categorias
        ]);
    }

    /**
     * Deletes an existing Producto model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Producto model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Producto the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Producto::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
