<?php

namespace app\controllers;

use Yii;
use app\models\Procedimiento;
use yii\data\ActiveDataProvider;
use app\customs\BaseController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Clinica;
use app\models\Usuario;
use yii\helpers\ArrayHelper;
use app\models\ClinicaProcedimiento;
use app\customs\SesionUtils;
use app\models\Suscripcion;
use app\models\GrupoTrabajo;
use app\models\UsuarioSuscripcion;
use app\models\GrupoTrabajoUsuario;
use app\models\GrupoProcedimiento;
/**
 * ProcedimientoController implements the CRUD actions for Procedimiento model.
 */
class ProcedimientoController extends BaseController
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Procedimiento models.
     * @return mixed
     */
    public function actionIndex()
    {
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $id_suscripcion = $suscripcion->id;
        
        $where = $usuario->tipo == Usuario::DOCTOR ? ["p.id_suscripcion" => $id_suscripcion] :  ["p.id_suscripcion" => $id_suscripcion];
        /* al quitar esto en el else del $where 'p.id_clinica' => SesionUtils::ClinicaSeleccionada()->id  
         * funciona la vista en perfil de asistente de lo contrario marca error de columna desconocida 'p.id_clinica'
         */
        $c = \Yii::$app->request->post('c');
        $query = Procedimiento::find()->alias('p')->where($where);
        $query = $this->filtrarPorClinicas($c,$query);
        $dataProvider = new ActiveDataProvider(['query' => $query]);
        $clinicas = [];
        if($suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL){
            $clinicas=Clinica::find()->where(['id_suscripcion' => $id_suscripcion])->all();
        }
        return $this->render('index', [
            'dataProvider' => $dataProvider,
            'clinicas'=> $clinicas,
            'clinicas_seleccionadas' => isset($c) ? $c : []
        ]);
    }
    
    /**
     * 
     * @param array $c
     * @param \yii\db\ActiveQuery $query
     * @return \yii\db\ActiveQuery
     */
    private function filtrarPorClinicas($c,$query){
        if(isset($c)){
            $query->innerJoin('clinica_procedimiento cp','cp.id_procedimiento=p.id');
            $innerWhere = [];
            if(count($c) > 1){
                $innerWhere[] = 'or';
                foreach ($c as $idc){
                    $innerWhere[] = ['cp.id_clinica' => $idc];
                }
            }
            else{
                foreach ($c as $idc){
                    $innerWhere = ['cp.id_clinica' => $idc];
                }
            }
            $query->andFilterWhere($innerWhere);
        }
        return $query;
    }

    /**
     * Displays a single Procedimiento model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        $usuario = Yii::$app->user->identity;
        $model = $this->findModel($id);
        if($model->id_suscripcion != $usuario->suscripcion->id){
            return $this->redirect(["site/forbidden"], 403);
        }
        
        return $this->render('view', [
            'model' => $model,
        ]);
    }

    /**
     * Creates a new Procedimiento model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Procedimiento();
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $model->id_suscripcion = $suscripcion->id;
        $post = Yii::$app->request->post();
        $clinicas = [];
        if($suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL && $usuario->tipo == Usuario::DOCTOR){
            $clinicas = ArrayHelper::map(Clinica::find()->where(['id_suscripcion' => $suscripcion->id])->all(),'id','nombre');
        }
        
        $grupos = $this->obtenerGrupos($suscripcion, $usuario);
        
        if($suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL && $model->load($post) 
                && !isset($post['clinicas']) 
                && $usuario->tipo == Usuario::DOCTOR){
            Yii::$app->session->setFlash('warning', 'Dede seleccionar al menos una clínica');
            return $this->render('create', [
                'model' => $model,
                'clinicas' => $clinicas,
                'grupos' => $grupos
            ]);
        }
        
        
        if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA && $model->load($post) 
                && !isset($post['grupos']) 
                && $usuario->tipo == Usuario::DOCTOR){
            Yii::$app->session->setFlash('warning', 'Dede seleccionar al menos un grupo');
            return $this->render('create', [
                'model' => $model,
                'clinicas' => $clinicas,
                'grupos' => $grupos
            ]);
        }
        
        if ($model->load($post) && $model->save()) {
            if($suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL){
                if($usuario->tipo == Usuario::DOCTOR){
                    $this->GuardarProcedimientoClinica($model->id, $post['clinicas']);
                } else {
                    $procedimientoClinica = new ClinicaProcedimiento();
                    $procedimientoClinica->id_clinica = SesionUtils::ClinicaSeleccionada()->id;
                    $procedimientoClinica->id_procedimiento = $model->id;
                    $procedimientoClinica->save();
                }
            }
            else{
                $this->GuardarProcedimientoGrupo($model->id, $post['grupos']);
            }
            Yii::$app->session->setFlash('success','El procedimiento '.$model->nombre.' se ha guardado exitosamente');
            return $this->redirect(['view', 'id' => $model->id]);
        }
        
        
        return $this->render('create', [
            'model' => $model,
            'clinicas' => $clinicas,
            'grupos' => $grupos
        ]);
    }
    
    private function obtenerGrupos($suscripcion,$usuario){
        $grupos = [];
        if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA){
            $tipoUsuarioJerarquia = $usuario->tipoUsuarioJerarquia;
            $grupoQuery = GrupoTrabajo::find()->where(['id_suscripcion' => $suscripcion->id]);
            if($tipoUsuarioJerarquia == UsuarioSuscripcion::TIPO_COORDINADOR 
                    || $tipoUsuarioJerarquia == UsuarioSuscripcion::TIPO_ASISTENTE){
                $gruposPermitidos = GrupoTrabajoUsuario::find()->where(['id_usuario' => $usuario->id])->select("id_grupo")->column();
                $grupos = $grupoQuery->where(['id' => $gruposPermitidos]);
            }
            $grupos = ArrayHelper::map($grupoQuery->all(),'id','nombre');
        }
        return $grupos;
    }

    /**
     * Updates an existing Procedimiento model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $usuario = Yii::$app->user->identity;
        $suscripcion = $usuario->suscripcion;
        $post = Yii::$app->request->post();
        $clinicas = [];
        if($usuario->tipo == Usuario::DOCTOR){
            $clinicas = ArrayHelper::map(Clinica::find()->where(['id_suscripcion' => $suscripcion->id])->all(),'id','nombre');
        }
        
        
        $grupos = $this->obtenerGrupos($suscripcion, $usuario);
        
        if($suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL 
                && $model->load($post) && !isset($post['clinicas']) && $usuario->tipo == Usuario::DOCTOR){
            Yii::$app->session->setFlash('warning', 'Dede seleccionar al menos una clínica');
            return $this->render('create', [
                'model' => $model,
                'clinicas' => $clinicas,
                'grupos' => $grupos
            ]);
        }
        
        if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA && $model->load($post) 
                && !isset($post['grupos']) 
                && $usuario->tipo == Usuario::DOCTOR){
            Yii::$app->session->setFlash('warning', 'Dede seleccionar al menos un grupo');
            return $this->render('create', [
                'model' => $model,
                'clinicas' => $clinicas,
                'grupos' => $grupos
            ]);
        }
        
        if ($model->load($post)){
            $model->id_suscripcion = $usuario->suscripcion->id;
            if($model->save()){
                if($suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL){
                    if($usuario->tipo == Usuario::DOCTOR){
                        $this->GuardarProcedimientoClinica($model->id, $post['clinicas']);
                    }
                }
                else{
                    $this->GuardarProcedimientoGrupo($model->id, $post['grupos']);
                }
                Yii::$app->session->setFlash('success', 'El procedimiento '.$model->nombre.' se ha actualizado correctamente');
                return $this->redirect(['view', 'id' => $model->id]);
            }
        }
        if($model->id_suscripcion != $usuario->suscripcion->id){
            return $this->redirect(["site/forbidden"], 403);
        }
        return $this->render('create', [
            'model' => $model,
            'clinicas' => $clinicas,
            'grupos' => $grupos
        ]);
    }

    /**
     * Deletes an existing Procedimiento model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $usuario = Yii::$app->user->identity;
        $model = $this->findModel($id);
        if($model->totalProcedimientoCitas > 0){
            
        }
        if($model->id_suscripcion != $usuario->suscripcion->id){
            return $this->redirect(["site/forbidden"], 403);
        }
        if($model->getProcedimientoCitas()->count() > 0){
            Yii::$app->session->setFlash("danger","El procedimiento no puede ser eliminado ya que cuenta con citas.");
            return $this->redirect(['index']);
        }
        $model->delete();
        Yii::$app->session->setFlash('danger', 'Se ha eliminado el procedimiento '.$model->nombre);
        return $this->redirect(['index']);
    }
    
    /**
     * 
     * @param int $idProcedimiento
     * @param int[] $idsSeleccionados
     */
    private function GuardarProcedimientoClinica($idProcedimiento,$idsSeleccionados){
        ClinicaProcedimiento::deleteAll(['id_procedimiento' => $idProcedimiento]);
        foreach($idsSeleccionados as $idClinica){
            $cp = new ClinicaProcedimiento();
            $cp->id_clinica = $idClinica;
            $cp->id_procedimiento = $idProcedimiento;
            $cp->save();
        }
    }
    
     /**
     * 
     * @param int $idProcedimiento
     * @param int[] $idsSeleccionados
     */
    private function GuardarProcedimientoGrupo($idProcedimiento,$idsSeleccionados){
        GrupoProcedimiento::deleteAll(['id_procedimiento' => $idProcedimiento]);
        foreach($idsSeleccionados as $idGrupo){
            $gp = new GrupoProcedimiento();
            $gp->id_grupo = $idGrupo;
            $gp->id_procedimiento = $idProcedimiento;
            $gp->save();
        }
    }

    /**
     * Finds the Procedimiento model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Procedimiento the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Procedimiento::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
